/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.lang.ref.SoftReference;
import org.eclipse.jgit.internal.storage.file.DeltaBaseCache$Entry;
import org.eclipse.jgit.internal.storage.file.DeltaBaseCache$Slot;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.storage.file.WindowCacheConfig;

class DeltaBaseCache {
    private static final int CACHE_SZ = 1024;
    static final SoftReference DEAD = new SoftReference<Object>(null);
    private static volatile int defaultMaxByteCount;
    private final int maxByteCount = defaultMaxByteCount;
    private final DeltaBaseCache$Slot[] cache = new DeltaBaseCache$Slot[1024];
    private DeltaBaseCache$Slot lruHead;
    private DeltaBaseCache$Slot lruTail;
    private int openByteCount;

    private static int hash(long l2) {
        return (int)l2 << 22 >>> 22;
    }

    static void reconfigure(WindowCacheConfig windowCacheConfig) {
        defaultMaxByteCount = windowCacheConfig.getDeltaBaseCacheLimit();
    }

    DeltaBaseCache() {
    }

    DeltaBaseCache$Entry get(Pack pack, long l2) {
        DeltaBaseCache$Entry deltaBaseCache$Entry;
        DeltaBaseCache$Slot deltaBaseCache$Slot = this.cache[DeltaBaseCache.hash(l2)];
        if (deltaBaseCache$Slot == null) {
            return null;
        }
        if (deltaBaseCache$Slot.provider == pack && deltaBaseCache$Slot.position == l2 && (deltaBaseCache$Entry = (DeltaBaseCache$Entry)deltaBaseCache$Slot.data.get()) != null) {
            this.moveToHead(deltaBaseCache$Slot);
            return deltaBaseCache$Entry;
        }
        return null;
    }

    void store(Pack pack, long l2, byte[] byArray, int n2) {
        if (byArray.length > this.maxByteCount) {
            return;
        }
        DeltaBaseCache$Slot deltaBaseCache$Slot = this.cache[DeltaBaseCache.hash(l2)];
        if (deltaBaseCache$Slot == null) {
            this.cache[DeltaBaseCache.hash((long)l2)] = deltaBaseCache$Slot = new DeltaBaseCache$Slot(null);
        } else {
            this.clearEntry(deltaBaseCache$Slot);
        }
        this.openByteCount += byArray.length;
        this.releaseMemory();
        deltaBaseCache$Slot.provider = pack;
        deltaBaseCache$Slot.position = l2;
        deltaBaseCache$Slot.sz = byArray.length;
        deltaBaseCache$Slot.data = new SoftReference<DeltaBaseCache$Entry>(new DeltaBaseCache$Entry(byArray, n2));
        this.moveToHead(deltaBaseCache$Slot);
    }

    private void releaseMemory() {
        while (this.openByteCount > this.maxByteCount && this.lruTail != null) {
            DeltaBaseCache$Slot deltaBaseCache$Slot = this.lruTail;
            DeltaBaseCache$Slot deltaBaseCache$Slot2 = deltaBaseCache$Slot.lruPrev;
            this.clearEntry(deltaBaseCache$Slot);
            deltaBaseCache$Slot.lruPrev = null;
            deltaBaseCache$Slot.lruNext = null;
            if (deltaBaseCache$Slot2 == null) {
                this.lruHead = null;
            } else {
                deltaBaseCache$Slot2.lruNext = null;
            }
            this.lruTail = deltaBaseCache$Slot2;
        }
    }

    private void moveToHead(DeltaBaseCache$Slot deltaBaseCache$Slot) {
        this.unlink(deltaBaseCache$Slot);
        deltaBaseCache$Slot.lruPrev = null;
        deltaBaseCache$Slot.lruNext = this.lruHead;
        if (this.lruHead != null) {
            this.lruHead.lruPrev = deltaBaseCache$Slot;
        } else {
            this.lruTail = deltaBaseCache$Slot;
        }
        this.lruHead = deltaBaseCache$Slot;
    }

    private void unlink(DeltaBaseCache$Slot deltaBaseCache$Slot) {
        DeltaBaseCache$Slot deltaBaseCache$Slot2 = deltaBaseCache$Slot.lruPrev;
        DeltaBaseCache$Slot deltaBaseCache$Slot3 = deltaBaseCache$Slot.lruNext;
        if (deltaBaseCache$Slot2 != null) {
            deltaBaseCache$Slot2.lruNext = deltaBaseCache$Slot3;
        }
        if (deltaBaseCache$Slot3 != null) {
            deltaBaseCache$Slot3.lruPrev = deltaBaseCache$Slot2;
        }
    }

    private void clearEntry(DeltaBaseCache$Slot deltaBaseCache$Slot) {
        this.openByteCount -= deltaBaseCache$Slot.sz;
        deltaBaseCache$Slot.provider = null;
        deltaBaseCache$Slot.data = DEAD;
        deltaBaseCache$Slot.sz = 0;
    }

    static {
        DeltaBaseCache.reconfigure(new WindowCacheConfig());
    }
}

