/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.internal.storage.file.CachedObjectDirectory$UnpackedObjectId;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase$InsertLooseObjectResult;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory$AlternateHandle;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory$AlternateHandle$Id;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FS;

class CachedObjectDirectory
extends FileObjectDatabase {
    private ObjectIdOwnerMap unpackedObjects;
    private final ObjectDirectory wrapped;
    private CachedObjectDirectory[] alts;

    CachedObjectDirectory(ObjectDirectory objectDirectory) {
        this.wrapped = objectDirectory;
        this.unpackedObjects = this.scanLoose();
    }

    private ObjectIdOwnerMap scanLoose() {
        ObjectIdOwnerMap objectIdOwnerMap = new ObjectIdOwnerMap();
        File file = this.wrapped.getDirectory();
        String[] stringArray = file.list();
        if (stringArray == null) {
            return objectIdOwnerMap;
        }
        for (String string : stringArray) {
            String[] stringArray2;
            if (string.length() != 2 || (stringArray2 = new File(file, string).list()) == null) continue;
            for (String string2 : stringArray2) {
                if (string2.length() != 38) continue;
                try {
                    ObjectId objectId = ObjectId.fromString(string + string2);
                    objectIdOwnerMap.add(new CachedObjectDirectory$UnpackedObjectId(objectId));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return objectIdOwnerMap;
    }

    @Override
    public void close() {
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this;
    }

    @Override
    File getDirectory() {
        return this.wrapped.getDirectory();
    }

    @Override
    File fileFor(AnyObjectId anyObjectId) {
        return this.wrapped.fileFor(anyObjectId);
    }

    @Override
    Config getConfig() {
        return this.wrapped.getConfig();
    }

    @Override
    FS getFS() {
        return this.wrapped.getFS();
    }

    @Override
    Set getShallowCommits() {
        return this.wrapped.getShallowCommits();
    }

    private CachedObjectDirectory[] myAlternates() {
        if (this.alts == null) {
            ObjectDirectory$AlternateHandle[] objectDirectory$AlternateHandleArray = this.wrapped.myAlternates();
            this.alts = new CachedObjectDirectory[objectDirectory$AlternateHandleArray.length];
            for (int i2 = 0; i2 < this.alts.length; ++i2) {
                this.alts[i2] = objectDirectory$AlternateHandleArray[i2].db.newCachedFileObjectDatabase();
            }
        }
        return this.alts;
    }

    private Set skipMe(Set set) {
        HashSet<ObjectDirectory$AlternateHandle$Id> hashSet = new HashSet<ObjectDirectory$AlternateHandle$Id>();
        if (set != null) {
            hashSet.addAll(set);
        }
        hashSet.add(this.getAlternateId());
        return hashSet;
    }

    @Override
    void resolve(Set set, AbbreviatedObjectId abbreviatedObjectId) {
        this.wrapped.resolve(set, abbreviatedObjectId);
    }

    @Override
    public boolean has(AnyObjectId anyObjectId) {
        return this.has(anyObjectId, null);
    }

    private boolean has(AnyObjectId anyObjectId, Set set) {
        if (this.unpackedObjects.contains(anyObjectId)) {
            return true;
        }
        if (this.wrapped.hasPackedObject(anyObjectId)) {
            return true;
        }
        set = this.skipMe(set);
        for (CachedObjectDirectory cachedObjectDirectory : this.myAlternates()) {
            if (set.contains(cachedObjectDirectory.getAlternateId()) || !cachedObjectDirectory.has(anyObjectId, set)) continue;
            return true;
        }
        return false;
    }

    @Override
    ObjectLoader openObject(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        return this.openObject(windowCursor, anyObjectId, null);
    }

    private ObjectLoader openObject(WindowCursor windowCursor, AnyObjectId anyObjectId, Set set) {
        ObjectLoader objectLoader = this.openLooseObject(windowCursor, anyObjectId);
        if (objectLoader != null) {
            return objectLoader;
        }
        objectLoader = this.wrapped.openPackedObject(windowCursor, anyObjectId);
        if (objectLoader != null) {
            return objectLoader;
        }
        set = this.skipMe(set);
        for (CachedObjectDirectory cachedObjectDirectory : this.myAlternates()) {
            if (set.contains(cachedObjectDirectory.getAlternateId()) || (objectLoader = cachedObjectDirectory.openObject(windowCursor, anyObjectId, set)) == null) continue;
            return objectLoader;
        }
        return null;
    }

    @Override
    long getObjectSize(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        return this.wrapped.getObjectSize(windowCursor, anyObjectId);
    }

    @Override
    ObjectLoader openLooseObject(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        if (this.unpackedObjects.contains(anyObjectId)) {
            ObjectLoader objectLoader = this.wrapped.openLooseObject(windowCursor, anyObjectId);
            if (objectLoader != null) {
                return objectLoader;
            }
            this.unpackedObjects = this.scanLoose();
        }
        return null;
    }

    @Override
    FileObjectDatabase$InsertLooseObjectResult insertUnpackedObject(File file, ObjectId objectId, boolean bl2) {
        FileObjectDatabase$InsertLooseObjectResult fileObjectDatabase$InsertLooseObjectResult = this.wrapped.insertUnpackedObject(file, objectId, bl2);
        switch (fileObjectDatabase$InsertLooseObjectResult) {
            case INSERTED: 
            case EXISTS_LOOSE: {
                this.unpackedObjects.addIfAbsent(new CachedObjectDirectory$UnpackedObjectId(objectId));
                break;
            }
        }
        return fileObjectDatabase$InsertLooseObjectResult;
    }

    @Override
    Pack openPack(File file) {
        return this.wrapped.openPack(file);
    }

    @Override
    void selectObjectRepresentation(PackWriter packWriter, ObjectToPack objectToPack, WindowCursor windowCursor) {
        this.wrapped.selectObjectRepresentation(packWriter, objectToPack, windowCursor);
    }

    @Override
    Collection getPacks() {
        return this.wrapped.getPacks();
    }

    private ObjectDirectory$AlternateHandle$Id getAlternateId() {
        return this.wrapped.getAlternateId();
    }
}

