/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.nio.ByteBuffer;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class ByteBufferWindow
extends ByteWindow {
    private final ByteBuffer buffer;

    ByteBufferWindow(Pack pack, long l2, ByteBuffer byteBuffer) {
        super(pack, l2, byteBuffer.capacity());
        this.buffer = byteBuffer;
    }

    @Override
    protected int copy(int n2, byte[] byArray, int n3, int n4) {
        ByteBuffer byteBuffer = this.buffer.slice();
        byteBuffer.position(n2);
        n4 = Math.min(byteBuffer.remaining(), n4);
        byteBuffer.get(byArray, n3, n4);
        return n4;
    }

    @Override
    void write(PackOutputStream packOutputStream, long l2, int n2) {
        ByteBuffer byteBuffer = this.buffer.slice();
        byteBuffer.position((int)(l2 - this.start));
        while (0 < n2) {
            byte[] byArray = packOutputStream.getCopyBuffer();
            int n3 = Math.min(n2, byArray.length);
            byteBuffer.get(byArray, 0, n3);
            packOutputStream.write(byArray, 0, n3);
            n2 -= n3;
        }
    }

    @Override
    protected int setInput(int n2, Inflater inflater) {
        ByteBuffer byteBuffer = this.buffer.slice();
        byteBuffer.position(n2);
        byte[] byArray = new byte[Math.min(byteBuffer.remaining(), 512)];
        byteBuffer.get(byArray, 0, byArray.length);
        inflater.setInput(byArray, 0, byArray.length);
        return byArray.length;
    }
}

