/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.util.zip.CRC32;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class ByteArrayWindow
extends ByteWindow {
    private final byte[] array;

    ByteArrayWindow(Pack pack, long l2, byte[] byArray) {
        super(pack, l2, byArray.length);
        this.array = byArray;
    }

    @Override
    protected int copy(int n2, byte[] byArray, int n3, int n4) {
        n4 = Math.min(this.array.length - n2, n4);
        System.arraycopy(this.array, n2, byArray, n3, n4);
        return n4;
    }

    @Override
    protected int setInput(int n2, Inflater inflater) {
        int n3 = this.array.length - n2;
        inflater.setInput(this.array, n2, n3);
        return n3;
    }

    void crc32(CRC32 cRC32, long l2, int n2) {
        cRC32.update(this.array, (int)(l2 - this.start), n2);
    }

    @Override
    void write(PackOutputStream packOutputStream, long l2, int n2) {
        int n3 = (int)(l2 - this.start);
        packOutputStream.write(this.array, n3, n2);
    }

    void check(Inflater inflater, byte[] byArray, long l2, int n2) {
        inflater.setInput(this.array, (int)(l2 - this.start), n2);
        while (inflater.inflate(byArray, 0, byArray.length) > 0) {
        }
    }
}

