/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl$CompressedBitmap;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl$CompressedBitmapBuilder;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl$MutableBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;

public class BitmapIndexImpl
implements BitmapIndex {
    private static final int EXTRA_BITS = 10240;
    final PackBitmapIndex packIndex;
    final BitmapIndexImpl$MutableBitmapIndex mutableIndex;
    final int indexObjectCount;

    public BitmapIndexImpl(PackBitmapIndex packBitmapIndex) {
        this.packIndex = packBitmapIndex;
        this.mutableIndex = new BitmapIndexImpl$MutableBitmapIndex(null);
        this.indexObjectCount = packBitmapIndex.getObjectCount();
    }

    PackBitmapIndex getPackBitmapIndex() {
        return this.packIndex;
    }

    @Override
    public BitmapIndexImpl$CompressedBitmap getBitmap(AnyObjectId anyObjectId) {
        EWAHCompressedBitmap eWAHCompressedBitmap = this.packIndex.getBitmap(anyObjectId);
        if (eWAHCompressedBitmap == null) {
            return null;
        }
        return new BitmapIndexImpl$CompressedBitmap(eWAHCompressedBitmap, this);
    }

    @Override
    public BitmapIndexImpl$CompressedBitmapBuilder newBitmapBuilder() {
        return new BitmapIndexImpl$CompressedBitmapBuilder(this);
    }

    int findPosition(AnyObjectId anyObjectId) {
        int n2 = this.packIndex.findPosition(anyObjectId);
        if (n2 < 0 && (n2 = this.mutableIndex.findPosition(anyObjectId)) >= 0) {
            n2 += this.indexObjectCount;
        }
        return n2;
    }

    int findOrInsert(AnyObjectId anyObjectId, int n2) {
        int n3 = this.findPosition(anyObjectId);
        if (n3 < 0) {
            n3 = this.mutableIndex.findOrInsert(anyObjectId, n2);
            n3 += this.indexObjectCount;
        }
        return n3;
    }

    static final EWAHCompressedBitmap ones(int n2) {
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap();
        eWAHCompressedBitmap.addStreamOfEmptyWords(true, n2 / 64);
        int n3 = n2 % 64;
        if (n3 > 0) {
            eWAHCompressedBitmap.addWord((1L << n3) - 1L, n3);
        }
        return eWAHCompressedBitmap;
    }
}

