/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import java.util.Iterator;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl$ComboBitset;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl$CompressedBitmap;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex$Bitmap;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;

final class BitmapIndexImpl$CompressedBitmapBuilder
implements BitmapIndex$BitmapBuilder {
    private BitmapIndexImpl$ComboBitset bitset = new BitmapIndexImpl$ComboBitset();
    private final BitmapIndexImpl bitmapIndex;

    BitmapIndexImpl$CompressedBitmapBuilder(BitmapIndexImpl bitmapIndexImpl) {
        this.bitmapIndex = bitmapIndexImpl;
    }

    @Override
    public boolean contains(AnyObjectId anyObjectId) {
        int n2 = this.bitmapIndex.findPosition(anyObjectId);
        return 0 <= n2 && this.bitset.contains(n2);
    }

    @Override
    public BitmapIndex$BitmapBuilder addObject(AnyObjectId anyObjectId, int n2) {
        this.bitset.set(this.bitmapIndex.findOrInsert(anyObjectId, n2));
        return this;
    }

    @Override
    public void remove(AnyObjectId anyObjectId) {
        int n2 = this.bitmapIndex.findPosition(anyObjectId);
        if (0 <= n2) {
            this.bitset.remove(n2);
        }
    }

    @Override
    public BitmapIndexImpl$CompressedBitmapBuilder or(BitmapIndex$Bitmap bitmapIndex$Bitmap) {
        this.bitset.or(this.ewahBitmap(bitmapIndex$Bitmap));
        return this;
    }

    @Override
    public BitmapIndexImpl$CompressedBitmapBuilder andNot(BitmapIndex$Bitmap bitmapIndex$Bitmap) {
        this.bitset.andNot(this.ewahBitmap(bitmapIndex$Bitmap));
        return this;
    }

    @Override
    public BitmapIndexImpl$CompressedBitmapBuilder xor(BitmapIndex$Bitmap bitmapIndex$Bitmap) {
        this.bitset.xor(this.ewahBitmap(bitmapIndex$Bitmap));
        return this;
    }

    @Override
    public BitmapIndexImpl$CompressedBitmap build() {
        return new BitmapIndexImpl$CompressedBitmap(this.bitset.combine(), this.bitmapIndex);
    }

    @Override
    public Iterator iterator() {
        return this.build().iterator();
    }

    @Override
    public int cardinality() {
        return this.bitset.combine().cardinality();
    }

    @Override
    public boolean removeAllOrNone(PackBitmapIndex packBitmapIndex) {
        if (!this.bitmapIndex.packIndex.equals(packBitmapIndex)) {
            return false;
        }
        EWAHCompressedBitmap eWAHCompressedBitmap = this.bitset.combine().xor(BitmapIndexImpl.ones(this.bitmapIndex.indexObjectCount));
        IntIterator intIterator = eWAHCompressedBitmap.intIterator();
        if (intIterator.hasNext() && intIterator.next() < this.bitmapIndex.indexObjectCount) {
            return false;
        }
        this.bitset = new BitmapIndexImpl$ComboBitset(eWAHCompressedBitmap);
        return true;
    }

    @Override
    public BitmapIndexImpl getBitmapIndex() {
        return this.bitmapIndex;
    }

    @Override
    public EWAHCompressedBitmap retrieveCompressed() {
        return this.build().retrieveCompressed();
    }

    private EWAHCompressedBitmap ewahBitmap(BitmapIndex$Bitmap bitmapIndex$Bitmap) {
        if (bitmapIndex$Bitmap instanceof BitmapIndexImpl$CompressedBitmap) {
            BitmapIndexImpl$CompressedBitmap bitmapIndexImpl$CompressedBitmap = (BitmapIndexImpl$CompressedBitmap)bitmapIndex$Bitmap;
            if (bitmapIndexImpl$CompressedBitmap.bitmapIndex != this.bitmapIndex) {
                throw new IllegalArgumentException();
            }
            return bitmapIndexImpl$CompressedBitmap.bitmap;
        }
        if (bitmapIndex$Bitmap instanceof BitmapIndexImpl$CompressedBitmapBuilder) {
            BitmapIndexImpl$CompressedBitmapBuilder bitmapIndexImpl$CompressedBitmapBuilder = (BitmapIndexImpl$CompressedBitmapBuilder)bitmapIndex$Bitmap;
            if (bitmapIndexImpl$CompressedBitmapBuilder.bitmapIndex != this.bitmapIndex) {
                throw new IllegalArgumentException();
            }
            return bitmapIndexImpl$CompressedBitmapBuilder.bitset.combine();
        }
        throw new IllegalArgumentException();
    }

    static /* synthetic */ BitmapIndexImpl access$400(BitmapIndexImpl$CompressedBitmapBuilder bitmapIndexImpl$CompressedBitmapBuilder) {
        return bitmapIndexImpl$CompressedBitmapBuilder.bitmapIndex;
    }

    static /* synthetic */ BitmapIndexImpl$ComboBitset access$500(BitmapIndexImpl$CompressedBitmapBuilder bitmapIndexImpl$CompressedBitmapBuilder) {
        return bitmapIndexImpl$CompressedBitmapBuilder.bitset;
    }
}

