/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.util.Arrays;

final class BitSet {
    private long[] words;

    BitSet(int n2) {
        this.words = new long[BitSet.block(n2) + 1];
    }

    final void clear() {
        Arrays.fill(this.words, 0L);
    }

    final void set(int n2) {
        int n3 = BitSet.block(n2);
        if (n3 >= this.words.length) {
            long[] lArray = new long[2 * BitSet.block(n2)];
            System.arraycopy(this.words, 0, lArray, 0, this.words.length);
            this.words = lArray;
        }
        int n4 = n3;
        this.words[n4] = this.words[n4] | BitSet.mask(n2);
    }

    final void clear(int n2) {
        int n3 = BitSet.block(n2);
        if (n3 < this.words.length) {
            int n4 = n3;
            this.words[n4] = this.words[n4] & (BitSet.mask(n2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    final boolean get(int n2) {
        int n3 = BitSet.block(n2);
        return n3 < this.words.length && (this.words[n3] & BitSet.mask(n2)) != 0L;
    }

    final EWAHCompressedBitmap toEWAHCompressedBitmap() {
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap(this.words.length);
        int n2 = 0;
        long l2 = 0L;
        for (long l3 : this.words) {
            if (l3 == 0L) {
                ++n2;
                continue;
            }
            if (l2 != 0L) {
                eWAHCompressedBitmap.addWord(l2);
            }
            if (n2 > 0) {
                eWAHCompressedBitmap.addStreamOfEmptyWords(false, n2);
                n2 = 0;
            }
            l2 = l3;
        }
        int n3 = 64 - Long.numberOfLeadingZeros(l2);
        if (n3 > 0) {
            eWAHCompressedBitmap.addWord(l2, n3);
        }
        return eWAHCompressedBitmap;
    }

    private static final int block(int n2) {
        return n2 >> 6;
    }

    private static final long mask(int n2) {
        return 1L << n2;
    }
}

