/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.PackInputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.ObjectStream$Filter;

final class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final DfsPackFile pack;
    private final DfsObjDatabase db;

    LargePackedWholeObject(int n2, long l2, long l3, int n3, DfsPackFile dfsPackFile, DfsObjDatabase dfsObjDatabase) {
        this.type = n2;
        this.size = l2;
        this.objectOffset = l3;
        this.headerLength = n3;
        this.pack = dfsPackFile;
        this.db = dfsObjDatabase;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isLarge() {
        return true;
    }

    @Override
    public byte[] getCachedBytes() {
        throw new LargeObjectException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectStream openStream() {
        PackInputStream packInputStream;
        try (DfsReader dfsReader = this.db.newReader();){
            try {
                packInputStream = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, dfsReader);
                dfsReader = null;
            }
            catch (IOException iOException) {
                ObjectId objectId = this.pack.getReverseIdx(dfsReader).findObject(this.objectOffset);
                ObjectStream objectStream = dfsReader.open(objectId, this.type).openStream();
                if (dfsReader != null) {
                    dfsReader.close();
                }
                return objectStream;
            }
        }
        int n2 = 8192;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(packInputStream, packInputStream.ctx.inflater(), n2), n2);
        return new ObjectStream$Filter(this.type, this.size, bufferedInputStream);
    }
}

