/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository$ByteArrayReadableChannel;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository$MemObjDatabase$1;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository$MemPack;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public class InMemoryRepository$MemObjDatabase
extends DfsObjDatabase {
    private List packs = new ArrayList();
    private int blockSize;

    InMemoryRepository$MemObjDatabase(DfsRepository dfsRepository) {
        super(dfsRepository, new DfsReaderOptions());
    }

    public void setReadableChannelBlockSizeForTest(int n2) {
        this.blockSize = n2;
    }

    @Override
    protected synchronized List listPacks() {
        return this.packs;
    }

    @Override
    protected DfsPackDescription newPack(DfsObjDatabase$PackSource dfsObjDatabase$PackSource) {
        int n2 = InMemoryRepository.packId.incrementAndGet();
        return new InMemoryRepository$MemPack("pack-" + n2 + "-" + dfsObjDatabase$PackSource.name(), this.getRepository().getDescription(), dfsObjDatabase$PackSource);
    }

    @Override
    protected synchronized void commitPackImpl(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection.size() + this.packs.size());
        arrayList.addAll(collection);
        arrayList.addAll(this.packs);
        if (collection2 != null) {
            arrayList.removeAll(collection2);
        }
        this.packs = arrayList;
        this.clearCache();
    }

    @Override
    protected void rollbackPack(Collection collection) {
    }

    @Override
    protected ReadableChannel openFile(DfsPackDescription dfsPackDescription, PackExt packExt) {
        InMemoryRepository$MemPack inMemoryRepository$MemPack = (InMemoryRepository$MemPack)dfsPackDescription;
        byte[] byArray = inMemoryRepository$MemPack.get(packExt);
        if (byArray == null) {
            throw new FileNotFoundException(dfsPackDescription.getFileName(packExt));
        }
        return new InMemoryRepository$ByteArrayReadableChannel(byArray, this.blockSize);
    }

    @Override
    protected DfsOutputStream writeFile(DfsPackDescription dfsPackDescription, PackExt packExt) {
        InMemoryRepository$MemPack inMemoryRepository$MemPack = (InMemoryRepository$MemPack)dfsPackDescription;
        return new InMemoryRepository$MemObjDatabase$1(this, inMemoryRepository$MemPack, packExt);
    }
}

