/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.nio.ByteBuffer;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;

class InMemoryRepository$ByteArrayReadableChannel
implements ReadableChannel {
    private final byte[] data;
    private final int blockSize;
    private int position;
    private boolean open = true;

    InMemoryRepository$ByteArrayReadableChannel(byte[] byArray, int n2) {
        this.data = byArray;
        this.blockSize = n2;
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        int n2 = Math.min(byteBuffer.remaining(), this.data.length - this.position);
        if (n2 == 0) {
            return -1;
        }
        byteBuffer.put(this.data, this.position, n2);
        this.position += n2;
        return n2;
    }

    @Override
    public void close() {
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void position(long l2) {
        this.position = (int)l2;
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public void setReadAheadBytes(int n2) {
    }
}

