/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.File;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;

public abstract class DfsRepositoryBuilder
extends BaseRepositoryBuilder {
    private DfsReaderOptions readerOptions;
    private DfsRepositoryDescription repoDesc;

    public DfsReaderOptions getReaderOptions() {
        return this.readerOptions;
    }

    public DfsRepositoryBuilder setReaderOptions(DfsReaderOptions dfsReaderOptions) {
        this.readerOptions = dfsReaderOptions;
        return (DfsRepositoryBuilder)this.self();
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public DfsRepositoryBuilder setRepositoryDescription(DfsRepositoryDescription dfsRepositoryDescription) {
        this.repoDesc = dfsRepositoryDescription;
        return (DfsRepositoryBuilder)this.self();
    }

    @Override
    public DfsRepositoryBuilder setup() {
        super.setup();
        if (this.getReaderOptions() == null) {
            this.setReaderOptions(new DfsReaderOptions());
        }
        if (this.getRepositoryDescription() == null) {
            this.setRepositoryDescription(new DfsRepositoryDescription());
        }
        return (DfsRepositoryBuilder)this.self();
    }

    @Override
    public abstract DfsRepository build();

    @Override
    public DfsRepositoryBuilder setGitDir(File file) {
        if (file != null) {
            throw new IllegalArgumentException();
        }
        return (DfsRepositoryBuilder)this.self();
    }

    @Override
    public DfsRepositoryBuilder setObjectDirectory(File file) {
        if (file != null) {
            throw new IllegalArgumentException();
        }
        return (DfsRepositoryBuilder)this.self();
    }

    @Override
    public DfsRepositoryBuilder addAlternateObjectDirectory(File file) {
        throw new UnsupportedOperationException(JGitText.get().unsupportedAlternates);
    }

    @Override
    public DfsRepositoryBuilder setWorkTree(File file) {
        if (file != null) {
            throw new IllegalArgumentException();
        }
        return (DfsRepositoryBuilder)this.self();
    }

    @Override
    public DfsRepositoryBuilder setIndexFile(File file) {
        if (file != null) {
            throw new IllegalArgumentException();
        }
        return (DfsRepositoryBuilder)this.self();
    }
}

