/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsConfig;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository$EmptyAttributesNodeProvider;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryBuilder;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public abstract class DfsRepository
extends Repository {
    private final DfsConfig config = new DfsConfig();
    private final DfsRepositoryDescription description;

    protected DfsRepository(DfsRepositoryBuilder dfsRepositoryBuilder) {
        super(dfsRepositoryBuilder);
        this.description = dfsRepositoryBuilder.getRepositoryDescription();
    }

    @Override
    public abstract DfsObjDatabase getObjectDatabase();

    public DfsRepositoryDescription getDescription() {
        return this.description;
    }

    public boolean exists() {
        if (this.getRefDatabase() instanceof DfsRefDatabase) {
            return ((DfsRefDatabase)this.getRefDatabase()).exists();
        }
        return true;
    }

    @Override
    public void create(boolean bl2) {
        if (this.exists()) {
            throw new IOException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, ""));
        }
        String string = "refs/heads/master";
        RefUpdate$Result refUpdate$Result = this.updateRef("HEAD", true).link(string);
        if (refUpdate$Result != RefUpdate$Result.NEW) {
            throw new IOException(refUpdate$Result.name());
        }
    }

    @Override
    public StoredConfig getConfig() {
        return this.config;
    }

    @Override
    public String getIdentifier() {
        return this.getDescription().getRepositoryName();
    }

    @Override
    public void scanForRepoChanges() {
        this.getRefDatabase().refresh();
        this.getObjectDatabase().clearCache();
    }

    @Override
    public void notifyIndexChanged(boolean bl2) {
    }

    @Override
    public ReflogReader getReflogReader(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributesNodeProvider createAttributesNodeProvider() {
        return new DfsRepository$EmptyAttributesNodeProvider(null);
    }
}

