/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;

public class DfsReftableStack
implements AutoCloseable {
    private final List files;
    private final List tables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DfsReftableStack open(DfsReader dfsReader, List list) {
        DfsReftableStack dfsReftableStack = new DfsReftableStack(list.size());
        boolean bl2 = true;
        try {
            for (DfsReftable dfsReftable : list) {
                dfsReftableStack.files.add(dfsReftable);
                dfsReftableStack.tables.add(dfsReftable.open(dfsReader));
            }
            bl2 = false;
            DfsReftableStack dfsReftableStack2 = dfsReftableStack;
            return dfsReftableStack2;
        }
        finally {
            if (bl2) {
                dfsReftableStack.close();
            }
        }
    }

    private DfsReftableStack(int n2) {
        this.files = new ArrayList(n2);
        this.tables = new ArrayList(n2);
    }

    public List files() {
        return Collections.unmodifiableList(this.files);
    }

    public List readers() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public void close() {
        for (ReftableReader reftableReader : this.tables) {
            try {
                reftableReader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

