/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase$RefCache;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableBatchRefUpdate;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableDatabase$1;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableStack;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableDatabase;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefList$Builder;
import org.eclipse.jgit.util.RefMap;

public class DfsReftableDatabase
extends DfsRefDatabase {
    final ReftableDatabase reftableDatabase = new DfsReftableDatabase$1(this);
    private DfsReader ctx;
    private DfsReftableStack stack = null;

    protected DfsReftableDatabase(DfsRepository dfsRepository) {
        super(dfsRepository);
    }

    @Override
    public boolean hasVersioning() {
        return true;
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    @Override
    public BatchRefUpdate newBatchUpdate() {
        DfsObjDatabase dfsObjDatabase = this.getRepository().getObjectDatabase();
        return new DfsReftableBatchRefUpdate(this, dfsObjDatabase);
    }

    public ReftableConfig getReftableConfig() {
        return new ReftableConfig(this.getRepository());
    }

    protected ReentrantLock getLock() {
        return this.reftableDatabase.getLock();
    }

    protected boolean compactDuringCommit() {
        return true;
    }

    protected DfsReftableStack stack() {
        if (!this.getLock().isLocked()) {
            throw new IllegalStateException("most hold lock to access stack");
        }
        DfsObjDatabase dfsObjDatabase = this.getRepository().getObjectDatabase();
        if (this.ctx == null) {
            this.ctx = dfsObjDatabase.newReader();
        }
        if (this.stack == null) {
            this.stack = DfsReftableStack.open(this.ctx, Arrays.asList(dfsObjDatabase.getReftables()));
        }
        return this.stack;
    }

    @Override
    public boolean isNameConflicting(String string) {
        return this.reftableDatabase.isNameConflicting(string, new TreeSet(), new HashSet());
    }

    @Override
    public Ref exactRef(String string) {
        return this.reftableDatabase.exactRef(string);
    }

    @Override
    public Map getRefs(String string) {
        List list = this.reftableDatabase.getRefsByPrefix(string);
        RefList$Builder refList$Builder = new RefList$Builder(list.size());
        for (Ref ref : list) {
            refList$Builder.add(ref);
        }
        return new RefMap(string, refList$Builder.toRefList(), RefList.emptyList(), RefList.emptyList());
    }

    @Override
    public List getRefsByPrefix(String string) {
        return this.reftableDatabase.getRefsByPrefix(string);
    }

    @Override
    public List getRefsByPrefixWithExclusions(String string, Set set) {
        return this.reftableDatabase.getRefsByPrefixWithExclusions(string, set);
    }

    @Override
    public Set getTipsWithSha1(ObjectId objectId) {
        if (!this.getReftableConfig().isIndexObjects()) {
            return super.getTipsWithSha1(objectId);
        }
        return this.reftableDatabase.getTipsWithSha1(objectId);
    }

    @Override
    public boolean hasFastTipsWithSha1() {
        return this.reftableDatabase.hasFastTipsWithSha1();
    }

    @Override
    public Ref peel(Ref ref) {
        Ref ref2 = ref.getLeaf();
        if (ref2.isPeeled() || ref2.getObjectId() == null) {
            return ref;
        }
        return DfsReftableDatabase.recreate(ref, this.doPeel(ref2), this.hasVersioning());
    }

    @Override
    boolean exists() {
        DfsObjDatabase dfsObjDatabase = this.getRepository().getObjectDatabase();
        return dfsObjDatabase.getReftables().length > 0;
    }

    @Override
    void clearCache() {
        ReentrantLock reentrantLock = this.getLock();
        reentrantLock.lock();
        try {
            if (this.ctx != null) {
                this.ctx.close();
                this.ctx = null;
            }
            this.reftableDatabase.clearCache();
            if (this.stack != null) {
                this.stack.close();
                this.stack = null;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    protected boolean compareAndPut(Ref ref, @Nullable Ref ref2) {
        ReceiveCommand receiveCommand = ReftableDatabase.toCommand(ref, ref2);
        try (RevWalk revWalk = new RevWalk(this.getRepository());){
            revWalk.setRetainBody(false);
            this.newBatchUpdate().setAllowNonFastForwards(true).addCommand(receiveCommand).execute(revWalk, NullProgressMonitor.INSTANCE);
        }
        switch (receiveCommand.getResult()) {
            case OK: {
                return true;
            }
            case REJECTED_OTHER_REASON: {
                throw new IOException(receiveCommand.getMessage());
            }
        }
        return false;
    }

    @Override
    protected boolean compareAndRemove(Ref ref) {
        return this.compareAndPut(ref, null);
    }

    @Override
    protected DfsRefDatabase$RefCache scanAllRefs() {
        throw new UnsupportedOperationException();
    }

    @Override
    void stored(Ref ref) {
    }

    @Override
    void removed(String string) {
    }

    @Override
    protected void cachePeeledState(Ref ref, Ref ref2) {
    }
}

