/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackCompactor;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableStack;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableBatchRefUpdate;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$Stats;

public class DfsReftableBatchRefUpdate
extends ReftableBatchRefUpdate {
    private static final int AVG_BYTES = 36;
    private final DfsReftableDatabase refdb;
    private final DfsObjDatabase odb;

    protected DfsReftableBatchRefUpdate(DfsReftableDatabase dfsReftableDatabase, DfsObjDatabase dfsObjDatabase) {
        super(dfsReftableDatabase, dfsReftableDatabase.reftableDatabase, dfsReftableDatabase.getLock(), dfsReftableDatabase.getRepository());
        this.refdb = dfsReftableDatabase;
        this.odb = dfsObjDatabase;
    }

    @Override
    protected void applyUpdates(List list, List list2) {
        Set set = Collections.emptySet();
        DfsPackDescription dfsPackDescription = this.odb.newPack(DfsObjDatabase$PackSource.INSERT);
        try (DfsOutputStream dfsOutputStream = this.odb.writeFile(dfsPackDescription, PackExt.REFTABLE);){
            ReftableWriter$Stats reftableWriter$Stats;
            ReftableConfig reftableConfig = DfsPackCompactor.configureReftable(this.refdb.getReftableConfig(), dfsOutputStream);
            if (this.refdb.compactDuringCommit() && list.size() * 36 <= reftableConfig.getRefBlockSize() && this.canCompactTopOfStack(reftableConfig)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ReftableWriter reftableWriter = new ReftableWriter(reftableConfig, byteArrayOutputStream);
                this.write(reftableWriter, list, list2);
                reftableWriter.finish();
                reftableWriter$Stats = this.compactTopOfStack(dfsOutputStream, reftableConfig, byteArrayOutputStream.toByteArray());
                set = this.toPruneTopOfStack();
            } else {
                ReftableWriter reftableWriter = new ReftableWriter(reftableConfig, dfsOutputStream);
                this.write(reftableWriter, list, list2);
                reftableWriter.finish();
                reftableWriter$Stats = reftableWriter.getStats();
            }
            dfsPackDescription.addFileExt(PackExt.REFTABLE);
            dfsPackDescription.setReftableStats(reftableWriter$Stats);
        }
        this.odb.commitPack(Collections.singleton(dfsPackDescription), set);
        this.odb.addReftable(dfsPackDescription, set);
        this.refdb.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCompactTopOfStack(ReftableConfig reftableConfig) {
        this.refdb.getLock().lock();
        try {
            DfsReftableStack dfsReftableStack = this.refdb.stack();
            List list = dfsReftableStack.readers();
            if (list.isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            int n2 = list.size() - 1;
            DfsReftable dfsReftable = (DfsReftable)dfsReftableStack.files().get(n2);
            DfsPackDescription dfsPackDescription = dfsReftable.getPackDescription();
            if (dfsPackDescription.getPackSource() != DfsObjDatabase$PackSource.INSERT || !this.packOnlyContainsReftable(dfsPackDescription)) {
                boolean bl3 = false;
                return bl3;
            }
            ReftableReader reftableReader = (ReftableReader)list.get(n2);
            int n3 = reftableConfig.getRefBlockSize();
            boolean bl4 = reftableReader.size() <= (long)(3 * n3);
            return bl4;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReftableWriter$Stats compactTopOfStack(OutputStream outputStream, ReftableConfig reftableConfig, byte[] byArray) {
        this.refdb.getLock().lock();
        try {
            List list = this.refdb.stack().readers();
            ReftableReader reftableReader = (ReftableReader)list.get(list.size() - 1);
            ArrayList<ReftableReader> arrayList = new ArrayList<ReftableReader>(2);
            arrayList.add(reftableReader);
            arrayList.add(new ReftableReader(BlockSource.from(byArray)));
            ReftableCompactor reftableCompactor = new ReftableCompactor(outputStream);
            reftableCompactor.setConfig(reftableConfig);
            reftableCompactor.setIncludeDeletes(true);
            reftableCompactor.addAll(arrayList);
            reftableCompactor.compact();
            ReftableWriter$Stats reftableWriter$Stats = reftableCompactor.getStats();
            return reftableWriter$Stats;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set toPruneTopOfStack() {
        this.refdb.getLock().lock();
        try {
            List list = this.refdb.stack().files();
            DfsReftable dfsReftable = (DfsReftable)list.get(list.size() - 1);
            Set<DfsPackDescription> set = Collections.singleton(dfsReftable.getPackDescription());
            return set;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    private boolean packOnlyContainsReftable(DfsPackDescription dfsPackDescription) {
        for (PackExt packExt : PackExt.values()) {
            if (packExt == PackExt.REFTABLE || !dfsPackDescription.hasFileExt(packExt)) continue;
            return false;
        }
        return true;
    }
}

