/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable$CacheSource;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;

public class DfsReftable
extends BlockBasedFile {
    public DfsReftable(DfsPackDescription dfsPackDescription) {
        this(DfsBlockCache.getInstance(), dfsPackDescription);
    }

    public DfsReftable(DfsBlockCache dfsBlockCache, DfsPackDescription dfsPackDescription) {
        super(dfsBlockCache, dfsPackDescription, PackExt.REFTABLE);
        long l2;
        int n2 = dfsPackDescription.getBlockSize(PackExt.REFTABLE);
        if (n2 > 0) {
            this.setBlockSize(n2);
        }
        this.length = (l2 = dfsPackDescription.getFileSize(PackExt.REFTABLE)) > 0L ? l2 : -1L;
    }

    public DfsPackDescription getPackDescription() {
        return this.desc;
    }

    public ReftableReader open(DfsReader dfsReader) {
        return new ReftableReader(new DfsReftable$CacheSource(this, this.cache, dfsReader));
    }
}

