/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.io.BlockSource;

final class DfsReftable$CacheSource
extends BlockSource {
    private final DfsReftable file;
    private final DfsBlockCache cache;
    private final DfsReader ctx;
    private ReadableChannel ch;
    private int readAhead;

    DfsReftable$CacheSource(DfsReftable dfsReftable, DfsBlockCache dfsBlockCache, DfsReader dfsReader) {
        this.file = dfsReftable;
        this.cache = dfsBlockCache;
        this.ctx = dfsReader;
    }

    @Override
    public ByteBuffer read(long l2, int n2) {
        if (this.ch == null && this.readAhead > 0 && this.notInCache(l2)) {
            this.open().setReadAheadBytes(this.readAhead);
        }
        DfsBlock dfsBlock = this.cache.getOrLoad(this.file, l2, this.ctx, () -> this.open());
        if (dfsBlock.start == l2 && dfsBlock.size() >= n2) {
            return dfsBlock.zeroCopyByteBuffer(n2);
        }
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(this.ctx.copy(this.file, l2, byArray, 0, n2));
        return byteBuffer;
    }

    private boolean notInCache(long l2) {
        return this.cache.get(this.file.key, this.file.alignToBlock(l2)) == null;
    }

    @Override
    public long size() {
        long l2 = this.file.length;
        if (l2 < 0L) {
            this.file.length = l2 = this.open().size();
        }
        return l2;
    }

    @Override
    public void adviseSequentialRead(long l2, long l3) {
        int n2 = this.ctx.getOptions().getStreamPackBufferSize();
        if (n2 > 0) {
            this.readAhead = (int)Math.min((long)n2, l3 - l2);
        }
    }

    private ReadableChannel open() {
        if (this.ch == null) {
            this.ch = this.ctx.db.openFile(this.file.desc, this.file.ext);
        }
        return this.ch;
    }

    @Override
    public void close() {
        if (this.ch != null) {
            try {
                this.ch.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ch = null;
            }
        }
    }
}

