/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

final class DfsRefUpdate
extends RefUpdate {
    private final DfsRefDatabase refdb;
    private Ref dstRef;
    private RevWalk rw;

    DfsRefUpdate(DfsRefDatabase dfsRefDatabase, Ref ref) {
        super(ref);
        this.refdb = dfsRefDatabase;
    }

    @Override
    protected DfsRefDatabase getRefDatabase() {
        return this.refdb;
    }

    @Override
    protected DfsRepository getRepository() {
        return this.refdb.getRepository();
    }

    @Override
    protected boolean tryLock(boolean bl2) {
        this.dstRef = this.getRef();
        if (bl2) {
            this.dstRef = this.dstRef.getLeaf();
        }
        if (this.dstRef.isSymbolic()) {
            this.setOldObjectId(null);
        } else {
            this.setOldObjectId(this.dstRef.getObjectId());
        }
        return true;
    }

    @Override
    protected void unlock() {
    }

    @Override
    public RefUpdate$Result update(RevWalk revWalk) {
        try {
            this.rw = revWalk;
            RefUpdate$Result refUpdate$Result = super.update(revWalk);
            return refUpdate$Result;
        }
        finally {
            this.rw = null;
        }
    }

    @Override
    protected RefUpdate$Result doUpdate(RefUpdate$Result refUpdate$Result) {
        RevObject revObject = this.rw.parseAny(this.getNewObjectId());
        ObjectIdRef objectIdRef = revObject instanceof RevTag ? new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, this.dstRef.getName(), this.getNewObjectId(), this.rw.peel(revObject).copy()) : new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, this.dstRef.getName(), this.getNewObjectId());
        if (this.getRefDatabase().compareAndPut(this.dstRef, objectIdRef)) {
            this.getRefDatabase().stored(objectIdRef);
            return refUpdate$Result;
        }
        return RefUpdate$Result.LOCK_FAILURE;
    }

    @Override
    protected RefUpdate$Result doDelete(RefUpdate$Result refUpdate$Result) {
        if (this.getRefDatabase().compareAndRemove(this.dstRef)) {
            this.getRefDatabase().removed(this.dstRef.getName());
            return refUpdate$Result;
        }
        return RefUpdate$Result.LOCK_FAILURE;
    }

    @Override
    protected RefUpdate$Result doLink(String string) {
        SymbolicRef symbolicRef = new SymbolicRef(this.dstRef.getName(), new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null));
        if (this.getRefDatabase().compareAndPut(this.dstRef, symbolicRef)) {
            this.getRefDatabase().stored(symbolicRef);
            if (this.dstRef.getStorage() == Ref$Storage.NEW) {
                return RefUpdate$Result.NEW;
            }
            return RefUpdate$Result.FORCED;
        }
        return RefUpdate$Result.LOCK_FAILURE;
    }
}

