/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase$RefCache;
import org.eclipse.jgit.internal.storage.dfs.DfsRefRename;
import org.eclipse.jgit.internal.storage.dfs.DfsRefUpdate;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefList$Builder;
import org.eclipse.jgit.util.RefMap;

public abstract class DfsRefDatabase
extends RefDatabase {
    private final DfsRepository repository;
    private final AtomicReference cache;

    protected DfsRefDatabase(DfsRepository dfsRepository) {
        this.repository = dfsRepository;
        this.cache = new AtomicReference();
    }

    protected DfsRepository getRepository() {
        return this.repository;
    }

    boolean exists() {
        return 0 < this.read().size();
    }

    @Override
    public Ref exactRef(String string) {
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache = this.read();
        Ref ref = dfsRefDatabase$RefCache.ids.get(string);
        return ref != null ? this.resolve(ref, 0, dfsRefDatabase$RefCache.ids) : null;
    }

    @Override
    public List getAdditionalRefs() {
        return Collections.emptyList();
    }

    @Override
    public Map getRefs(String string) {
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache = this.read();
        RefList refList = RefList.emptyList();
        RefList refList2 = dfsRefDatabase$RefCache.ids;
        RefList$Builder refList$Builder = new RefList$Builder(dfsRefDatabase$RefCache.sym.size());
        for (int i2 = 0; i2 < dfsRefDatabase$RefCache.sym.size(); ++i2) {
            Ref ref = dfsRefDatabase$RefCache.sym.get(i2);
            String string2 = ref.getName();
            if ((ref = this.resolve(ref, 0, refList2)) != null && ref.getObjectId() != null) {
                refList$Builder.add(ref);
                continue;
            }
            int n2 = refList2.find(string2);
            if (0 > n2) continue;
            refList2 = refList2.remove(n2);
        }
        return new RefMap(string, refList, refList2, refList$Builder.toRefList());
    }

    private Ref resolve(Ref ref, int n2, RefList refList) {
        if (!ref.isSymbolic()) {
            return ref;
        }
        Ref ref2 = ref.getTarget();
        if (5 <= n2) {
            return null;
        }
        if ((ref2 = refList.get(ref2.getName())) == null) {
            return ref;
        }
        if ((ref2 = this.resolve(ref2, n2 + 1, refList)) == null) {
            return null;
        }
        return new SymbolicRef(ref.getName(), ref2);
    }

    @Override
    public Ref peel(Ref ref) {
        Ref ref2 = ref.getLeaf();
        if (ref2.isPeeled() || ref2.getObjectId() == null) {
            return ref;
        }
        Ref ref3 = this.doPeel(ref2);
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache = this.read();
        int n2 = dfsRefDatabase$RefCache.ids.find(ref2.getName());
        if (0 <= n2 && dfsRefDatabase$RefCache.ids.get(n2) == ref2) {
            RefList refList = dfsRefDatabase$RefCache.ids.set(n2, ref3);
            this.cache.compareAndSet(dfsRefDatabase$RefCache, new DfsRefDatabase$RefCache(refList, dfsRefDatabase$RefCache));
            this.cachePeeledState(ref2, ref3);
        }
        return DfsRefDatabase.recreate(ref, ref3, this.hasVersioning());
    }

    Ref doPeel(Ref ref) {
        try (RevWalk revWalk = new RevWalk(this.repository);){
            RevObject revObject = revWalk.parseAny(ref.getObjectId());
            if (revObject instanceof RevTag) {
                ObjectIdRef$PeeledTag objectIdRef$PeeledTag = new ObjectIdRef$PeeledTag(ref.getStorage(), ref.getName(), ref.getObjectId(), revWalk.peel(revObject).copy(), this.hasVersioning() ? ref.getUpdateIndex() : -1L);
                return objectIdRef$PeeledTag;
            }
            ObjectIdRef$PeeledNonTag objectIdRef$PeeledNonTag = new ObjectIdRef$PeeledNonTag(ref.getStorage(), ref.getName(), ref.getObjectId(), this.hasVersioning() ? ref.getUpdateIndex() : -1L);
            return objectIdRef$PeeledNonTag;
        }
    }

    static Ref recreate(Ref ref, Ref ref2, boolean bl2) {
        if (ref.isSymbolic()) {
            Ref ref3 = DfsRefDatabase.recreate(ref.getTarget(), ref2, bl2);
            return new SymbolicRef(ref.getName(), ref3, bl2 ? ref.getUpdateIndex() : -1L);
        }
        return ref2;
    }

    @Override
    public RefUpdate newUpdate(String string, boolean bl2) {
        boolean bl3 = false;
        Ref ref = this.exactRef(string);
        if (ref == null) {
            ref = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null);
        } else {
            bl3 = bl2 && ref.isSymbolic();
        }
        DfsRefUpdate dfsRefUpdate = new DfsRefUpdate(this, ref);
        if (bl3) {
            dfsRefUpdate.setDetachingSymbolicRef();
        }
        return dfsRefUpdate;
    }

    @Override
    public RefRename newRename(String string, String string2) {
        RefUpdate refUpdate = this.newUpdate(string, true);
        RefUpdate refUpdate2 = this.newUpdate(string2, true);
        return new DfsRefRename(refUpdate, refUpdate2);
    }

    @Override
    public boolean isNameConflicting(String string) {
        String string2;
        RefList refList = this.read().ids;
        int n2 = string.lastIndexOf(47);
        while (0 < n2) {
            string2 = string.substring(0, n2);
            if (refList.contains(string2)) {
                return true;
            }
            n2 = string.lastIndexOf(47, n2 - 1);
        }
        string2 = string + '/';
        int n3 = -(refList.find(string2) + 1);
        return n3 < refList.size() && refList.get(n3).getName().startsWith(string2);
    }

    @Override
    public void create() {
    }

    @Override
    public void refresh() {
        this.clearCache();
    }

    @Override
    public void close() {
        this.clearCache();
    }

    void clearCache() {
        this.cache.set(null);
    }

    void stored(Ref ref) {
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache;
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache2;
        do {
            if ((dfsRefDatabase$RefCache2 = (DfsRefDatabase$RefCache)this.cache.get()) != null) continue;
            return;
        } while (!this.cache.compareAndSet(dfsRefDatabase$RefCache2, dfsRefDatabase$RefCache = dfsRefDatabase$RefCache2.put(ref)));
    }

    void removed(String string) {
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache;
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache2;
        do {
            if ((dfsRefDatabase$RefCache2 = (DfsRefDatabase$RefCache)this.cache.get()) != null) continue;
            return;
        } while (!this.cache.compareAndSet(dfsRefDatabase$RefCache2, dfsRefDatabase$RefCache = dfsRefDatabase$RefCache2.remove(string)));
    }

    private DfsRefDatabase$RefCache read() {
        DfsRefDatabase$RefCache dfsRefDatabase$RefCache = (DfsRefDatabase$RefCache)this.cache.get();
        if (dfsRefDatabase$RefCache == null) {
            dfsRefDatabase$RefCache = this.scanAllRefs();
            this.cache.set(dfsRefDatabase$RefCache);
        }
        return dfsRefDatabase$RefCache;
    }

    protected abstract DfsRefDatabase$RefCache scanAllRefs();

    protected abstract boolean compareAndPut(Ref var1, Ref var2);

    protected abstract boolean compareAndRemove(Ref var1);

    protected void cachePeeledState(Ref ref, Ref ref2) {
        try {
            this.compareAndPut(ref, ref2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

