/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.lib.Config;

public class DfsReaderOptions {
    public static final int KiB = 1024;
    public static final int MiB = 0x100000;
    private int deltaBaseCacheLimit;
    private int streamFileThreshold;
    private int streamPackBufferSize;

    public DfsReaderOptions() {
        this.setDeltaBaseCacheLimit(0xA00000);
        this.setStreamFileThreshold(0x3200000);
    }

    public int getDeltaBaseCacheLimit() {
        return this.deltaBaseCacheLimit;
    }

    public DfsReaderOptions setDeltaBaseCacheLimit(int n2) {
        this.deltaBaseCacheLimit = Math.max(0, n2);
        return this;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public DfsReaderOptions setStreamFileThreshold(int n2) {
        this.streamFileThreshold = Math.max(0, n2);
        return this;
    }

    public int getStreamPackBufferSize() {
        return this.streamPackBufferSize;
    }

    public DfsReaderOptions setStreamPackBufferSize(int n2) {
        this.streamPackBufferSize = Math.max(0, n2);
        return this;
    }

    public DfsReaderOptions fromConfig(Config config) {
        this.setDeltaBaseCacheLimit(config.getInt("core", "dfs", "deltaBaseCacheLimit", this.getDeltaBaseCacheLimit()));
        long l2 = Runtime.getRuntime().maxMemory();
        long l3 = config.getLong("core", "dfs", "streamFileThreshold", this.getStreamFileThreshold());
        l3 = Math.min(l3, l2 / 4L);
        l3 = Math.min(l3, Integer.MAX_VALUE);
        this.setStreamFileThreshold((int)l3);
        this.setStreamPackBufferSize(config.getInt("core", "dfs", "streamBuffer", this.getStreamPackBufferSize()));
        return this;
    }
}

