/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsCachedPack;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackList;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader$1;
import org.eclipse.jgit.internal.storage.dfs.DfsReader$2;
import org.eclipse.jgit.internal.storage.dfs.DfsReader$FoundObject;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderIoStats;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderIoStats$Accumulator;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.BlockList;

public class DfsReader
extends ObjectReader
implements ObjectReuseAsIs {
    private static final int MAX_RESOLVE_MATCHES = 256;
    final byte[] tempId = new byte[20];
    final DfsObjDatabase db;
    final DfsReaderIoStats$Accumulator stats = new DfsReaderIoStats$Accumulator();
    private Inflater inf;
    private DfsBlock block;
    private DeltaBaseCache baseCache;
    private DfsPackFile last;
    private boolean avoidUnreachable;
    private static final Comparator FOUND_OBJECT_SORT = (dfsReader$FoundObject, dfsReader$FoundObject2) -> {
        int n2 = dfsReader$FoundObject.packIndex - dfsReader$FoundObject2.packIndex;
        if (n2 == 0) {
            n2 = Long.signum(dfsReader$FoundObject.offset - dfsReader$FoundObject2.offset);
        }
        return n2;
    };
    private static final Comparator OFFSET_SORT = (dfsObjectToPack, dfsObjectToPack2) -> Long.signum(dfsObjectToPack.getOffset() - dfsObjectToPack2.getOffset());
    private static final Comparator PACK_SORT_FOR_REUSE = Comparator.comparing(DfsPackFile::getPackDescription, DfsPackDescription.reuseComparator());

    protected DfsReader(DfsObjDatabase dfsObjDatabase) {
        this.db = dfsObjDatabase;
        this.streamFileThreshold = dfsObjDatabase.getReaderOptions().getStreamFileThreshold();
    }

    DfsReaderOptions getOptions() {
        return this.db.getReaderOptions();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache(this);
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return this.db.newReader();
    }

    @Override
    public void setAvoidUnreachableObjects(boolean bl2) {
        this.avoidUnreachable = bl2;
    }

    @Override
    public BitmapIndex getBitmapIndex() {
        for (DfsPackFile dfsPackFile : this.db.getPacks()) {
            PackBitmapIndex packBitmapIndex = dfsPackFile.getBitmapIndex(this);
            if (packBitmapIndex == null) continue;
            return new BitmapIndexImpl(packBitmapIndex);
        }
        return null;
    }

    @Override
    public Collection getCachedPacksAndUpdate(BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder) {
        for (DfsPackFile dfsPackFile : this.db.getPacks()) {
            PackBitmapIndex packBitmapIndex = dfsPackFile.getBitmapIndex(this);
            if (!bitmapIndex$BitmapBuilder.removeAllOrNone(packBitmapIndex)) continue;
            return Collections.singletonList(new DfsCachedPack(dfsPackFile));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection resolve(AbbreviatedObjectId abbreviatedObjectId) {
        if (abbreviatedObjectId.isComplete()) {
            return Collections.singleton(abbreviatedObjectId.toObjectId());
        }
        HashSet hashSet = new HashSet(4);
        DfsObjDatabase$PackList dfsObjDatabase$PackList = this.db.getPackList();
        this.resolveImpl(dfsObjDatabase$PackList, abbreviatedObjectId, hashSet);
        if (hashSet.size() < 256 && dfsObjDatabase$PackList.dirty()) {
            ++this.stats.scanPacks;
            this.resolveImpl(this.db.scanPacks(dfsObjDatabase$PackList), abbreviatedObjectId, hashSet);
        }
        return hashSet;
    }

    private void resolveImpl(DfsObjDatabase$PackList dfsObjDatabase$PackList, AbbreviatedObjectId abbreviatedObjectId, HashSet hashSet) {
        for (DfsPackFile dfsPackFile : dfsObjDatabase$PackList.packs) {
            if (this.skipGarbagePack(dfsPackFile)) continue;
            dfsPackFile.resolve(this, hashSet, abbreviatedObjectId, 256);
            if (hashSet.size() >= 256) break;
        }
    }

    @Override
    public boolean has(AnyObjectId anyObjectId) {
        if (this.last != null && !this.skipGarbagePack(this.last) && this.last.hasObject(this, anyObjectId)) {
            return true;
        }
        DfsObjDatabase$PackList dfsObjDatabase$PackList = this.db.getPackList();
        if (this.hasImpl(dfsObjDatabase$PackList, anyObjectId)) {
            return true;
        }
        if (dfsObjDatabase$PackList.dirty()) {
            ++this.stats.scanPacks;
            return this.hasImpl(this.db.scanPacks(dfsObjDatabase$PackList), anyObjectId);
        }
        return false;
    }

    private boolean hasImpl(DfsObjDatabase$PackList dfsObjDatabase$PackList, AnyObjectId anyObjectId) {
        for (DfsPackFile dfsPackFile : dfsObjDatabase$PackList.packs) {
            if (dfsPackFile == this.last || this.skipGarbagePack(dfsPackFile) || !dfsPackFile.hasObject(this, anyObjectId)) continue;
            this.last = dfsPackFile;
            return true;
        }
        return false;
    }

    @Override
    public ObjectLoader open(AnyObjectId anyObjectId, int n2) {
        ObjectLoader objectLoader;
        if (this.last != null && !this.skipGarbagePack(this.last) && (objectLoader = this.last.get(this, anyObjectId)) != null) {
            return DfsReader.checkType(objectLoader, anyObjectId, n2);
        }
        DfsObjDatabase$PackList dfsObjDatabase$PackList = this.db.getPackList();
        objectLoader = this.openImpl(dfsObjDatabase$PackList, anyObjectId);
        if (objectLoader != null) {
            return DfsReader.checkType(objectLoader, anyObjectId, n2);
        }
        if (dfsObjDatabase$PackList.dirty()) {
            ++this.stats.scanPacks;
            objectLoader = this.openImpl(this.db.scanPacks(dfsObjDatabase$PackList), anyObjectId);
            if (objectLoader != null) {
                return DfsReader.checkType(objectLoader, anyObjectId, n2);
            }
        }
        if (n2 == -1) {
            throw new MissingObjectException(anyObjectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(anyObjectId.copy(), n2);
    }

    private static ObjectLoader checkType(ObjectLoader objectLoader, AnyObjectId anyObjectId, int n2) {
        if (n2 != -1 && objectLoader.getType() != n2) {
            throw new IncorrectObjectTypeException(anyObjectId.copy(), n2);
        }
        return objectLoader;
    }

    private ObjectLoader openImpl(DfsObjDatabase$PackList dfsObjDatabase$PackList, AnyObjectId anyObjectId) {
        for (DfsPackFile dfsPackFile : dfsObjDatabase$PackList.packs) {
            ObjectLoader objectLoader;
            if (dfsPackFile == this.last || this.skipGarbagePack(dfsPackFile) || (objectLoader = dfsPackFile.get(this, anyObjectId)) == null) continue;
            this.last = dfsPackFile;
            return objectLoader;
        }
        return null;
    }

    @Override
    public Set getShallowCommits() {
        return Collections.emptySet();
    }

    private Iterable findAll(Iterable iterable) {
        Serializable serializable2;
        LinkedList<ObjectId> linkedList = new LinkedList<ObjectId>();
        for (Serializable serializable2 : iterable) {
            linkedList.add((ObjectId)serializable2);
        }
        DfsObjDatabase$PackList dfsObjDatabase$PackList = this.db.getPackList();
        serializable2 = new ArrayList();
        this.findAllImpl(dfsObjDatabase$PackList, linkedList, (List)((Object)serializable2));
        if (!linkedList.isEmpty() && dfsObjDatabase$PackList.dirty()) {
            ++this.stats.scanPacks;
            this.findAllImpl(this.db.scanPacks(dfsObjDatabase$PackList), linkedList, (List)((Object)serializable2));
        }
        for (ObjectId objectId : linkedList) {
            serializable2.add(new DfsReader$FoundObject(objectId));
        }
        Collections.sort(serializable2, FOUND_OBJECT_SORT);
        return serializable2;
    }

    private void findAllImpl(DfsObjDatabase$PackList dfsObjDatabase$PackList, Collection collection, List list) {
        DfsPackFile[] dfsPackFileArray = dfsObjDatabase$PackList.packs;
        if (dfsPackFileArray.length == 0) {
            return;
        }
        int n2 = 0;
        DfsPackFile dfsPackFile = dfsPackFileArray[n2];
        Iterator iterator = collection.iterator();
        block4: while (iterator.hasNext()) {
            ObjectId objectId = (ObjectId)iterator.next();
            if (!this.skipGarbagePack(dfsPackFile)) {
                try {
                    long l2 = dfsPackFile.findOffset(this, objectId);
                    if (0L < l2) {
                        list.add(new DfsReader$FoundObject(objectId, n2, dfsPackFile, l2));
                        iterator.remove();
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (int i2 = 0; i2 < dfsPackFileArray.length; ++i2) {
                DfsPackFile dfsPackFile2;
                if (i2 == n2 || this.skipGarbagePack(dfsPackFile2 = dfsPackFileArray[i2])) continue;
                try {
                    long l3 = dfsPackFile2.findOffset(this, objectId);
                    if (0L >= l3) continue;
                    list.add(new DfsReader$FoundObject(objectId, i2, dfsPackFile2, l3));
                    iterator.remove();
                    n2 = i2;
                    dfsPackFile = dfsPackFile2;
                    continue block4;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.last = dfsPackFile;
    }

    private boolean skipGarbagePack(DfsPackFile dfsPackFile) {
        return this.avoidUnreachable && dfsPackFile.isGarbage();
    }

    @Override
    public AsyncObjectLoaderQueue open(Iterable iterable, boolean bl2) {
        List list;
        IOException iOException = null;
        try {
            list = this.findAll(iterable);
        }
        catch (IOException iOException2) {
            list = Collections.emptyList();
            iOException = iOException2;
        }
        Iterator iterator = list.iterator();
        IOException iOException3 = iOException;
        return new DfsReader$1(this, iterator, iOException3);
    }

    @Override
    public AsyncObjectSizeQueue getObjectSize(Iterable iterable, boolean bl2) {
        List list;
        IOException iOException = null;
        try {
            list = this.findAll(iterable);
        }
        catch (IOException iOException2) {
            list = Collections.emptyList();
            iOException = iOException2;
        }
        Iterator iterator = list.iterator();
        IOException iOException3 = iOException;
        return new DfsReader$2(this, iterator, iOException3);
    }

    @Override
    public long getObjectSize(AnyObjectId anyObjectId, int n2) {
        long l2;
        if (this.last != null && !this.skipGarbagePack(this.last) && 0L <= (l2 = this.last.getObjectSize(this, anyObjectId))) {
            return l2;
        }
        DfsObjDatabase$PackList dfsObjDatabase$PackList = this.db.getPackList();
        long l3 = this.getObjectSizeImpl(dfsObjDatabase$PackList, anyObjectId);
        if (0L <= l3) {
            return l3;
        }
        if (dfsObjDatabase$PackList.dirty() && 0L <= (l3 = this.getObjectSizeImpl(dfsObjDatabase$PackList, anyObjectId))) {
            return l3;
        }
        if (n2 == -1) {
            throw new MissingObjectException(anyObjectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(anyObjectId.copy(), n2);
    }

    private long getObjectSizeImpl(DfsObjDatabase$PackList dfsObjDatabase$PackList, AnyObjectId anyObjectId) {
        for (DfsPackFile dfsPackFile : dfsObjDatabase$PackList.packs) {
            long l2;
            if (dfsPackFile == this.last || this.skipGarbagePack(dfsPackFile) || 0L > (l2 = dfsPackFile.getObjectSize(this, anyObjectId))) continue;
            this.last = dfsPackFile;
            return l2;
        }
        return -1L;
    }

    @Override
    public DfsObjectToPack newObjectToPack(AnyObjectId anyObjectId, int n2) {
        return new DfsObjectToPack(anyObjectId, n2);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packWriter, ProgressMonitor progressMonitor, Iterable iterable) {
        List list = this.sortPacksForSelectRepresentation();
        this.trySelectRepresentation(packWriter, progressMonitor, iterable, list, false);
        List list2 = this.garbagePacksForSelectRepresentation();
        if (!list2.isEmpty() && DfsReader.checkGarbagePacks(iterable)) {
            this.trySelectRepresentation(packWriter, progressMonitor, iterable, list2, true);
        }
    }

    private void trySelectRepresentation(PackWriter packWriter, ProgressMonitor progressMonitor, Iterable iterable, List list, boolean bl2) {
        for (DfsPackFile dfsPackFile : list) {
            List list2 = this.findAllFromPack(dfsPackFile, iterable, bl2);
            if (list2.isEmpty()) continue;
            Collections.sort(list2, OFFSET_SORT);
            PackReverseIndex packReverseIndex = dfsPackFile.getReverseIdx(this);
            DfsObjectRepresentation dfsObjectRepresentation = new DfsObjectRepresentation(dfsPackFile);
            for (DfsObjectToPack dfsObjectToPack : list2) {
                dfsPackFile.representation(dfsObjectRepresentation, dfsObjectToPack.getOffset(), this, packReverseIndex);
                dfsObjectToPack.setOffset(0L);
                packWriter.select(dfsObjectToPack, dfsObjectRepresentation);
                if (dfsObjectToPack.isFound()) continue;
                dfsObjectToPack.setFound();
                progressMonitor.update(1);
            }
        }
    }

    private List sortPacksForSelectRepresentation() {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        ArrayList<DfsPackFile> arrayList = new ArrayList<DfsPackFile>(dfsPackFileArray.length);
        for (DfsPackFile dfsPackFile : dfsPackFileArray) {
            if (dfsPackFile.getPackDescription().getPackSource() == DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE) continue;
            arrayList.add(dfsPackFile);
        }
        Collections.sort(arrayList, PACK_SORT_FOR_REUSE);
        return arrayList;
    }

    private List garbagePacksForSelectRepresentation() {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        ArrayList<DfsPackFile> arrayList = new ArrayList<DfsPackFile>(dfsPackFileArray.length);
        for (DfsPackFile dfsPackFile : dfsPackFileArray) {
            if (dfsPackFile.getPackDescription().getPackSource() != DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE) continue;
            arrayList.add(dfsPackFile);
        }
        return arrayList;
    }

    private static boolean checkGarbagePacks(Iterable iterable) {
        for (ObjectToPack objectToPack : iterable) {
            if (((DfsObjectToPack)objectToPack).isFound()) continue;
            return true;
        }
        return false;
    }

    private List findAllFromPack(DfsPackFile dfsPackFile, Iterable iterable, boolean bl2) {
        BlockList blockList = new BlockList();
        PackIndex packIndex = dfsPackFile.getPackIndex(this);
        for (ObjectToPack objectToPack : iterable) {
            long l2;
            DfsObjectToPack dfsObjectToPack = (DfsObjectToPack)objectToPack;
            if (bl2 && dfsObjectToPack.isFound() || 0L >= (l2 = packIndex.findOffset(dfsObjectToPack)) || dfsPackFile.isCorrupt(l2)) continue;
            dfsObjectToPack.setOffset(l2);
            blockList.add(dfsObjectToPack);
        }
        return blockList;
    }

    @Override
    public void copyObjectAsIs(PackOutputStream packOutputStream, ObjectToPack objectToPack, boolean bl2) {
        DfsObjectToPack dfsObjectToPack = (DfsObjectToPack)objectToPack;
        dfsObjectToPack.pack.copyAsIs(packOutputStream, dfsObjectToPack, bl2, this);
    }

    @Override
    public void writeObjects(PackOutputStream packOutputStream, List list) {
        for (ObjectToPack objectToPack : list) {
            packOutputStream.writeObject(objectToPack);
        }
    }

    @Override
    public void copyPackAsIs(PackOutputStream packOutputStream, CachedPack cachedPack) {
        ((DfsCachedPack)cachedPack).copyAsIs(packOutputStream, this);
    }

    int copy(BlockBasedFile blockBasedFile, long l2, byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        long l3 = blockBasedFile.length;
        if (0L <= l3 && l3 <= l2) {
            return 0;
        }
        int n4 = n3;
        do {
            this.pin(blockBasedFile, l2);
            int n5 = this.block.copy(l2, byArray, n2, n4);
            l2 += (long)n5;
            n2 += n5;
            n4 -= n5;
            if (l3 >= 0L) continue;
            l3 = blockBasedFile.length;
        } while (0 < n4 && l2 < l3);
        return n3 - n4;
    }

    int inflate(DfsPackFile dfsPackFile, long l2, byte[] byArray, boolean bl2) {
        long l3 = System.nanoTime();
        this.prepareInflater();
        this.pin(dfsPackFile, l2);
        l2 += (long)this.block.setInput(l2, this.inf);
        int n2 = 0;
        while (true) {
            int n3 = this.inf.inflate(byArray, n2, byArray.length - n2);
            if (this.inf.finished() || bl2 && (n2 += n3) == byArray.length) {
                this.stats.inflatedBytes += (long)n2;
                this.stats.inflationMicros += BlockBasedFile.elapsedMicros(l3);
                return n2;
            }
            if (this.inf.needsInput()) {
                this.pin(dfsPackFile, l2);
                l2 += (long)this.block.setInput(l2, this.inf);
                continue;
            }
            if (n3 == 0) break;
        }
        throw new DataFormatException();
    }

    DfsBlock quickCopy(DfsPackFile dfsPackFile, long l2, long l3) {
        this.pin(dfsPackFile, l2);
        if (this.block.contains(dfsPackFile.key, l2 + (l3 - 1L))) {
            return this.block;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(BlockBasedFile blockBasedFile, long l2) {
        if (this.block == null || !this.block.contains(blockBasedFile.key, l2)) {
            this.block = null;
            this.block = blockBasedFile.getOrLoadBlock(l2, this);
        }
    }

    void unpin() {
        this.block = null;
    }

    public DfsReaderIoStats getIoStats() {
        return new DfsReaderIoStats(this.stats);
    }

    @Override
    public void close() {
        this.last = null;
        this.block = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }
}

