/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackParser$UnresolvedDelta;
import org.eclipse.jgit.transport.PackedObjectInfo;

public class DfsPackParser
extends PackParser {
    private final DfsObjDatabase objdb;
    private final DfsInserter objins;
    private final CRC32 crc;
    private final MessageDigest packDigest;
    private int blockSize;
    private long packEnd;
    private byte[] packHash;
    private Deflater def;
    private boolean isEmptyPack;
    private DfsPackDescription packDsc;
    private DfsStreamKey packKey;
    private PackIndex packIndex;
    private DfsOutputStream out;
    private byte[] currBuf;
    private long currPos;
    private int currEnd;
    private DfsBlockCache blockCache;
    private long readPos;
    private DfsBlock readBlock;

    protected DfsPackParser(DfsObjDatabase dfsObjDatabase, DfsInserter dfsInserter, InputStream inputStream) {
        super(dfsObjDatabase, inputStream);
        this.objdb = dfsObjDatabase;
        this.objins = dfsInserter;
        this.crc = new CRC32();
        this.packDigest = Constants.newMessageDigest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackLock parse(ProgressMonitor progressMonitor, ProgressMonitor progressMonitor2) {
        boolean bl2 = true;
        try {
            this.blockCache = DfsBlockCache.getInstance();
            super.parse(progressMonitor, progressMonitor2);
            if (this.isEmptyPack) {
                PackLock packLock = null;
                return packLock;
            }
            this.buffer(this.packHash, 0, this.packHash.length);
            if (this.currEnd != 0) {
                this.flushBlock();
            }
            this.out.close();
            this.out = null;
            this.currBuf = null;
            this.readBlock = null;
            this.packDsc.addFileExt(PackExt.PACK);
            this.packDsc.setFileSize(PackExt.PACK, this.packEnd);
            this.packDsc.setBlockSize(PackExt.PACK, this.blockSize);
            this.writePackIndex();
            this.objdb.commitPack(Collections.singletonList(this.packDsc), null);
            bl2 = false;
            DfsPackFile dfsPackFile = new DfsPackFile(this.blockCache, this.packDsc);
            dfsPackFile.setBlockSize(this.blockSize);
            if (this.packIndex != null) {
                dfsPackFile.setPackIndex(this.packIndex);
            }
            this.objdb.addPack(dfsPackFile);
            PackLock packLock = null;
            return packLock;
        }
        finally {
            this.blockCache = null;
            this.currBuf = null;
            this.readBlock = null;
            if (this.def != null) {
                this.def.end();
                this.def = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                this.out = null;
            }
            if (bl2 && this.packDsc != null) {
                try {
                    this.objdb.rollbackPack(Collections.singletonList(this.packDsc));
                }
                finally {
                    this.packDsc = null;
                }
            }
        }
    }

    public DfsPackDescription getPackDescription() {
        return this.packDsc;
    }

    @Override
    protected void onPackHeader(long l2) {
        if (l2 == 0L) {
            this.isEmptyPack = true;
            this.currBuf = new byte[256];
            return;
        }
        this.packDsc = this.objdb.newPack(DfsObjDatabase$PackSource.RECEIVE);
        this.out = this.objdb.writeFile(this.packDsc, PackExt.PACK);
        this.packKey = this.packDsc.getStreamKey(PackExt.PACK);
        int n2 = this.out.blockSize();
        if (n2 <= 0) {
            n2 = this.blockCache.getBlockSize();
        } else if (n2 < this.blockCache.getBlockSize()) {
            n2 = this.blockCache.getBlockSize() / n2 * n2;
        }
        this.blockSize = n2;
        this.currBuf = new byte[this.blockSize];
    }

    @Override
    protected void onBeginWholeObject(long l2, int n2, long l3) {
        this.crc.reset();
    }

    @Override
    protected void onEndWholeObject(PackedObjectInfo packedObjectInfo) {
        packedObjectInfo.setCRC((int)this.crc.getValue());
    }

    @Override
    protected void onBeginOfsDelta(long l2, long l3, long l4) {
        this.crc.reset();
    }

    @Override
    protected void onBeginRefDelta(long l2, AnyObjectId anyObjectId, long l3) {
        this.crc.reset();
    }

    @Override
    protected PackParser$UnresolvedDelta onEndDelta() {
        PackParser$UnresolvedDelta packParser$UnresolvedDelta = new PackParser$UnresolvedDelta();
        packParser$UnresolvedDelta.setCRC((int)this.crc.getValue());
        return packParser$UnresolvedDelta;
    }

    @Override
    protected void onInflatedObjectData(PackedObjectInfo packedObjectInfo, int n2, byte[] byArray) {
    }

    @Override
    protected void onObjectHeader(PackParser.Source source, byte[] byArray, int n2, int n3) {
        this.crc.update(byArray, n2, n3);
    }

    @Override
    protected void onObjectData(PackParser.Source source, byte[] byArray, int n2, int n3) {
        this.crc.update(byArray, n2, n3);
    }

    @Override
    protected void onStoreStream(byte[] byArray, int n2, int n3) {
        this.buffer(byArray, n2, n3);
        this.packDigest.update(byArray, n2, n3);
    }

    private void buffer(byte[] byArray, int n2, int n3) {
        while (0 < n3) {
            int n4 = Math.min(n3, this.currBuf.length - this.currEnd);
            if (n4 == 0) {
                DfsBlock dfsBlock = this.flushBlock();
                this.currBuf = new byte[this.blockSize];
                this.currEnd = 0;
                this.currPos += (long)dfsBlock.size();
                continue;
            }
            System.arraycopy(byArray, n2, this.currBuf, this.currEnd, n4);
            n2 += n4;
            n3 -= n4;
            this.currEnd += n4;
            this.packEnd += (long)n4;
        }
    }

    private DfsBlock flushBlock() {
        DfsBlock dfsBlock;
        byte[] byArray;
        if (this.isEmptyPack) {
            throw new IOException(DfsText.get().willNotStoreEmptyPack);
        }
        this.out.write(this.currBuf, 0, this.currEnd);
        if (this.currEnd == this.currBuf.length) {
            byArray = this.currBuf;
        } else {
            byArray = new byte[this.currEnd];
            System.arraycopy(this.currBuf, 0, byArray, 0, this.currEnd);
        }
        this.readBlock = dfsBlock = new DfsBlock(this.packKey, this.currPos, byArray);
        this.blockCache.put(dfsBlock);
        return dfsBlock;
    }

    @Override
    protected void onPackFooter(byte[] byArray) {
        this.packHash = byArray;
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackedObjectInfo packedObjectInfo, PackParser.ObjectTypeAndSize objectTypeAndSize) {
        this.readPos = packedObjectInfo.getOffset();
        this.crc.reset();
        return this.readObjectHeader(objectTypeAndSize);
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackParser$UnresolvedDelta packParser$UnresolvedDelta, PackParser.ObjectTypeAndSize objectTypeAndSize) {
        this.readPos = packParser$UnresolvedDelta.getOffset();
        this.crc.reset();
        return this.readObjectHeader(objectTypeAndSize);
    }

    @Override
    protected int readDatabase(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        if (this.currPos <= this.readPos) {
            int n4 = (int)(this.readPos - this.currPos);
            int n5 = Math.min(n3, this.currEnd - n4);
            if (n5 == 0) {
                throw new EOFException();
            }
            System.arraycopy(this.currBuf, n4, byArray, n2, n5);
            this.readPos += (long)n5;
            return n5;
        }
        if (this.readBlock == null || !this.readBlock.contains(this.packKey, this.readPos)) {
            long l2 = this.toBlockStart(this.readPos);
            this.readBlock = (DfsBlock)this.blockCache.get(this.packKey, l2);
            if (this.readBlock == null) {
                int n6 = (int)Math.min((long)this.blockSize, this.packEnd - l2);
                byte[] byArray2 = new byte[n6];
                if (this.read(l2, byArray2, 0, n6) != n6) {
                    throw new EOFException();
                }
                this.readBlock = new DfsBlock(this.packKey, l2, byArray2);
                this.blockCache.put(this.readBlock);
            }
        }
        int n7 = this.readBlock.copy(this.readPos, byArray, n2, n3);
        this.readPos += (long)n7;
        return n7;
    }

    private int read(long l2, byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        int n5 = 0;
        while (0 < n3 && (n4 = this.out.read(l2, ByteBuffer.wrap(byArray, n2, n3))) > 0) {
            l2 += (long)n4;
            n2 += n4;
            n3 -= n4;
            n5 += n4;
        }
        return n5 != 0 ? n5 : -1;
    }

    private long toBlockStart(long l2) {
        return l2 / (long)this.blockSize * (long)this.blockSize;
    }

    @Override
    protected boolean checkCRC(int n2) {
        return n2 == (int)this.crc.getValue();
    }

    @Override
    protected boolean onAppendBase(int n2, byte[] byArray, PackedObjectInfo packedObjectInfo) {
        packedObjectInfo.setOffset(this.packEnd);
        byte[] byArray2 = this.buffer();
        int n3 = byArray.length;
        int n4 = 0;
        byArray2[n4++] = (byte)(n2 << 4 | n3 & 0xF);
        n3 >>>= 4;
        while (n3 > 0) {
            int n5 = n4 - 1;
            byArray2[n5] = (byte)(byArray2[n5] | 0xFFFFFF80);
            byArray2[n4++] = (byte)(n3 & 0x7F);
            n3 >>>= 7;
        }
        this.packDigest.update(byArray2, 0, n4);
        this.crc.reset();
        this.crc.update(byArray2, 0, n4);
        this.buffer(byArray2, 0, n4);
        if (this.def == null) {
            this.def = new Deflater(-1, false);
        } else {
            this.def.reset();
        }
        this.def.setInput(byArray);
        this.def.finish();
        while (!this.def.finished()) {
            n4 = this.def.deflate(byArray2);
            this.packDigest.update(byArray2, 0, n4);
            this.crc.update(byArray2, 0, n4);
            this.buffer(byArray2, 0, n4);
        }
        packedObjectInfo.setCRC((int)this.crc.getValue());
        return true;
    }

    @Override
    protected void onEndThinPack() {
        this.packHash = this.packDigest.digest();
    }

    private void writePackIndex() {
        List list = this.getSortedObjectList(null);
        this.packIndex = this.objins.writePackIndex(this.packDsc, this.packHash, list);
    }
}

