/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.LargeObjectException$ExceedsByteArrayLimit;
import org.eclipse.jgit.errors.LargeObjectException$OutOfMemory;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BeforeDfsPackIndexLoadedEvent;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache$Entry;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache$Ref;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile$Delta;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey$ForReverseIndex;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.dfs.LargePackedWholeObject;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectLoader$SmallObject;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.LongList;

public final class DfsPackFile
extends BlockBasedFile {
    private static final int REC_SIZE = 28;
    private static final long REF_POSITION = 0L;
    private final Object initLock = new Object();
    private volatile PackIndex index;
    private volatile PackReverseIndex reverseIndex;
    private volatile PackBitmapIndex bitmapIndex;
    private volatile LongList corruptObjects;

    DfsPackFile(DfsBlockCache dfsBlockCache, DfsPackDescription dfsPackDescription) {
        super(dfsBlockCache, dfsPackDescription, PackExt.PACK);
        long l2;
        int n2 = dfsPackDescription.getBlockSize(PackExt.PACK);
        if (n2 > 0) {
            this.setBlockSize(n2);
        }
        this.length = (l2 = dfsPackDescription.getFileSize(PackExt.PACK)) > 0L ? l2 : -1L;
    }

    public DfsPackDescription getPackDescription() {
        return this.desc;
    }

    public boolean isIndexLoaded() {
        return this.index != null;
    }

    void setPackIndex(PackIndex packIndex) {
        long l2 = packIndex.getObjectCount();
        int n2 = 28;
        long l3 = l2 * (long)n2;
        this.cache.putRef(this.desc.getStreamKey(PackExt.INDEX), l3, packIndex);
        this.index = packIndex;
    }

    public PackIndex getPackIndex(DfsReader dfsReader) {
        return this.idx(dfsReader);
    }

    private PackIndex idx(DfsReader dfsReader) {
        if (this.index != null) {
            return this.index;
        }
        if (this.invalid) {
            throw new PackInvalidException(this.getFileName(), (Throwable)this.invalidatingCause);
        }
        Repository.getGlobalListenerList().dispatch(new BeforeDfsPackIndexLoadedEvent(this));
        Object object = this.initLock;
        synchronized (object) {
            if (this.index != null) {
                return this.index;
            }
            try {
                DfsStreamKey dfsStreamKey = this.desc.getStreamKey(PackExt.INDEX);
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                DfsBlockCache$Ref dfsBlockCache$Ref = this.cache.getOrLoadRef(dfsStreamKey, 0L, () -> {
                    atomicBoolean.set(false);
                    return this.loadPackIndex(dfsReader, dfsStreamKey);
                });
                if (atomicBoolean.get()) {
                    ++dfsReader.stats.idxCacheHit;
                }
                PackIndex packIndex = (PackIndex)dfsBlockCache$Ref.get();
                if (this.index == null && packIndex != null) {
                    this.index = packIndex;
                }
                return this.index;
            }
            catch (IOException iOException) {
                this.invalid = true;
                this.invalidatingCause = iOException;
                throw iOException;
            }
        }
    }

    final boolean isGarbage() {
        return this.desc.getPackSource() == DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackBitmapIndex getBitmapIndex(DfsReader dfsReader) {
        if (this.invalid || this.isGarbage() || !this.desc.hasFileExt(PackExt.BITMAP_INDEX)) {
            return null;
        }
        if (this.bitmapIndex != null) {
            return this.bitmapIndex;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.bitmapIndex != null) {
                return this.bitmapIndex;
            }
            PackIndex packIndex = this.idx(dfsReader);
            PackReverseIndex packReverseIndex = this.getReverseIdx(dfsReader);
            DfsStreamKey dfsStreamKey = this.desc.getStreamKey(PackExt.BITMAP_INDEX);
            AtomicBoolean atomicBoolean = new AtomicBoolean(true);
            DfsBlockCache$Ref dfsBlockCache$Ref = this.cache.getOrLoadRef(dfsStreamKey, 0L, () -> {
                atomicBoolean.set(false);
                return this.loadBitmapIndex(dfsReader, dfsStreamKey, packIndex, packReverseIndex);
            });
            if (atomicBoolean.get()) {
                ++dfsReader.stats.bitmapCacheHit;
            }
            PackBitmapIndex packBitmapIndex = (PackBitmapIndex)dfsBlockCache$Ref.get();
            if (this.bitmapIndex == null && packBitmapIndex != null) {
                this.bitmapIndex = packBitmapIndex;
            }
            return this.bitmapIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackReverseIndex getReverseIdx(DfsReader dfsReader) {
        if (this.reverseIndex != null) {
            return this.reverseIndex;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.reverseIndex != null) {
                return this.reverseIndex;
            }
            PackIndex packIndex = this.idx(dfsReader);
            DfsStreamKey$ForReverseIndex dfsStreamKey$ForReverseIndex = new DfsStreamKey$ForReverseIndex(this.desc.getStreamKey(PackExt.INDEX));
            AtomicBoolean atomicBoolean = new AtomicBoolean(true);
            DfsBlockCache$Ref dfsBlockCache$Ref = this.cache.getOrLoadRef(dfsStreamKey$ForReverseIndex, 0L, () -> {
                atomicBoolean.set(false);
                return this.loadReverseIdx(dfsReader, dfsStreamKey$ForReverseIndex, packIndex);
            });
            if (atomicBoolean.get()) {
                ++dfsReader.stats.ridxCacheHit;
            }
            PackReverseIndex packReverseIndex = (PackReverseIndex)dfsBlockCache$Ref.get();
            if (this.reverseIndex == null && packReverseIndex != null) {
                this.reverseIndex = packReverseIndex;
            }
            return this.reverseIndex;
        }
    }

    public boolean hasObject(DfsReader dfsReader, AnyObjectId anyObjectId) {
        long l2 = this.idx(dfsReader).findOffset(anyObjectId);
        return 0L < l2 && !this.isCorrupt(l2);
    }

    ObjectLoader get(DfsReader dfsReader, AnyObjectId anyObjectId) {
        long l2 = this.idx(dfsReader).findOffset(anyObjectId);
        return 0L < l2 && !this.isCorrupt(l2) ? this.load(dfsReader, l2) : null;
    }

    long findOffset(DfsReader dfsReader, AnyObjectId anyObjectId) {
        return this.idx(dfsReader).findOffset(anyObjectId);
    }

    void resolve(DfsReader dfsReader, Set set, AbbreviatedObjectId abbreviatedObjectId, int n2) {
        this.idx(dfsReader).resolve(set, abbreviatedObjectId, n2);
    }

    long getObjectCount(DfsReader dfsReader) {
        return this.idx(dfsReader).getObjectCount();
    }

    private byte[] decompress(long l2, int n2, DfsReader dfsReader) {
        byte[] byArray;
        try {
            byArray = new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
        if (dfsReader.inflate(this, l2, byArray, false) != n2) {
            throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, l2));
        }
        return byArray;
    }

    void copyPackAsIs(PackOutputStream packOutputStream, DfsReader dfsReader) {
        if (this.length == -1L) {
            dfsReader.pin(this, 0L);
            dfsReader.unpin();
        }
        try (ReadableChannel readableChannel = dfsReader.db.openFile(this.desc, PackExt.PACK);){
            int n2 = dfsReader.getOptions().getStreamPackBufferSize();
            if (n2 > 0) {
                readableChannel.setReadAheadBytes(n2);
            }
            if (this.cache.shouldCopyThroughCache(this.length)) {
                this.copyPackThroughCache(packOutputStream, dfsReader, readableChannel);
            } else {
                this.copyPackBypassCache(packOutputStream, readableChannel);
            }
        }
    }

    private void copyPackThroughCache(PackOutputStream packOutputStream, DfsReader dfsReader, ReadableChannel readableChannel) {
        int n2;
        long l2 = 12L;
        for (long i2 = this.length - 32L; 0L < i2; i2 -= (long)n2) {
            DfsBlock dfsBlock = this.cache.getOrLoad(this, l2, dfsReader, () -> readableChannel);
            int n3 = (int)(l2 - dfsBlock.start);
            if (dfsBlock.size() <= n3) {
                throw this.packfileIsTruncated();
            }
            n2 = (int)Math.min((long)(dfsBlock.size() - n3), i2);
            dfsBlock.write(packOutputStream, l2, n2);
            l2 += (long)n2;
        }
    }

    private long copyPackBypassCache(PackOutputStream packOutputStream, ReadableChannel readableChannel) {
        ByteBuffer byteBuffer = this.newCopyBuffer(packOutputStream, readableChannel);
        long l2 = 12L;
        long l3 = this.length - 32L;
        boolean bl2 = false;
        while (0L < l3) {
            int n2;
            int n3;
            DfsBlock dfsBlock = (DfsBlock)this.cache.get(this.key, this.alignToBlock(l2));
            if (dfsBlock != null) {
                n3 = (int)(l2 - dfsBlock.start);
                if (dfsBlock.size() <= n3) {
                    throw this.packfileIsTruncated();
                }
                n2 = (int)Math.min((long)(dfsBlock.size() - n3), l3);
                dfsBlock.write(packOutputStream, l2, n2);
                l3 -= (long)n2;
                readableChannel.position(l2 += (long)n2);
                bl2 = true;
                continue;
            }
            n3 = bl2 ? 0 : 12;
            byteBuffer.position(0);
            n2 = DfsPackFile.read(readableChannel, byteBuffer);
            if (n2 <= n3) {
                throw this.packfileIsTruncated();
            }
            int n4 = (int)Math.min((long)(n2 - n3), l3);
            packOutputStream.write(byteBuffer.array(), n3, n4);
            l2 += (long)n4;
            l3 -= (long)n4;
            bl2 = true;
        }
        return l2;
    }

    private ByteBuffer newCopyBuffer(PackOutputStream packOutputStream, ReadableChannel readableChannel) {
        byte[] byArray;
        int n2 = this.blockSize(readableChannel);
        if (n2 > (byArray = packOutputStream.getCopyBuffer()).length) {
            byArray = new byte[n2];
        }
        return ByteBuffer.wrap(byArray, 0, n2);
    }

    void copyAsIs(PackOutputStream packOutputStream, DfsObjectToPack dfsObjectToPack, boolean bl2, DfsReader dfsReader) {
        long l2;
        long l3;
        long l4;
        DfsBlock dfsBlock;
        CRC32 cRC32 = bl2 ? new CRC32() : null;
        CRC32 cRC322 = bl2 ? new CRC32() : null;
        byte[] byArray = packOutputStream.getCopyBuffer();
        try {
            this.readFully(dfsObjectToPack.offset, byArray, 0, 20, dfsReader);
        }
        catch (IOException iOException) {
            throw new StoredObjectRepresentationNotAvailableException(dfsObjectToPack, (Throwable)iOException);
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = n2 >> 4 & 7;
        long l5 = n2 & 0xF;
        int n4 = 4;
        int n5 = 1;
        while ((n2 & 0x80) != 0) {
            n2 = byArray[n5++] & 0xFF;
            l5 += (long)(n2 & 0x7F) << n4;
            n4 += 7;
        }
        if (n3 == 6) {
            while (((n2 = byArray[n5++] & 0xFF) & 0x80) != 0) {
            }
            if (bl2) {
                assert (cRC32 != null && cRC322 != null);
                cRC32.update(byArray, 0, n5);
                cRC322.update(byArray, 0, n5);
            }
        } else if (n3 == 7) {
            if (bl2) {
                assert (cRC32 != null && cRC322 != null);
                cRC32.update(byArray, 0, n5);
                cRC322.update(byArray, 0, n5);
            }
            this.readFully(dfsObjectToPack.offset + (long)n5, byArray, 0, 20, dfsReader);
            if (bl2) {
                assert (cRC32 != null && cRC322 != null);
                cRC32.update(byArray, 0, 20);
                cRC322.update(byArray, 0, 20);
            }
            n5 += 20;
        } else if (bl2) {
            assert (cRC32 != null && cRC322 != null);
            cRC32.update(byArray, 0, n5);
            cRC322.update(byArray, 0, n5);
        }
        long l6 = dfsObjectToPack.offset + (long)n5;
        long l7 = dfsObjectToPack.length;
        try {
            dfsBlock = dfsReader.quickCopy(this, l6, l7);
            if (bl2 && this.idx(dfsReader).hasCRC32Support()) {
                assert (cRC32 != null);
                l4 = this.idx(dfsReader).findCRC32(dfsObjectToPack);
                if (dfsBlock != null) {
                    dfsBlock.crc32(cRC32, l6, (int)l7);
                } else {
                    int n6;
                    l3 = l6;
                    for (l2 = l7; l2 > 0L; l2 -= (long)n6) {
                        n6 = (int)Math.min(l2, (long)byArray.length);
                        this.readFully(l3, byArray, 0, n6, dfsReader);
                        cRC32.update(byArray, 0, n6);
                        l3 += (long)n6;
                    }
                }
                if (cRC32.getValue() != l4) {
                    this.setCorrupt(dfsObjectToPack.offset);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, dfsObjectToPack.offset, this.getFileName()));
                }
            } else if (bl2) {
                assert (cRC32 != null);
                Inflater inflater = dfsReader.inflater();
                byte[] byArray2 = new byte[1024];
                if (dfsBlock != null) {
                    dfsBlock.check(inflater, byArray2, l6, (int)l7);
                } else {
                    int n7;
                    l2 = l6;
                    for (long i2 = l7; i2 > 0L; i2 -= (long)n7) {
                        n7 = (int)Math.min(i2, (long)byArray.length);
                        this.readFully(l2, byArray, 0, n7, dfsReader);
                        cRC32.update(byArray, 0, n7);
                        inflater.setInput(byArray, 0, n7);
                        while (inflater.inflate(byArray2, 0, byArray2.length) > 0) {
                        }
                        l2 += (long)n7;
                    }
                }
                if (!inflater.finished() || inflater.getBytesRead() != l7) {
                    this.setCorrupt(dfsObjectToPack.offset);
                    throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, dfsObjectToPack.offset));
                }
                l4 = cRC32.getValue();
            } else {
                l4 = -1L;
            }
        }
        catch (DataFormatException dataFormatException) {
            this.setCorrupt(dfsObjectToPack.offset);
            CorruptObjectException corruptObjectException = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, dfsObjectToPack.offset, this.getFileName()), dataFormatException);
            throw new StoredObjectRepresentationNotAvailableException(dfsObjectToPack, (Throwable)corruptObjectException);
        }
        catch (IOException iOException) {
            throw new StoredObjectRepresentationNotAvailableException(dfsObjectToPack, (Throwable)iOException);
        }
        if (dfsBlock != null) {
            packOutputStream.writeHeader(dfsObjectToPack, l5);
            dfsBlock.write(packOutputStream, l6, (int)l7);
        } else if (l7 <= (long)byArray.length) {
            if (!bl2) {
                int n8;
                l3 = l6;
                for (l2 = l7; l2 > 0L; l2 -= (long)n8) {
                    n8 = (int)Math.min(l2, (long)byArray.length);
                    this.readFully(l3, byArray, 0, n8, dfsReader);
                    l3 += (long)n8;
                }
            }
            packOutputStream.writeHeader(dfsObjectToPack, l5);
            packOutputStream.write(byArray, 0, (int)l7);
        } else {
            int n9;
            packOutputStream.writeHeader(dfsObjectToPack, l5);
            l3 = l6;
            for (l2 = l7; l2 > 0L; l2 -= (long)n9) {
                n9 = (int)Math.min(l2, (long)byArray.length);
                this.readFully(l3, byArray, 0, n9, dfsReader);
                if (bl2) {
                    assert (cRC322 != null);
                    cRC322.update(byArray, 0, n9);
                }
                packOutputStream.write(byArray, 0, n9);
                l3 += (long)n9;
            }
            if (bl2) {
                assert (cRC322 != null);
                if (cRC322.getValue() != l4) {
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, dfsObjectToPack.offset, this.getFileName()));
                }
            }
        }
    }

    private IOException packfileIsTruncated() {
        this.invalid = true;
        IOException iOException = new IOException(MessageFormat.format(JGitText.get().packfileIsTruncated, this.getFileName()));
        this.invalidatingCause = iOException;
        return iOException;
    }

    private void readFully(long l2, byte[] byArray, int n2, int n3, DfsReader dfsReader) {
        while (n3 > 0) {
            int n4 = dfsReader.copy(this, l2, byArray, n2, n3);
            if (n4 == 0) {
                throw new EOFException();
            }
            l2 += (long)n4;
            n2 += n4;
            n3 -= n4;
        }
    }

    ObjectLoader load(DfsReader dfsReader, long l2) {
        try {
            byte[] byArray = dfsReader.tempId;
            DfsPackFile$Delta dfsPackFile$Delta = null;
            byte[] byArray2 = null;
            int n2 = -1;
            boolean bl2 = false;
            block9: while (true) {
                this.readFully(l2, byArray, 0, 20, dfsReader);
                int n3 = byArray[0] & 0xFF;
                int n4 = n3 >> 4 & 7;
                long l3 = n3 & 0xF;
                int n5 = 4;
                int n6 = 1;
                while ((n3 & 0x80) != 0) {
                    n3 = byArray[n6++] & 0xFF;
                    l3 += (long)(n3 & 0x7F) << n5;
                    n5 += 7;
                }
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (dfsPackFile$Delta != null) {
                            byArray2 = this.decompress(l2 + (long)n6, (int)l3, dfsReader);
                            n2 = n4;
                            break block9;
                        }
                        if (l3 < (long)dfsReader.getStreamFileThreshold() && (byArray2 = this.decompress(l2 + (long)n6, (int)l3, dfsReader)) != null) {
                            return new ObjectLoader$SmallObject(n4, byArray2);
                        }
                        return new LargePackedWholeObject(n4, l3, l2, n6, this, dfsReader.db);
                    }
                    case 6: {
                        n3 = byArray[n6++] & 0xFF;
                        long l4 = n3 & 0x7F;
                        while ((n3 & 0x80) != 0) {
                            ++l4;
                            n3 = byArray[n6++] & 0xFF;
                            l4 <<= 7;
                            l4 += (long)(n3 & 0x7F);
                        }
                        l4 = l2 - l4;
                        dfsPackFile$Delta = new DfsPackFile$Delta(dfsPackFile$Delta, l2, (int)l3, n6, l4);
                        if (l3 != (long)dfsPackFile$Delta.deltaSize) break block9;
                        DeltaBaseCache$Entry deltaBaseCache$Entry = dfsReader.getDeltaBaseCache().get(this.key, l4);
                        if (deltaBaseCache$Entry != null) {
                            n2 = deltaBaseCache$Entry.type;
                            byArray2 = deltaBaseCache$Entry.data;
                            bl2 = true;
                            break block9;
                        }
                        l2 = l4;
                        continue block9;
                    }
                    case 7: {
                        this.readFully(l2 + (long)n6, byArray, 0, 20, dfsReader);
                        long l4 = this.findDeltaBase(dfsReader, ObjectId.fromRaw(byArray));
                        dfsPackFile$Delta = new DfsPackFile$Delta(dfsPackFile$Delta, l2, (int)l3, n6 + 20, l4);
                        if (l3 != (long)dfsPackFile$Delta.deltaSize) break block9;
                        DeltaBaseCache$Entry deltaBaseCache$Entry = dfsReader.getDeltaBaseCache().get(this.key, l4);
                        if (deltaBaseCache$Entry != null) {
                            n2 = deltaBaseCache$Entry.type;
                            byArray2 = deltaBaseCache$Entry.data;
                            bl2 = true;
                            break block9;
                        }
                        l2 = l4;
                        continue block9;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n4));
                    }
                }
                break;
            }
            if (byArray2 == null) {
                throw new LargeObjectException();
            }
            assert (dfsPackFile$Delta != null);
            do {
                byte[] byArray3;
                if (bl2) {
                    bl2 = false;
                } else if (dfsPackFile$Delta.next == null) {
                    dfsReader.getDeltaBaseCache().put(this.key, dfsPackFile$Delta.basePos, n2, byArray2);
                }
                l2 = dfsPackFile$Delta.deltaPos;
                byte[] byArray4 = this.decompress(l2 + (long)dfsPackFile$Delta.hdrLen, dfsPackFile$Delta.deltaSize, dfsReader);
                if (byArray4 == null) {
                    byArray2 = null;
                    throw new LargeObjectException();
                }
                long l5 = BinaryDelta.getResultSize(byArray4);
                if (Integer.MAX_VALUE <= l5) {
                    throw new LargeObjectException$ExceedsByteArrayLimit();
                }
                try {
                    byArray3 = new byte[(int)l5];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    byArray2 = null;
                    byArray4 = null;
                    throw new LargeObjectException$OutOfMemory(outOfMemoryError);
                }
                BinaryDelta.apply(byArray2, byArray4, byArray3);
                byArray2 = byArray3;
            } while ((dfsPackFile$Delta = dfsPackFile$Delta.next) != null);
            return new ObjectLoader$SmallObject(n2, byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, l2, this.getFileName()), dataFormatException);
        }
    }

    private long findDeltaBase(DfsReader dfsReader, ObjectId objectId) {
        long l2 = this.idx(dfsReader).findOffset(objectId);
        if (l2 < 0L) {
            throw new MissingObjectException(objectId, JGitText.get().missingDeltaBase);
        }
        return l2;
    }

    byte[] getDeltaHeader(DfsReader dfsReader, long l2) {
        byte[] byArray = new byte[32];
        dfsReader.inflate(this, l2, byArray, true);
        return byArray;
    }

    int getObjectType(DfsReader dfsReader, long l2) {
        int n2;
        byte[] byArray = dfsReader.tempId;
        block5: while (true) {
            this.readFully(l2, byArray, 0, 20, dfsReader);
            int n3 = byArray[0] & 0xFF;
            n2 = n3 >> 4 & 7;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return n2;
                }
                case 6: {
                    int n4 = 1;
                    while ((n3 & 0x80) != 0) {
                        n3 = byArray[n4++] & 0xFF;
                    }
                    n3 = byArray[n4++] & 0xFF;
                    long l3 = n3 & 0x7F;
                    while ((n3 & 0x80) != 0) {
                        ++l3;
                        n3 = byArray[n4++] & 0xFF;
                        l3 <<= 7;
                        l3 += (long)(n3 & 0x7F);
                    }
                    l2 -= l3;
                    continue block5;
                }
                case 7: {
                    int n4 = 1;
                    while ((n3 & 0x80) != 0) {
                        n3 = byArray[n4++] & 0xFF;
                    }
                    this.readFully(l2 + (long)n4, byArray, 0, 20, dfsReader);
                    l2 = this.findDeltaBase(dfsReader, ObjectId.fromRaw(byArray));
                    continue block5;
                }
            }
            break;
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n2));
    }

    long getObjectSize(DfsReader dfsReader, AnyObjectId anyObjectId) {
        long l2 = this.idx(dfsReader).findOffset(anyObjectId);
        return 0L < l2 ? this.getObjectSize(dfsReader, l2) : -1L;
    }

    long getObjectSize(DfsReader dfsReader, long l2) {
        long l3;
        byte[] byArray = dfsReader.tempId;
        this.readFully(l2, byArray, 0, 20, dfsReader);
        int n2 = byArray[0] & 0xFF;
        int n3 = n2 >> 4 & 7;
        long l4 = n2 & 0xF;
        int n4 = 4;
        int n5 = 1;
        while ((n2 & 0x80) != 0) {
            n2 = byArray[n5++] & 0xFF;
            l4 += (long)(n2 & 0x7F) << n4;
            n4 += 7;
        }
        switch (n3) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return l4;
            }
            case 6: {
                n2 = byArray[n5++] & 0xFF;
                while ((n2 & 0x80) != 0) {
                    n2 = byArray[n5++] & 0xFF;
                }
                l3 = l2 + (long)n5;
                break;
            }
            case 7: {
                l3 = l2 + (long)n5 + 20L;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n3));
            }
        }
        try {
            return BinaryDelta.getResultSize(this.getDeltaHeader(dfsReader, l3));
        }
        catch (DataFormatException dataFormatException) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, l2, this.getFileName()), dataFormatException);
        }
    }

    void representation(DfsObjectRepresentation dfsObjectRepresentation, long l2, DfsReader dfsReader, PackReverseIndex packReverseIndex) {
        dfsObjectRepresentation.offset = l2;
        byte[] byArray = dfsReader.tempId;
        this.readFully(l2, byArray, 0, 20, dfsReader);
        int n2 = byArray[0] & 0xFF;
        int n3 = 1;
        int n4 = n2 >> 4 & 7;
        while ((n2 & 0x80) != 0) {
            n2 = byArray[n3++] & 0xFF;
        }
        long l3 = packReverseIndex.findNextOffset(l2, this.length - 20L) - l2;
        switch (n4) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                dfsObjectRepresentation.format = 1;
                dfsObjectRepresentation.baseId = null;
                dfsObjectRepresentation.length = l3 - (long)n3;
                return;
            }
            case 6: {
                n2 = byArray[n3++] & 0xFF;
                long l4 = n2 & 0x7F;
                while ((n2 & 0x80) != 0) {
                    ++l4;
                    n2 = byArray[n3++] & 0xFF;
                    l4 <<= 7;
                    l4 += (long)(n2 & 0x7F);
                }
                dfsObjectRepresentation.format = 0;
                dfsObjectRepresentation.baseId = packReverseIndex.findObject(l2 - l4);
                dfsObjectRepresentation.length = l3 - (long)n3;
                return;
            }
            case 7: {
                this.readFully(l2 + (long)n3, byArray, 0, 20, dfsReader);
                dfsObjectRepresentation.format = 0;
                dfsObjectRepresentation.baseId = ObjectId.fromRaw(byArray);
                dfsObjectRepresentation.length = l3 - (long)n3 - 20L;
                return;
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCorrupt(long l2) {
        LongList longList = this.corruptObjects;
        if (longList == null) {
            return false;
        }
        LongList longList2 = longList;
        synchronized (longList2) {
            return longList.contains(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCorrupt(long l2) {
        Object object;
        LongList longList = this.corruptObjects;
        if (longList == null) {
            object = this.initLock;
            synchronized (object) {
                longList = this.corruptObjects;
                if (longList == null) {
                    this.corruptObjects = longList = new LongList();
                }
            }
        }
        object = longList;
        synchronized (object) {
            longList.add(l2);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private DfsBlockCache$Ref loadPackIndex(DfsReader dfsReader, DfsStreamKey dfsStreamKey) {
        try {
            ++dfsReader.stats.readIdx;
            long l2 = System.nanoTime();
            try {
                try (ReadableChannel readableChannel = dfsReader.db.openFile(this.desc, PackExt.INDEX);){
                    InputStream inputStream = Channels.newInputStream(readableChannel);
                    int n2 = 8192;
                    int n3 = readableChannel.blockSize();
                    if (0 < n3 && n3 < n2) {
                        n3 = n2 / n3 * n3;
                    } else if (n3 <= 0) {
                        n3 = n2;
                    }
                    PackIndex packIndex = PackIndex.read(new BufferedInputStream(inputStream, n3));
                    dfsReader.stats.readIdxBytes += readableChannel.position();
                    this.index = packIndex;
                    DfsBlockCache$Ref dfsBlockCache$Ref = new DfsBlockCache$Ref(dfsStreamKey, 0L, packIndex.getObjectCount() * 28L, packIndex);
                    return dfsBlockCache$Ref;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                dfsReader.stats.readIdxMicros += DfsPackFile.elapsedMicros(l2);
            }
        }
        catch (EOFException eOFException) {
            throw new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, this.desc.getFileName(PackExt.INDEX)), eOFException);
        }
        catch (IOException iOException) {
            throw new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, this.desc.getFileName(PackExt.INDEX)), iOException);
        }
    }

    private DfsBlockCache$Ref loadReverseIdx(DfsReader dfsReader, DfsStreamKey dfsStreamKey, PackIndex packIndex) {
        PackReverseIndex packReverseIndex;
        ++dfsReader.stats.readReverseIdx;
        long l2 = System.nanoTime();
        this.reverseIndex = packReverseIndex = new PackReverseIndex(packIndex);
        dfsReader.stats.readReverseIdxMicros += DfsPackFile.elapsedMicros(l2);
        return new DfsBlockCache$Ref(dfsStreamKey, 0L, packIndex.getObjectCount() * 8L, packReverseIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DfsBlockCache$Ref loadBitmapIndex(DfsReader dfsReader, DfsStreamKey dfsStreamKey, PackIndex packIndex, PackReverseIndex packReverseIndex) {
        ++dfsReader.stats.readBitmap;
        long l2 = System.nanoTime();
        try (ReadableChannel readableChannel = dfsReader.db.openFile(this.desc, PackExt.BITMAP_INDEX);){
            long l3;
            PackBitmapIndex packBitmapIndex;
            Object object;
            try {
                object = Channels.newInputStream(readableChannel);
                int n2 = 8192;
                int n3 = readableChannel.blockSize();
                if (0 < n3 && n3 < n2) {
                    n3 = n2 / n3 * n3;
                } else if (n3 <= 0) {
                    n3 = n2;
                }
                object = new BufferedInputStream((InputStream)object, n3);
                packBitmapIndex = PackBitmapIndex.read((InputStream)object, packIndex, packReverseIndex);
            }
            finally {
                l3 = readableChannel.position();
                dfsReader.stats.readBitmapIdxBytes += l3;
                dfsReader.stats.readBitmapIdxMicros += DfsPackFile.elapsedMicros(l2);
            }
            this.bitmapIndex = packBitmapIndex;
            object = new DfsBlockCache$Ref(dfsStreamKey, 0L, l3, packBitmapIndex);
            return object;
        }
        catch (EOFException eOFException) {
            throw new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, this.desc.getFileName(PackExt.BITMAP_INDEX)), eOFException);
        }
        catch (IOException iOException) {
            throw new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, this.desc.getFileName(PackExt.BITMAP_INDEX)), iOException);
        }
    }
}

