/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$Stats;
import org.eclipse.jgit.storage.pack.PackStatistics;

public class DfsPackDescription {
    private final DfsRepositoryDescription repoDesc;
    private final String packName;
    private DfsObjDatabase$PackSource packSource;
    private long lastModified;
    private long[] sizeMap;
    private int[] blockSizeMap;
    private long objectCount;
    private long deltaCount;
    private long minUpdateIndex;
    private long maxUpdateIndex;
    private PackStatistics packStats;
    private ReftableWriter$Stats refStats;
    private int extensions;
    private int indexVersion;
    private long estimatedPackSize;

    public static Comparator objectLookupComparator() {
        return DfsPackDescription.objectLookupComparator(DfsObjDatabase$PackSource.DEFAULT_COMPARATOR);
    }

    public static Comparator objectLookupComparator(Comparator comparator) {
        return Comparator.comparing(DfsPackDescription::getPackSource, comparator).thenComparing((dfsPackDescription, dfsPackDescription2) -> {
            int n2;
            DfsObjDatabase$PackSource dfsObjDatabase$PackSource;
            DfsObjDatabase$PackSource dfsObjDatabase$PackSource2 = dfsPackDescription.getPackSource();
            if (dfsObjDatabase$PackSource2 == (dfsObjDatabase$PackSource = dfsPackDescription2.getPackSource()) && DfsPackDescription.isGC(dfsObjDatabase$PackSource2) && (n2 = Long.signum(dfsPackDescription.getFileSize(PackExt.PACK) - dfsPackDescription2.getFileSize(PackExt.PACK))) != 0) {
                return n2;
            }
            n2 = Long.signum(dfsPackDescription2.getLastModified() - dfsPackDescription.getLastModified());
            if (n2 != 0) {
                return n2;
            }
            return Long.signum(dfsPackDescription.getObjectCount() - dfsPackDescription2.getObjectCount());
        });
    }

    static Comparator reftableComparator() {
        return (dfsPackDescription, dfsPackDescription2) -> {
            int n2 = DfsObjDatabase$PackSource.DEFAULT_COMPARATOR.reversed().compare(dfsPackDescription.getPackSource(), dfsPackDescription2.getPackSource());
            if (n2 != 0) {
                return n2;
            }
            n2 = Long.signum(dfsPackDescription.getMaxUpdateIndex() - dfsPackDescription2.getMaxUpdateIndex());
            if (n2 != 0) {
                return n2;
            }
            return Long.signum(dfsPackDescription.getLastModified() - dfsPackDescription2.getLastModified());
        };
    }

    static Comparator reuseComparator() {
        return (dfsPackDescription, dfsPackDescription2) -> {
            DfsObjDatabase$PackSource dfsObjDatabase$PackSource;
            DfsObjDatabase$PackSource dfsObjDatabase$PackSource2 = dfsPackDescription.getPackSource();
            if (dfsObjDatabase$PackSource2 == (dfsObjDatabase$PackSource = dfsPackDescription2.getPackSource()) && DfsPackDescription.isGC(dfsObjDatabase$PackSource2)) {
                return Long.signum(dfsPackDescription2.getFileSize(PackExt.PACK) - dfsPackDescription.getFileSize(PackExt.PACK));
            }
            return 0;
        };
    }

    public DfsPackDescription(DfsRepositoryDescription dfsRepositoryDescription, String string, @NonNull DfsObjDatabase$PackSource dfsObjDatabase$PackSource) {
        this.repoDesc = dfsRepositoryDescription;
        int n2 = string.lastIndexOf(46);
        this.packName = n2 < 0 ? string : string.substring(0, n2);
        this.packSource = dfsObjDatabase$PackSource;
        int n3 = PackExt.values().length;
        this.sizeMap = new long[n3];
        this.blockSizeMap = new int[n3];
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public void addFileExt(PackExt packExt) {
        this.extensions |= packExt.getBit();
    }

    public boolean hasFileExt(PackExt packExt) {
        return (this.extensions & packExt.getBit()) != 0;
    }

    public String getFileName(PackExt packExt) {
        return this.packName + '.' + packExt.getExtension();
    }

    public DfsStreamKey getStreamKey(PackExt packExt) {
        return DfsStreamKey.of(this.getRepositoryDescription(), this.getFileName(packExt), packExt);
    }

    @NonNull
    public DfsObjDatabase$PackSource getPackSource() {
        return this.packSource;
    }

    public DfsPackDescription setPackSource(@NonNull DfsObjDatabase$PackSource dfsObjDatabase$PackSource) {
        this.packSource = dfsObjDatabase$PackSource;
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public DfsPackDescription setLastModified(long l2) {
        this.lastModified = l2;
        return this;
    }

    public long getMinUpdateIndex() {
        return this.minUpdateIndex;
    }

    public DfsPackDescription setMinUpdateIndex(long l2) {
        this.minUpdateIndex = l2;
        return this;
    }

    public long getMaxUpdateIndex() {
        return this.maxUpdateIndex;
    }

    public DfsPackDescription setMaxUpdateIndex(long l2) {
        this.maxUpdateIndex = l2;
        return this;
    }

    public DfsPackDescription setFileSize(PackExt packExt, long l2) {
        int n2 = packExt.getPosition();
        if (n2 >= this.sizeMap.length) {
            this.sizeMap = Arrays.copyOf(this.sizeMap, n2 + 1);
        }
        this.sizeMap[n2] = Math.max(0L, l2);
        return this;
    }

    public long getFileSize(PackExt packExt) {
        int n2 = packExt.getPosition();
        return n2 < this.sizeMap.length ? this.sizeMap[n2] : 0L;
    }

    public int getBlockSize(PackExt packExt) {
        int n2 = packExt.getPosition();
        return n2 < this.blockSizeMap.length ? this.blockSizeMap[n2] : 0;
    }

    public DfsPackDescription setBlockSize(PackExt packExt, int n2) {
        int n3 = packExt.getPosition();
        if (n3 >= this.blockSizeMap.length) {
            this.blockSizeMap = Arrays.copyOf(this.blockSizeMap, n3 + 1);
        }
        this.blockSizeMap[n3] = Math.max(0, n2);
        return this;
    }

    public DfsPackDescription setEstimatedPackSize(long l2) {
        this.estimatedPackSize = Math.max(0L, l2);
        return this;
    }

    public long getEstimatedPackSize() {
        return this.estimatedPackSize;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public DfsPackDescription setObjectCount(long l2) {
        this.objectCount = Math.max(0L, l2);
        return this;
    }

    public long getDeltaCount() {
        return this.deltaCount;
    }

    public DfsPackDescription setDeltaCount(long l2) {
        this.deltaCount = Math.max(0L, l2);
        return this;
    }

    public PackStatistics getPackStats() {
        return this.packStats;
    }

    DfsPackDescription setPackStats(PackStatistics packStatistics) {
        this.packStats = packStatistics;
        this.setFileSize(PackExt.PACK, packStatistics.getTotalBytes());
        this.setObjectCount(packStatistics.getTotalObjects());
        this.setDeltaCount(packStatistics.getTotalDeltas());
        return this;
    }

    public ReftableWriter$Stats getReftableStats() {
        return this.refStats;
    }

    void setReftableStats(ReftableWriter$Stats reftableWriter$Stats) {
        this.refStats = reftableWriter$Stats;
        this.setMinUpdateIndex(reftableWriter$Stats.minUpdateIndex());
        this.setMaxUpdateIndex(reftableWriter$Stats.maxUpdateIndex());
        this.setFileSize(PackExt.REFTABLE, reftableWriter$Stats.totalBytes());
        this.setBlockSize(PackExt.REFTABLE, reftableWriter$Stats.refBlockSize());
    }

    public DfsPackDescription clearPackStats() {
        this.packStats = null;
        this.refStats = null;
        return this;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public DfsPackDescription setIndexVersion(int n2) {
        this.indexVersion = n2;
        return this;
    }

    public int hashCode() {
        return this.packName.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DfsPackDescription) {
            DfsPackDescription dfsPackDescription = (DfsPackDescription)object;
            return this.packName.equals(dfsPackDescription.packName) && this.getRepositoryDescription().equals(dfsPackDescription.getRepositoryDescription());
        }
        return false;
    }

    static boolean isGC(DfsObjDatabase$PackSource dfsObjDatabase$PackSource) {
        switch (dfsObjDatabase$PackSource) {
            case GC: 
            case GC_REST: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getFileName(PackExt.PACK);
    }
}

