/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackCompactor$ObjectIdWithOffset;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableStack;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex$MutableEntry;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsPackCompactor {
    private final DfsRepository repo;
    private final List srcPacks;
    private final List srcReftables;
    private final List exclude;
    private PackStatistics newStats;
    private DfsPackDescription outDesc;
    private int autoAddSize;
    private ReftableConfig reftableConfig;
    private RevWalk rw;
    private RevFlag added;
    private RevFlag isBase;

    public DfsPackCompactor(DfsRepository dfsRepository) {
        this.repo = dfsRepository;
        this.autoAddSize = 0x500000;
        this.srcPacks = new ArrayList();
        this.srcReftables = new ArrayList();
        this.exclude = new ArrayList(4);
    }

    public DfsPackCompactor setReftableConfig(ReftableConfig reftableConfig) {
        this.reftableConfig = reftableConfig;
        return this;
    }

    public DfsPackCompactor add(DfsPackFile dfsPackFile) {
        this.srcPacks.add(dfsPackFile);
        return this;
    }

    public DfsPackCompactor add(DfsReftable dfsReftable) {
        this.srcReftables.add(dfsReftable);
        return this;
    }

    public DfsPackCompactor autoAdd() {
        DfsPackDescription dfsPackDescription;
        DfsObjDatabase dfsObjDatabase = this.repo.getObjectDatabase();
        for (DfsPackFile blockBasedFile : dfsObjDatabase.getPacks()) {
            dfsPackDescription = blockBasedFile.getPackDescription();
            if (dfsPackDescription.getFileSize(PackExt.PACK) < (long)this.autoAddSize) {
                this.add(blockBasedFile);
                continue;
            }
            this.exclude(blockBasedFile);
        }
        if (this.reftableConfig != null) {
            for (BlockBasedFile blockBasedFile : dfsObjDatabase.getReftables()) {
                dfsPackDescription = ((DfsReftable)blockBasedFile).getPackDescription();
                if (dfsPackDescription.getPackSource() == DfsObjDatabase$PackSource.GC || dfsPackDescription.getFileSize(PackExt.REFTABLE) >= (long)this.autoAddSize) continue;
                this.add((DfsReftable)blockBasedFile);
            }
        }
        return this;
    }

    public DfsPackCompactor exclude(ObjectIdSet objectIdSet) {
        this.exclude.add(objectIdSet);
        return this;
    }

    public DfsPackCompactor exclude(DfsPackFile dfsPackFile) {
        PackIndex packIndex;
        try (DfsReader dfsReader = (DfsReader)this.repo.newObjectReader();){
            packIndex = dfsPackFile.getPackIndex(dfsReader);
        }
        return this.exclude(packIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        DfsObjDatabase dfsObjDatabase = this.repo.getObjectDatabase();
        try (DfsReader dfsReader = dfsObjDatabase.newReader();){
            if (this.reftableConfig != null && !this.srcReftables.isEmpty()) {
                this.compactReftables(dfsReader);
            }
            this.compactPacks(dfsReader, progressMonitor);
            List list = this.getNewPacks();
            Collection collection = this.toPrune();
            if (!list.isEmpty() || !collection.isEmpty()) {
                dfsObjDatabase.commitPack(list, collection);
            }
        }
        finally {
            this.rw = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactPacks(DfsReader dfsReader, ProgressMonitor progressMonitor) {
        DfsObjDatabase dfsObjDatabase = this.repo.getObjectDatabase();
        PackConfig packConfig = new PackConfig(this.repo);
        packConfig.setIndexVersion(2);
        packConfig.setDeltaCompress(false);
        packConfig.setReuseDeltas(true);
        packConfig.setReuseObjects(true);
        try (PackWriter packWriter = new PackWriter(packConfig, (ObjectReader)dfsReader);){
            packWriter.setDeltaBaseAsOffset(true);
            packWriter.setReuseDeltaCommits(false);
            this.addObjectsToPack(packWriter, dfsReader, progressMonitor);
            if (packWriter.getObjectCount() == 0L) {
                return;
            }
            boolean bl2 = true;
            this.initOutDesc(dfsObjDatabase);
            try {
                DfsPackCompactor.writePack(dfsObjDatabase, this.outDesc, packWriter, progressMonitor);
                DfsPackCompactor.writeIndex(dfsObjDatabase, this.outDesc, packWriter);
                PackStatistics packStatistics = packWriter.getStatistics();
                this.outDesc.setPackStats(packStatistics);
                this.newStats = packStatistics;
                bl2 = false;
            }
            finally {
                if (bl2) {
                    dfsObjDatabase.rollbackPack(Collections.singletonList(this.outDesc));
                }
            }
        }
    }

    private long estimatePackSize() {
        long l2 = 32L;
        for (DfsPackFile dfsPackFile : this.srcPacks) {
            l2 += dfsPackFile.getPackDescription().getFileSize(PackExt.PACK) - 32L;
        }
        return l2;
    }

    private void compactReftables(DfsReader dfsReader) {
        DfsObjDatabase dfsObjDatabase = this.repo.getObjectDatabase();
        Collections.sort(this.srcReftables, dfsObjDatabase.reftableComparator());
        this.initOutDesc(dfsObjDatabase);
        try (DfsReftableStack dfsReftableStack = DfsReftableStack.open(dfsReader, this.srcReftables);
             DfsOutputStream dfsOutputStream = dfsObjDatabase.writeFile(this.outDesc, PackExt.REFTABLE);){
            ReftableCompactor reftableCompactor = new ReftableCompactor(dfsOutputStream);
            reftableCompactor.addAll(dfsReftableStack.readers());
            reftableCompactor.setIncludeDeletes(true);
            reftableCompactor.setConfig(DfsPackCompactor.configureReftable(this.reftableConfig, dfsOutputStream));
            reftableCompactor.compact();
            this.outDesc.addFileExt(PackExt.REFTABLE);
            this.outDesc.setReftableStats(reftableCompactor.getStats());
        }
    }

    private void initOutDesc(DfsObjDatabase dfsObjDatabase) {
        if (this.outDesc == null) {
            this.outDesc = dfsObjDatabase.newPack(DfsObjDatabase$PackSource.COMPACT, this.estimatePackSize());
        }
    }

    public Collection getSourcePacks() {
        HashSet<DfsPackDescription> hashSet = new HashSet<DfsPackDescription>();
        for (BlockBasedFile blockBasedFile : this.srcPacks) {
            hashSet.add(((DfsPackFile)blockBasedFile).getPackDescription());
        }
        for (BlockBasedFile blockBasedFile : this.srcReftables) {
            hashSet.add(((DfsReftable)blockBasedFile).getPackDescription());
        }
        return hashSet;
    }

    public List getNewPacks() {
        return this.outDesc != null ? Collections.singletonList(this.outDesc) : Collections.emptyList();
    }

    public List getNewPackStatistics() {
        return this.outDesc != null ? Collections.singletonList(this.newStats) : Collections.emptyList();
    }

    private Collection toPrune() {
        Object object3;
        Object object22;
        HashSet<DfsPackDescription> hashSet = new HashSet<DfsPackDescription>();
        for (Object object22 : this.srcPacks) {
            hashSet.add(((DfsPackFile)object22).getPackDescription());
        }
        HashSet hashSet2 = new HashSet();
        for (Object object3 : this.srcReftables) {
            hashSet2.add(((DfsReftable)object3).getPackDescription());
        }
        object22 = hashSet.iterator();
        while (object22.hasNext()) {
            object3 = (DfsPackDescription)object22.next();
            if (!((DfsPackDescription)object3).hasFileExt(PackExt.REFTABLE) || hashSet2.contains(object3)) continue;
            object22.remove();
        }
        object22 = hashSet2.iterator();
        while (object22.hasNext()) {
            object3 = (DfsPackDescription)object22.next();
            if (!((DfsPackDescription)object3).hasFileExt(PackExt.PACK) || hashSet.contains(object3)) continue;
            object22.remove();
        }
        object22 = new HashSet();
        object22.addAll(hashSet);
        object22.addAll(hashSet2);
        return object22;
    }

    private void addObjectsToPack(PackWriter packWriter, DfsReader dfsReader, ProgressMonitor progressMonitor) {
        Collections.sort(this.srcPacks, Comparator.comparing(DfsPackFile::getPackDescription, DfsPackDescription.objectLookupComparator()));
        this.rw = new RevWalk(dfsReader);
        this.added = this.rw.newFlag("ADDED");
        this.isBase = this.rw.newFlag("IS_BASE");
        BlockList blockList = new BlockList();
        progressMonitor.beginTask(JGitText.get().countingObjects, 0);
        for (Object object : this.srcPacks) {
            List list = this.toInclude((DfsPackFile)object, dfsReader);
            if (list.isEmpty()) continue;
            PackReverseIndex packReverseIndex = ((DfsPackFile)object).getReverseIdx(dfsReader);
            DfsObjectRepresentation dfsObjectRepresentation = new DfsObjectRepresentation((DfsPackFile)object);
            for (DfsPackCompactor$ObjectIdWithOffset dfsPackCompactor$ObjectIdWithOffset : list) {
                RevObject revObject;
                int n2;
                RevObject revObject2 = this.rw.lookupAny(dfsPackCompactor$ObjectIdWithOffset, n2 = ((DfsPackFile)object).getObjectType(dfsReader, dfsPackCompactor$ObjectIdWithOffset.offset));
                if (revObject2.has(this.added)) continue;
                progressMonitor.update(1);
                packWriter.addObject(revObject2);
                revObject2.add(this.added);
                ((DfsPackFile)object).representation(dfsObjectRepresentation, dfsPackCompactor$ObjectIdWithOffset.offset, dfsReader, packReverseIndex);
                if (dfsObjectRepresentation.getFormat() != 0 || (revObject = this.rw.lookupAny(dfsObjectRepresentation.getDeltaBase(), n2)).has(this.added) || revObject.has(this.isBase)) continue;
                blockList.add(revObject);
                revObject.add(this.isBase);
            }
        }
        for (Object object : blockList) {
            if (((RevObject)object).has(this.added)) continue;
            progressMonitor.update(1);
            packWriter.addObject((RevObject)object);
            ((RevObject)object).add(this.added);
        }
        progressMonitor.endTask();
    }

    private List toInclude(DfsPackFile dfsPackFile, DfsReader dfsReader) {
        PackIndex packIndex = dfsPackFile.getPackIndex(dfsReader);
        BlockList blockList = new BlockList((int)packIndex.getObjectCount());
        block0: for (PackIndex$MutableEntry packIndex$MutableEntry : packIndex) {
            ObjectId objectId = packIndex$MutableEntry.toObjectId();
            RevObject revObject = this.rw.lookupOrNull(objectId);
            if (revObject != null && (revObject.has(this.added) || revObject.has(this.isBase))) continue;
            for (ObjectIdSet objectIdSet : this.exclude) {
                if (!objectIdSet.contains(objectId)) continue;
                continue block0;
            }
            blockList.add(new DfsPackCompactor$ObjectIdWithOffset(objectId, packIndex$MutableEntry.getOffset()));
        }
        Collections.sort(blockList, (dfsPackCompactor$ObjectIdWithOffset, dfsPackCompactor$ObjectIdWithOffset2) -> Long.signum(dfsPackCompactor$ObjectIdWithOffset.offset - dfsPackCompactor$ObjectIdWithOffset2.offset));
        return blockList;
    }

    private static void writePack(DfsObjDatabase dfsObjDatabase, DfsPackDescription dfsPackDescription, PackWriter packWriter, ProgressMonitor progressMonitor) {
        try (DfsOutputStream dfsOutputStream = dfsObjDatabase.writeFile(dfsPackDescription, PackExt.PACK);){
            packWriter.writePack(progressMonitor, progressMonitor, dfsOutputStream);
            dfsPackDescription.addFileExt(PackExt.PACK);
            dfsPackDescription.setBlockSize(PackExt.PACK, dfsOutputStream.blockSize());
        }
    }

    private static void writeIndex(DfsObjDatabase dfsObjDatabase, DfsPackDescription dfsPackDescription, PackWriter packWriter) {
        try (DfsOutputStream dfsOutputStream = dfsObjDatabase.writeFile(dfsPackDescription, PackExt.INDEX);){
            CountingOutputStream countingOutputStream = new CountingOutputStream(dfsOutputStream);
            packWriter.writeIndex(countingOutputStream);
            dfsPackDescription.addFileExt(PackExt.INDEX);
            dfsPackDescription.setFileSize(PackExt.INDEX, countingOutputStream.getCount());
            dfsPackDescription.setBlockSize(PackExt.INDEX, dfsOutputStream.blockSize());
            dfsPackDescription.setIndexVersion(packWriter.getIndexVersion());
        }
    }

    static ReftableConfig configureReftable(ReftableConfig reftableConfig, DfsOutputStream dfsOutputStream) {
        int n2 = dfsOutputStream.blockSize();
        if (n2 > 0) {
            reftableConfig = new ReftableConfig(reftableConfig);
            reftableConfig.setRefBlockSize(n2);
            reftableConfig.setAlignBlocks(true);
        }
        return reftableConfig;
    }
}

