/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$1;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackList;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackListImpl;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPacksChangedEvent;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;

public abstract class DfsObjDatabase
extends ObjectDatabase {
    private static final DfsObjDatabase$PackList NO_PACKS = new DfsObjDatabase$1(new DfsPackFile[0], new DfsReftable[0]);
    private final AtomicReference packList;
    private final DfsRepository repository;
    private DfsReaderOptions readerOptions;
    private Comparator packComparator;

    protected DfsObjDatabase(DfsRepository dfsRepository, DfsReaderOptions dfsReaderOptions) {
        this.repository = dfsRepository;
        this.packList = new AtomicReference<DfsObjDatabase$PackList>(NO_PACKS);
        this.readerOptions = dfsReaderOptions;
        this.packComparator = DfsPackDescription.objectLookupComparator();
    }

    public DfsReaderOptions getReaderOptions() {
        return this.readerOptions;
    }

    public void setPackComparator(Comparator comparator) {
        this.packComparator = comparator;
    }

    @Override
    public DfsReader newReader() {
        return new DfsReader(this);
    }

    @Override
    public ObjectInserter newInserter() {
        return new DfsInserter(this);
    }

    public DfsPackFile[] getPacks() {
        return this.getPackList().packs;
    }

    public DfsReftable[] getReftables() {
        return this.getPackList().reftables;
    }

    public DfsObjDatabase$PackList getPackList() {
        return this.scanPacks(NO_PACKS);
    }

    protected DfsRepository getRepository() {
        return this.repository;
    }

    public DfsPackFile[] getCurrentPacks() {
        return this.getCurrentPackList().packs;
    }

    public DfsReftable[] getCurrentReftables() {
        return this.getCurrentPackList().reftables;
    }

    public DfsObjDatabase$PackList getCurrentPackList() {
        return (DfsObjDatabase$PackList)this.packList.get();
    }

    public boolean has(AnyObjectId anyObjectId, boolean bl2) {
        try (DfsReader dfsReader = this.newReader();){
            ((ObjectReader)dfsReader).setAvoidUnreachableObjects(bl2);
            boolean bl3 = ((ObjectReader)dfsReader).has(anyObjectId);
            return bl3;
        }
    }

    protected abstract DfsPackDescription newPack(DfsObjDatabase$PackSource var1);

    protected DfsPackDescription newPack(DfsObjDatabase$PackSource dfsObjDatabase$PackSource, long l2) {
        DfsPackDescription dfsPackDescription = this.newPack(dfsObjDatabase$PackSource);
        dfsPackDescription.setEstimatedPackSize(l2);
        return dfsPackDescription;
    }

    protected void commitPack(Collection collection, Collection collection2) {
        this.commitPackImpl(collection, collection2);
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
    }

    protected abstract void commitPackImpl(Collection var1, Collection var2);

    protected abstract void rollbackPack(Collection var1);

    protected abstract List listPacks();

    protected abstract ReadableChannel openFile(DfsPackDescription var1, PackExt var2);

    protected abstract DfsOutputStream writeFile(DfsPackDescription var1, PackExt var2);

    void addPack(DfsPackFile dfsPackFile) {
        DfsPackFile[] dfsPackFileArray;
        DfsObjDatabase$PackListImpl dfsObjDatabase$PackListImpl;
        DfsObjDatabase$PackList dfsObjDatabase$PackList;
        do {
            if ((dfsObjDatabase$PackList = (DfsObjDatabase$PackList)this.packList.get()) == NO_PACKS) {
                dfsObjDatabase$PackList = this.scanPacks(dfsObjDatabase$PackList);
                for (DfsPackFile dfsPackFile2 : dfsObjDatabase$PackList.packs) {
                    if (!dfsPackFile2.key.equals(dfsPackFile.key)) continue;
                    return;
                }
            }
            dfsPackFileArray = new DfsPackFile[1 + dfsObjDatabase$PackList.packs.length];
            dfsPackFileArray[0] = dfsPackFile;
            System.arraycopy(dfsObjDatabase$PackList.packs, 0, dfsPackFileArray, 1, dfsObjDatabase$PackList.packs.length);
        } while (!this.packList.compareAndSet(dfsObjDatabase$PackList, dfsObjDatabase$PackListImpl = new DfsObjDatabase$PackListImpl(dfsPackFileArray, dfsObjDatabase$PackList.reftables)));
    }

    void addReftable(DfsPackDescription dfsPackDescription, Set set) {
        ArrayList arrayList;
        DfsObjDatabase$PackListImpl dfsObjDatabase$PackListImpl;
        DfsObjDatabase$PackList dfsObjDatabase$PackList;
        do {
            if ((dfsObjDatabase$PackList = (DfsObjDatabase$PackList)this.packList.get()) == NO_PACKS) {
                dfsObjDatabase$PackList = this.scanPacks(dfsObjDatabase$PackList);
                for (DfsReftable dfsReftable : dfsObjDatabase$PackList.reftables) {
                    if (!dfsReftable.getPackDescription().equals(dfsPackDescription)) continue;
                    return;
                }
            }
            arrayList = new ArrayList(1 + dfsObjDatabase$PackList.reftables.length);
            for (DfsReftable dfsReftable : dfsObjDatabase$PackList.reftables) {
                if (set.contains(dfsReftable.getPackDescription())) continue;
                arrayList.add(dfsReftable);
            }
            arrayList.add(new DfsReftable(dfsPackDescription));
        } while (!this.packList.compareAndSet(dfsObjDatabase$PackList, dfsObjDatabase$PackListImpl = new DfsObjDatabase$PackListImpl(dfsObjDatabase$PackList.packs, arrayList.toArray(new DfsReftable[0]))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsObjDatabase$PackList scanPacks(DfsObjDatabase$PackList dfsObjDatabase$PackList) {
        DfsObjDatabase$PackList dfsObjDatabase$PackList2;
        AtomicReference atomicReference = this.packList;
        synchronized (atomicReference) {
            DfsObjDatabase$PackList dfsObjDatabase$PackList3;
            do {
                if ((dfsObjDatabase$PackList3 = (DfsObjDatabase$PackList)this.packList.get()) != dfsObjDatabase$PackList) {
                    return dfsObjDatabase$PackList3;
                }
                dfsObjDatabase$PackList2 = this.scanPacksImpl(dfsObjDatabase$PackList3);
                if (dfsObjDatabase$PackList2 != dfsObjDatabase$PackList3) continue;
                return dfsObjDatabase$PackList2;
            } while (!this.packList.compareAndSet(dfsObjDatabase$PackList3, dfsObjDatabase$PackList2));
        }
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
        return dfsObjDatabase$PackList2;
    }

    private DfsObjDatabase$PackList scanPacksImpl(DfsObjDatabase$PackList dfsObjDatabase$PackList) {
        DfsBlockCache dfsBlockCache = DfsBlockCache.getInstance();
        Map map = DfsObjDatabase.packMap(dfsObjDatabase$PackList);
        Map map2 = DfsObjDatabase.reftableMap(dfsObjDatabase$PackList);
        List list = this.listPacks();
        Collections.sort(list, this.packComparator);
        ArrayList<DfsPackFile> arrayList = new ArrayList<DfsPackFile>(list.size());
        ArrayList<DfsReftable> arrayList2 = new ArrayList<DfsReftable>(list.size());
        boolean bl2 = false;
        for (DfsPackDescription dfsPackDescription : list) {
            DfsPackFile dfsPackFile = (DfsPackFile)map.remove(dfsPackDescription);
            if (dfsPackFile != null) {
                arrayList.add(dfsPackFile);
            } else if (dfsPackDescription.hasFileExt(PackExt.PACK)) {
                arrayList.add(new DfsPackFile(dfsBlockCache, dfsPackDescription));
                bl2 = true;
            }
            DfsReftable dfsReftable = (DfsReftable)map2.remove(dfsPackDescription);
            if (dfsReftable != null) {
                arrayList2.add(dfsReftable);
                continue;
            }
            if (!dfsPackDescription.hasFileExt(PackExt.REFTABLE)) continue;
            arrayList2.add(new DfsReftable(dfsBlockCache, dfsPackDescription));
            bl2 = true;
        }
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            return new DfsObjDatabase$PackListImpl(DfsObjDatabase.NO_PACKS.packs, DfsObjDatabase.NO_PACKS.reftables);
        }
        if (!bl2) {
            dfsObjDatabase$PackList.clearDirty();
            return dfsObjDatabase$PackList;
        }
        Collections.sort(arrayList2, this.reftableComparator());
        return new DfsObjDatabase$PackListImpl(arrayList.toArray(new DfsPackFile[0]), arrayList2.toArray(new DfsReftable[0]));
    }

    private static Map packMap(DfsObjDatabase$PackList dfsObjDatabase$PackList) {
        HashMap<DfsPackDescription, DfsPackFile> hashMap = new HashMap<DfsPackDescription, DfsPackFile>();
        for (DfsPackFile dfsPackFile : dfsObjDatabase$PackList.packs) {
            if (dfsPackFile.invalid()) continue;
            hashMap.put(dfsPackFile.desc, dfsPackFile);
        }
        return hashMap;
    }

    private static Map reftableMap(DfsObjDatabase$PackList dfsObjDatabase$PackList) {
        HashMap<DfsPackDescription, DfsReftable> hashMap = new HashMap<DfsPackDescription, DfsReftable>();
        for (DfsReftable dfsReftable : dfsObjDatabase$PackList.reftables) {
            if (dfsReftable.invalid()) continue;
            hashMap.put(dfsReftable.desc, dfsReftable);
        }
        return hashMap;
    }

    protected Comparator reftableComparator() {
        return Comparator.comparing(DfsReftable::getPackDescription, DfsPackDescription.reftableComparator());
    }

    protected void clearCache() {
        this.packList.set(NO_PACKS);
    }

    @Override
    public void close() {
        this.packList.set(NO_PACKS);
    }
}

