/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter$PackStream;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter$Reader;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackParser;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;
import org.eclipse.jgit.util.io.CountingOutputStream;
import org.eclipse.jgit.util.sha1.SHA1;

public class DfsInserter
extends ObjectInserter {
    private static final int INDEX_VERSION = 2;
    final DfsObjDatabase db;
    int compression = 9;
    List objectList;
    ObjectIdOwnerMap objectMap;
    DfsBlockCache cache;
    DfsStreamKey packKey;
    DfsPackDescription packDsc;
    DfsInserter$PackStream packOut;
    private boolean rollback;
    private boolean checkExisting = true;

    protected DfsInserter(DfsObjDatabase dfsObjDatabase) {
        this.db = dfsObjDatabase;
    }

    public void checkExisting(boolean bl2) {
        this.checkExisting = bl2;
    }

    void setCompressionLevel(int n2) {
        this.compression = n2;
    }

    @Override
    public DfsPackParser newPackParser(InputStream inputStream) {
        return new DfsPackParser(this.db, this, inputStream);
    }

    @Override
    public ObjectReader newReader() {
        return new DfsInserter$Reader(this);
    }

    @Override
    public ObjectId insert(int n2, byte[] byArray, int n3, int n4) {
        ObjectId objectId = this.idFor(n2, byArray, n3, n4);
        if (this.objectMap != null && this.objectMap.contains(objectId)) {
            return objectId;
        }
        if (this.checkExisting && this.db.has(objectId, true)) {
            return objectId;
        }
        long l2 = this.beginObject(n2, n4);
        this.packOut.compress.write(byArray, n3, n4);
        this.packOut.compress.finish();
        return this.endObject(objectId, l2);
    }

    @Override
    public ObjectId insert(int n2, long l2, InputStream inputStream) {
        byte[] byArray = this.insertBuffer(l2);
        if (l2 <= (long)byArray.length) {
            IO.readFully(inputStream, byArray, 0, (int)l2);
            return this.insert(n2, byArray, 0, (int)l2);
        }
        long l3 = this.beginObject(n2, l2);
        SHA1 sHA1 = this.digest();
        sHA1.update(Constants.encodedTypeString(n2));
        sHA1.update((byte)32);
        sHA1.update(Constants.encodeASCII(l2));
        sHA1.update((byte)0);
        while (0L < l2) {
            int n3 = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, l2));
            if (n3 <= 0) {
                throw new EOFException();
            }
            sHA1.update(byArray, 0, n3);
            this.packOut.compress.write(byArray, 0, n3);
            l2 -= (long)n3;
        }
        this.packOut.compress.finish();
        return this.endObject(sHA1.toObjectId(), l3);
    }

    private byte[] insertBuffer(long l2) {
        byte[] byArray = this.buffer();
        if (l2 <= (long)byArray.length) {
            return byArray;
        }
        if (l2 < (long)this.db.getReaderOptions().getStreamFileThreshold()) {
            try {
                return new byte[(int)l2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return byArray;
            }
        }
        return byArray;
    }

    @Override
    public void flush() {
        if (this.packDsc == null) {
            return;
        }
        if (this.packOut == null) {
            throw new IOException();
        }
        byte[] byArray = this.packOut.writePackFooter();
        this.packDsc.addFileExt(PackExt.PACK);
        this.packDsc.setFileSize(PackExt.PACK, this.packOut.getCount());
        this.packOut.close();
        this.packOut = null;
        this.sortObjectsById();
        PackIndex packIndex = this.writePackIndex(this.packDsc, byArray, this.objectList);
        this.db.commitPack(Collections.singletonList(this.packDsc), null);
        this.rollback = false;
        DfsPackFile dfsPackFile = new DfsPackFile(this.cache, this.packDsc);
        if (packIndex != null) {
            dfsPackFile.setPackIndex(packIndex);
        }
        this.db.addPack(dfsPackFile);
        this.clear();
    }

    @Override
    public void close() {
        if (this.packOut != null) {
            try {
                this.packOut.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.packOut = null;
            }
        }
        if (this.rollback && this.packDsc != null) {
            try {
                this.db.rollbackPack(Collections.singletonList(this.packDsc));
            }
            finally {
                this.packDsc = null;
                this.rollback = false;
            }
        }
        this.clear();
    }

    private void clear() {
        this.objectList = null;
        this.objectMap = null;
        this.packKey = null;
        this.packDsc = null;
    }

    private long beginObject(int n2, long l2) {
        if (this.packOut == null) {
            this.beginPack();
        }
        long l3 = this.packOut.getCount();
        this.packOut.beginObject(n2, l2);
        return l3;
    }

    private ObjectId endObject(ObjectId objectId, long l2) {
        PackedObjectInfo packedObjectInfo = new PackedObjectInfo(objectId);
        packedObjectInfo.setOffset(l2);
        packedObjectInfo.setCRC((int)this.packOut.crc32.getValue());
        this.objectList.add(packedObjectInfo);
        this.objectMap.addIfAbsent(packedObjectInfo);
        return objectId;
    }

    private void beginPack() {
        this.objectList = new BlockList();
        this.objectMap = new ObjectIdOwnerMap();
        this.cache = DfsBlockCache.getInstance();
        this.rollback = true;
        this.packDsc = this.db.newPack(DfsObjDatabase$PackSource.INSERT);
        DfsOutputStream dfsOutputStream = this.db.writeFile(this.packDsc, PackExt.PACK);
        this.packDsc.setBlockSize(PackExt.PACK, dfsOutputStream.blockSize());
        this.packOut = new DfsInserter$PackStream(this, dfsOutputStream);
        this.packKey = this.packDsc.getStreamKey(PackExt.PACK);
        byte[] byArray = this.packOut.hdrBuf;
        System.arraycopy(Constants.PACK_SIGNATURE, 0, byArray, 0, 4);
        NB.encodeInt32(byArray, 4, 2);
        NB.encodeInt32(byArray, 8, 1);
        this.packOut.write(byArray, 0, 12);
    }

    private void sortObjectsById() {
        Collections.sort(this.objectList);
    }

    @Nullable
    private TemporaryBuffer$Heap maybeGetTemporaryBuffer(List list) {
        if (list.size() <= 58000) {
            return new TemporaryBuffer$Heap(0x200000);
        }
        return null;
    }

    PackIndex writePackIndex(DfsPackDescription dfsPackDescription, byte[] byArray, List list) {
        dfsPackDescription.setIndexVersion(2);
        dfsPackDescription.setObjectCount(list.size());
        PackIndex packIndex = null;
        try (TemporaryBuffer$Heap temporaryBuffer$Heap = this.maybeGetTemporaryBuffer(list);
             DfsOutputStream dfsOutputStream = this.db.writeFile(dfsPackDescription, PackExt.INDEX);
             CountingOutputStream countingOutputStream = new CountingOutputStream(dfsOutputStream);){
            if (temporaryBuffer$Heap != null) {
                DfsInserter.index(temporaryBuffer$Heap, byArray, list);
                packIndex = PackIndex.read(temporaryBuffer$Heap.openInputStream());
                temporaryBuffer$Heap.writeTo(countingOutputStream, null);
            } else {
                DfsInserter.index(countingOutputStream, byArray, list);
            }
            dfsPackDescription.addFileExt(PackExt.INDEX);
            dfsPackDescription.setBlockSize(PackExt.INDEX, dfsOutputStream.blockSize());
            dfsPackDescription.setFileSize(PackExt.INDEX, countingOutputStream.getCount());
        }
        return packIndex;
    }

    private static void index(OutputStream outputStream, byte[] byArray, List list) {
        PackIndexWriter.createVersion(outputStream, 2).write(list, byArray);
    }

    static /* synthetic */ byte[] access$100(DfsInserter dfsInserter) {
        return dfsInserter.buffer();
    }
}

