/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter$StreamLoader;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectLoader$SmallObject;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.transport.PackedObjectInfo;

class DfsInserter$Reader
extends ObjectReader {
    private final DfsReader ctx;
    final /* synthetic */ DfsInserter this$0;

    private DfsInserter$Reader(DfsInserter dfsInserter) {
        this.this$0 = dfsInserter;
        this.ctx = this.this$0.db.newReader();
    }

    @Override
    public ObjectReader newReader() {
        return this.this$0.db.newReader();
    }

    @Override
    public Collection resolve(AbbreviatedObjectId abbreviatedObjectId) {
        Collection collection = this.ctx.resolve(abbreviatedObjectId);
        if (this.this$0.objectList == null) {
            return collection;
        }
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>(collection.size() + 2);
        hashSet.addAll(collection);
        for (PackedObjectInfo packedObjectInfo : this.this$0.objectList) {
            if (abbreviatedObjectId.prefixCompare(packedObjectInfo) != 0) continue;
            hashSet.add(packedObjectInfo.copy());
        }
        return hashSet;
    }

    @Override
    public ObjectLoader open(AnyObjectId anyObjectId, int n2) {
        byte[] byArray;
        if (this.this$0.objectMap == null) {
            return this.ctx.open(anyObjectId, n2);
        }
        PackedObjectInfo packedObjectInfo = (PackedObjectInfo)this.this$0.objectMap.get(anyObjectId);
        if (packedObjectInfo == null) {
            return this.ctx.open(anyObjectId, n2);
        }
        byte[] byArray2 = DfsInserter.access$100(this.this$0);
        int n3 = this.this$0.packOut.read(packedObjectInfo.getOffset(), byArray2, 0, 20);
        if (n3 <= 0) {
            throw new EOFException(JGitText.get().unexpectedEofInPack);
        }
        int n4 = byArray2[0] & 0xFF;
        int n5 = n4 >> 4 & 7;
        if (n5 == 6 || n5 == 7) {
            throw new IOException(MessageFormat.format(JGitText.get().cannotReadBackDelta, Integer.toString(n5)));
        }
        if (n2 != -1 && n5 != n2) {
            throw new IncorrectObjectTypeException(anyObjectId.copy(), n2);
        }
        long l2 = n4 & 0xF;
        int n6 = 1;
        int n7 = 4;
        while ((n4 & 0x80) != 0) {
            if (n6 >= n3) {
                throw new EOFException(JGitText.get().unexpectedEofInPack);
            }
            n4 = byArray2[n6++] & 0xFF;
            l2 += (long)(n4 & 0x7F) << n7;
            n7 += 7;
        }
        long l3 = packedObjectInfo.getOffset() + (long)n6;
        if (l2 < (long)this.ctx.getStreamFileThreshold() && (byArray = this.inflate(packedObjectInfo, l3, (int)l2)) != null) {
            return new ObjectLoader$SmallObject(n5, byArray);
        }
        return new DfsInserter$StreamLoader(this.this$0, packedObjectInfo.copy(), n5, l2, this.this$0.packKey, l3);
    }

    private byte[] inflate(PackedObjectInfo packedObjectInfo, long l2, int n2) {
        try {
            return this.this$0.packOut.inflate(this.ctx, l2, n2);
        }
        catch (DataFormatException dataFormatException) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, packedObjectInfo.getOffset(), this.this$0.packDsc.getFileName(PackExt.PACK)), dataFormatException);
        }
    }

    @Override
    public boolean has(AnyObjectId anyObjectId) {
        return this.this$0.objectMap != null && this.this$0.objectMap.contains(anyObjectId) || this.ctx.has(anyObjectId);
    }

    @Override
    public Set getShallowCommits() {
        return this.ctx.getShallowCommits();
    }

    @Override
    public ObjectInserter getCreatedFromInserter() {
        return this.this$0;
    }

    @Override
    public void close() {
        this.ctx.close();
    }
}

