/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.lib.Constants;

class DfsInserter$PackStream
extends OutputStream {
    private final DfsOutputStream out;
    private final MessageDigest md;
    final byte[] hdrBuf;
    private final Deflater deflater;
    private final int blockSize;
    private long currPos;
    private int currPtr;
    private byte[] currBuf;
    final CRC32 crc32;
    final DeflaterOutputStream compress;
    final /* synthetic */ DfsInserter this$0;

    DfsInserter$PackStream(DfsInserter dfsInserter, DfsOutputStream dfsOutputStream) {
        this.this$0 = dfsInserter;
        this.out = dfsOutputStream;
        this.hdrBuf = new byte[32];
        this.md = Constants.newMessageDigest();
        this.crc32 = new CRC32();
        this.deflater = new Deflater(dfsInserter.compression);
        this.compress = new DeflaterOutputStream((OutputStream)this, this.deflater, 8192);
        int n2 = dfsOutputStream.blockSize();
        if (n2 <= 0) {
            n2 = dfsInserter.cache.getBlockSize();
        } else if (n2 < dfsInserter.cache.getBlockSize()) {
            n2 = dfsInserter.cache.getBlockSize() / n2 * n2;
        }
        this.blockSize = n2;
        this.currBuf = new byte[this.blockSize];
    }

    long getCount() {
        return this.currPos + (long)this.currPtr;
    }

    void beginObject(int n2, long l2) {
        this.crc32.reset();
        this.deflater.reset();
        this.write(this.hdrBuf, 0, this.encodeTypeSize(n2, l2));
    }

    private int encodeTypeSize(int n2, long l2) {
        long l3 = l2 >>> 4;
        this.hdrBuf[0] = (byte)((long)((l3 > 0L ? 128 : 0) | n2 << 4) | l2 & 0xFL);
        l2 = l3;
        int n3 = 1;
        while (l2 > 0L) {
            this.hdrBuf[n3++] = (byte)((long)((l3 >>>= 7) > 0L ? 128 : 0) | l2 & 0x7FL);
            l2 = l3;
        }
        return n3;
    }

    @Override
    public void write(int n2) {
        this.hdrBuf[0] = (byte)n2;
        this.write(this.hdrBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.crc32.update(byArray, n2, n3);
        this.md.update(byArray, n2, n3);
        this.writeNoHash(byArray, n2, n3);
    }

    private void writeNoHash(byte[] byArray, int n2, int n3) {
        while (0 < n3) {
            int n4 = Math.min(n3, this.currBuf.length - this.currPtr);
            if (n4 == 0) {
                this.flushBlock();
                this.currBuf = new byte[this.blockSize];
                continue;
            }
            System.arraycopy(byArray, n2, this.currBuf, this.currPtr, n4);
            n2 += n4;
            n3 -= n4;
            this.currPtr += n4;
        }
    }

    private void flushBlock() {
        this.out.write(this.currBuf, 0, this.currPtr);
        byte[] byArray = this.currPtr == this.currBuf.length ? this.currBuf : this.copyOf(this.currBuf, 0, this.currPtr);
        this.this$0.cache.put(new DfsBlock(this.this$0.packKey, this.currPos, byArray));
        this.currPos += (long)this.currPtr;
        this.currPtr = 0;
        this.currBuf = null;
    }

    private byte[] copyOf(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    byte[] writePackFooter() {
        byte[] byArray = this.md.digest();
        this.writeNoHash(byArray, 0, byArray.length);
        if (this.currPtr != 0) {
            this.flushBlock();
        }
        return byArray;
    }

    int read(long l2, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        for (n4 = 0; l2 < this.currPos && n4 < n3; l2 += (long)n5, n4 += n5) {
            DfsBlock dfsBlock = this.getOrLoadBlock(l2);
            n5 = dfsBlock.copy(l2, byArray, n2 + n4, n3 - n4);
        }
        if (this.currPos <= l2 && n4 < n3) {
            int n6 = (int)(l2 - this.currPos);
            n5 = Math.min(this.currPtr - n6, n3 - n4);
            System.arraycopy(this.currBuf, n6, byArray, n2 + n4, n5);
            n4 += n5;
        }
        return n4;
    }

    byte[] inflate(DfsReader dfsReader, long l2, int n2) {
        byte[] byArray;
        try {
            byArray = new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
        Inflater inflater = dfsReader.inflater();
        l2 += (long)this.setInput(l2, inflater);
        int n3 = 0;
        while (true) {
            int n4 = inflater.inflate(byArray, n3, byArray.length - n3);
            n3 += n4;
            if (inflater.finished()) {
                return byArray;
            }
            if (inflater.needsInput()) {
                l2 += (long)this.setInput(l2, inflater);
                continue;
            }
            if (n4 == 0) break;
        }
        throw new DataFormatException();
    }

    private int setInput(long l2, Inflater inflater) {
        if (l2 < this.currPos) {
            return this.getOrLoadBlock(l2).setInput(l2, inflater);
        }
        if (l2 < this.currPos + (long)this.currPtr) {
            int n2 = (int)(l2 - this.currPos);
            int n3 = this.currPtr - n2;
            inflater.setInput(this.currBuf, n2, n3);
            return n3;
        }
        throw new EOFException(JGitText.get().unexpectedEofInPack);
    }

    private DfsBlock getOrLoadBlock(long l2) {
        int n2;
        long l3 = this.toBlockStart(l2);
        DfsBlock dfsBlock = (DfsBlock)this.this$0.cache.get(this.this$0.packKey, l3);
        if (dfsBlock != null) {
            return dfsBlock;
        }
        byte[] byArray = new byte[this.blockSize];
        for (int i2 = 0; i2 < this.blockSize; i2 += n2) {
            n2 = this.out.read(l3 + (long)i2, ByteBuffer.wrap(byArray, i2, this.blockSize - i2));
            if (n2 > 0) continue;
            throw new EOFException(JGitText.get().unexpectedEofInPack);
        }
        dfsBlock = new DfsBlock(this.this$0.packKey, l3, byArray);
        this.this$0.cache.put(dfsBlock);
        return dfsBlock;
    }

    private long toBlockStart(long l2) {
        return l2 / (long)this.blockSize * (long)this.blockSize;
    }

    @Override
    public void close() {
        this.deflater.end();
        this.out.close();
    }
}

