/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackCompactor;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableStack;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex$MutableEntry;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsGarbageCollector {
    private final DfsRepository repo;
    private final RefDatabase refdb;
    private final DfsObjDatabase objdb;
    private final List newPackDesc;
    private final List newPackStats;
    private final List newPackObj;
    private DfsReader ctx;
    private PackConfig packConfig;
    private ReftableConfig reftableConfig;
    private boolean convertToReftable = true;
    private boolean includeDeletes;
    private long reftableInitialMinUpdateIndex = 1L;
    private long reftableInitialMaxUpdateIndex = 1L;
    private long coalesceGarbageLimit = 0x3200000L;
    private long garbageTtlMillis = TimeUnit.DAYS.toMillis(1L);
    private long startTimeMillis;
    private List packsBefore;
    private List reftablesBefore;
    private List expiredGarbagePacks;
    private Collection refsBefore;
    private Set allHeadsAndTags;
    private Set allTags;
    private Set nonHeads;
    private Set tagTargets;

    public DfsGarbageCollector(DfsRepository dfsRepository) {
        this.repo = dfsRepository;
        this.refdb = this.repo.getRefDatabase();
        this.objdb = this.repo.getObjectDatabase();
        this.newPackDesc = new ArrayList(4);
        this.newPackStats = new ArrayList(4);
        this.newPackObj = new ArrayList(4);
        this.packConfig = new PackConfig(this.repo);
        this.packConfig.setIndexVersion(2);
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public DfsGarbageCollector setPackConfig(PackConfig packConfig) {
        this.packConfig = packConfig;
        return this;
    }

    public DfsGarbageCollector setReftableConfig(ReftableConfig reftableConfig) {
        this.reftableConfig = reftableConfig;
        return this;
    }

    public DfsGarbageCollector setConvertToReftable(boolean bl2) {
        this.convertToReftable = bl2;
        return this;
    }

    public DfsGarbageCollector setIncludeDeletes(boolean bl2) {
        this.includeDeletes = bl2;
        return this;
    }

    public DfsGarbageCollector setReftableInitialMinUpdateIndex(long l2) {
        this.reftableInitialMinUpdateIndex = Math.max(l2, 0L);
        return this;
    }

    public DfsGarbageCollector setReftableInitialMaxUpdateIndex(long l2) {
        this.reftableInitialMaxUpdateIndex = Math.max(0L, l2);
        return this;
    }

    public long getCoalesceGarbageLimit() {
        return this.coalesceGarbageLimit;
    }

    public DfsGarbageCollector setCoalesceGarbageLimit(long l2) {
        this.coalesceGarbageLimit = l2;
        return this;
    }

    public long getGarbageTtlMillis() {
        return this.garbageTtlMillis;
    }

    public DfsGarbageCollector setGarbageTtl(long l2, TimeUnit timeUnit) {
        this.garbageTtlMillis = timeUnit.toMillis(l2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pack(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (this.packConfig.getIndexVersion() != 2) {
            throw new IllegalStateException(JGitText.get().supportOnlyPackIndexVersion2);
        }
        this.startTimeMillis = SystemReader.getInstance().getCurrentTime();
        this.ctx = this.objdb.newReader();
        try {
            this.refdb.refresh();
            this.objdb.clearCache();
            this.refsBefore = this.getAllRefs();
            this.readPacksBefore();
            this.readReftablesBefore();
            HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
            this.allHeadsAndTags = new HashSet();
            this.allTags = new HashSet();
            this.nonHeads = new HashSet();
            this.tagTargets = new HashSet();
            for (Ref ref : this.refsBefore) {
                if (ref.isSymbolic() || ref.getObjectId() == null) continue;
                if (DfsGarbageCollector.isHead(ref)) {
                    hashSet.add(ref.getObjectId());
                } else if (DfsGarbageCollector.isTag(ref)) {
                    this.allTags.add(ref.getObjectId());
                } else {
                    this.nonHeads.add(ref.getObjectId());
                }
                if (ref.getPeeledObjectId() == null) continue;
                this.tagTargets.add(ref.getPeeledObjectId());
            }
            this.allTags.removeAll(hashSet);
            this.allHeadsAndTags.addAll(hashSet);
            this.allHeadsAndTags.addAll(this.allTags);
            this.tagTargets.addAll(this.allHeadsAndTags);
            if (this.packConfig.getSinglePack()) {
                this.allHeadsAndTags.addAll(this.nonHeads);
                this.nonHeads.clear();
            }
            boolean bl2 = true;
            try {
                this.packHeads(progressMonitor);
                this.packRest(progressMonitor);
                this.packGarbage(progressMonitor);
                this.objdb.commitPack(this.newPackDesc, this.toPrune());
                bl2 = false;
                boolean bl3 = true;
                if (bl2) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                return bl3;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                throw throwable;
            }
        }
        finally {
            this.ctx.close();
        }
    }

    private Collection getAllRefs() {
        List list = this.refdb.getRefs();
        List list2 = this.refdb.getAdditionalRefs();
        if (!list2.isEmpty()) {
            ArrayList<Ref> arrayList = new ArrayList<Ref>(list.size() + list2.size());
            arrayList.addAll(list);
            for (Ref ref : list2) {
                if (!ref.getName().startsWith("refs/")) continue;
                arrayList.add(ref);
            }
            return arrayList;
        }
        return list;
    }

    private void readPacksBefore() {
        DfsPackFile[] dfsPackFileArray = this.objdb.getPacks();
        this.packsBefore = new ArrayList(dfsPackFileArray.length);
        this.expiredGarbagePacks = new ArrayList(dfsPackFileArray.length);
        long l2 = SystemReader.getInstance().getCurrentTime();
        for (DfsPackFile dfsPackFile : dfsPackFileArray) {
            DfsPackDescription dfsPackDescription = dfsPackFile.getPackDescription();
            if (dfsPackDescription.getPackSource() != DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE) {
                this.packsBefore.add(dfsPackFile);
                continue;
            }
            if (this.packIsExpiredGarbage(dfsPackDescription, l2)) {
                this.expiredGarbagePacks.add(dfsPackFile);
                continue;
            }
            if (!this.packIsCoalesceableGarbage(dfsPackDescription, l2)) continue;
            this.packsBefore.add(dfsPackFile);
        }
    }

    private void readReftablesBefore() {
        DfsReftable[] dfsReftableArray = this.objdb.getReftables();
        this.reftablesBefore = new ArrayList<DfsReftable>(Arrays.asList(dfsReftableArray));
    }

    private boolean packIsExpiredGarbage(DfsPackDescription dfsPackDescription, long l2) {
        return dfsPackDescription.getPackSource() == DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE && this.garbageTtlMillis > 0L && l2 - dfsPackDescription.getLastModified() >= this.garbageTtlMillis;
    }

    private boolean packIsCoalesceableGarbage(DfsPackDescription dfsPackDescription, long l2) {
        long l3;
        if (dfsPackDescription.getPackSource() != DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE || dfsPackDescription.getFileSize(PackExt.PACK) >= this.coalesceGarbageLimit) {
            return false;
        }
        if (this.garbageTtlMillis == 0L) {
            return true;
        }
        long l4 = dfsPackDescription.getLastModified();
        long l5 = DfsGarbageCollector.dayStartInMillis(l4);
        if (l5 != (l3 = DfsGarbageCollector.dayStartInMillis(l2))) {
            return false;
        }
        if (this.garbageTtlMillis > TimeUnit.DAYS.toMillis(1L)) {
            return true;
        }
        long l6 = this.garbageTtlMillis / 3L;
        if (l6 == 0L) {
            return false;
        }
        long l7 = (l4 - l5) / l6;
        long l8 = (l2 - l3) / l6;
        return l7 == l8;
    }

    private static long dayStartInMillis(long l2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(SystemReader.getInstance().getTimeZone());
        gregorianCalendar.setTimeInMillis(l2);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    public Set getSourcePacks() {
        return this.toPrune();
    }

    public List getNewPacks() {
        return this.newPackDesc;
    }

    public List getNewPackStatistics() {
        return this.newPackStats;
    }

    private Set toPrune() {
        HashSet<DfsPackDescription> hashSet = new HashSet<DfsPackDescription>();
        for (BlockBasedFile blockBasedFile : this.packsBefore) {
            hashSet.add(((DfsPackFile)blockBasedFile).getPackDescription());
        }
        if (this.reftableConfig != null) {
            for (BlockBasedFile blockBasedFile : this.reftablesBefore) {
                hashSet.add(((DfsReftable)blockBasedFile).getPackDescription());
            }
        }
        for (BlockBasedFile blockBasedFile : this.expiredGarbagePacks) {
            hashSet.add(((DfsPackFile)blockBasedFile).getPackDescription());
        }
        return hashSet;
    }

    private void packHeads(ProgressMonitor progressMonitor) {
        if (this.allHeadsAndTags.isEmpty()) {
            this.writeReftable();
            return;
        }
        try (PackWriter packWriter = this.newPackWriter();){
            packWriter.setTagTargets(this.tagTargets);
            packWriter.preparePack(progressMonitor, this.allHeadsAndTags, PackWriter.NONE, PackWriter.NONE, this.allTags);
            if (0L < packWriter.getObjectCount()) {
                long l2 = this.estimateGcPackSize(DfsObjDatabase$PackSource.INSERT, DfsObjDatabase$PackSource.RECEIVE, DfsObjDatabase$PackSource.COMPACT, DfsObjDatabase$PackSource.GC);
                this.writePack(DfsObjDatabase$PackSource.GC, packWriter, progressMonitor, l2);
            } else {
                this.writeReftable();
            }
        }
    }

    private void packRest(ProgressMonitor progressMonitor) {
        if (this.nonHeads.isEmpty()) {
            return;
        }
        try (PackWriter packWriter = this.newPackWriter();){
            for (ObjectIdSet objectIdSet : this.newPackObj) {
                packWriter.excludeObjects(objectIdSet);
            }
            packWriter.preparePack(progressMonitor, this.nonHeads, this.allHeadsAndTags);
            if (0L < packWriter.getObjectCount()) {
                this.writePack(DfsObjDatabase$PackSource.GC_REST, packWriter, progressMonitor, this.estimateGcPackSize(DfsObjDatabase$PackSource.INSERT, DfsObjDatabase$PackSource.RECEIVE, DfsObjDatabase$PackSource.COMPACT, DfsObjDatabase$PackSource.GC_REST));
            }
        }
    }

    private void packGarbage(ProgressMonitor progressMonitor) {
        PackConfig packConfig = new PackConfig(this.packConfig);
        packConfig.setReuseDeltas(true);
        packConfig.setReuseObjects(true);
        packConfig.setDeltaCompress(false);
        packConfig.setBuildBitmaps(false);
        try (PackWriter packWriter = new PackWriter(packConfig, (ObjectReader)this.ctx);
             RevWalk revWalk = new RevWalk(this.ctx);){
            packWriter.setDeltaBaseAsOffset(true);
            packWriter.setReuseDeltaCommits(true);
            progressMonitor.beginTask(JGitText.get().findingGarbage, this.objectsBefore());
            long l2 = 32L;
            for (DfsPackFile dfsPackFile : this.packsBefore) {
                PackIndex packIndex = dfsPackFile.getPackIndex(this.ctx);
                PackReverseIndex packReverseIndex = dfsPackFile.getReverseIdx(this.ctx);
                long l3 = dfsPackFile.getPackDescription().getFileSize(PackExt.PACK) - 20L;
                for (PackIndex$MutableEntry packIndex$MutableEntry : packIndex) {
                    progressMonitor.update(1);
                    ObjectId objectId = packIndex$MutableEntry.toObjectId();
                    if (revWalk.lookupOrNull(objectId) != null || this.anyPackHas(objectId)) continue;
                    long l4 = packIndex$MutableEntry.getOffset();
                    int n2 = dfsPackFile.getObjectType(this.ctx, l4);
                    packWriter.addObject(revWalk.lookupAny(objectId, n2));
                    long l5 = packReverseIndex.findNextOffset(l4, l3) - l4;
                    l2 += l5;
                }
            }
            progressMonitor.endTask();
            if (0L < packWriter.getObjectCount()) {
                this.writePack(DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE, packWriter, progressMonitor, l2);
            }
        }
    }

    private boolean anyPackHas(AnyObjectId anyObjectId) {
        for (ObjectIdSet objectIdSet : this.newPackObj) {
            if (!objectIdSet.contains(anyObjectId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private static boolean isTag(Ref ref) {
        return ref.getName().startsWith("refs/tags/");
    }

    private int objectsBefore() {
        int n2 = 0;
        for (DfsPackFile dfsPackFile : this.packsBefore) {
            n2 += (int)dfsPackFile.getPackDescription().getObjectCount();
        }
        return n2;
    }

    private PackWriter newPackWriter() {
        PackWriter packWriter = new PackWriter(this.packConfig, (ObjectReader)this.ctx);
        packWriter.setDeltaBaseAsOffset(true);
        packWriter.setReuseDeltaCommits(false);
        return packWriter;
    }

    private long estimateGcPackSize(DfsObjDatabase$PackSource dfsObjDatabase$PackSource, DfsObjDatabase$PackSource ... dfsObjDatabase$PackSourceArray) {
        EnumSet<DfsObjDatabase$PackSource[]> enumSet = EnumSet.of(dfsObjDatabase$PackSource, dfsObjDatabase$PackSourceArray);
        long l2 = 32L;
        for (DfsPackDescription dfsPackDescription : this.getSourcePacks()) {
            if (!enumSet.contains((Object)dfsPackDescription.getPackSource())) continue;
            l2 += dfsPackDescription.getFileSize(PackExt.PACK) - 32L;
        }
        return l2;
    }

    private DfsPackDescription writePack(DfsObjDatabase$PackSource dfsObjDatabase$PackSource, PackWriter packWriter, ProgressMonitor progressMonitor, long l2) {
        CountingOutputStream countingOutputStream;
        DfsPackDescription dfsPackDescription = this.repo.getObjectDatabase().newPack(dfsObjDatabase$PackSource, l2);
        if (dfsObjDatabase$PackSource == DfsObjDatabase$PackSource.GC && this.reftableConfig != null) {
            this.writeReftable(dfsPackDescription);
        }
        try (Object object = this.objdb.writeFile(dfsPackDescription, PackExt.PACK);){
            packWriter.writePack(progressMonitor, progressMonitor, (OutputStream)object);
            dfsPackDescription.addFileExt(PackExt.PACK);
            dfsPackDescription.setBlockSize(PackExt.PACK, ((DfsOutputStream)object).blockSize());
        }
        object = this.objdb.writeFile(dfsPackDescription, PackExt.INDEX);
        var8_7 = null;
        try {
            countingOutputStream = new CountingOutputStream((OutputStream)object);
            packWriter.writeIndex(countingOutputStream);
            dfsPackDescription.addFileExt(PackExt.INDEX);
            dfsPackDescription.setFileSize(PackExt.INDEX, countingOutputStream.getCount());
            dfsPackDescription.setBlockSize(PackExt.INDEX, ((DfsOutputStream)object).blockSize());
            dfsPackDescription.setIndexVersion(packWriter.getIndexVersion());
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (var8_7 != null) {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)object).close();
                }
            }
        }
        if (packWriter.prepareBitmapIndex(progressMonitor)) {
            object = this.objdb.writeFile(dfsPackDescription, PackExt.BITMAP_INDEX);
            var8_7 = null;
            try {
                countingOutputStream = new CountingOutputStream((OutputStream)object);
                packWriter.writeBitmapIndex(countingOutputStream);
                dfsPackDescription.addFileExt(PackExt.BITMAP_INDEX);
                dfsPackDescription.setFileSize(PackExt.BITMAP_INDEX, countingOutputStream.getCount());
                dfsPackDescription.setBlockSize(PackExt.BITMAP_INDEX, ((DfsOutputStream)object).blockSize());
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (var8_7 != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            var8_7.addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object).close();
                    }
                }
            }
        }
        object = packWriter.getStatistics();
        dfsPackDescription.setPackStats((PackStatistics)object);
        dfsPackDescription.setLastModified(this.startTimeMillis);
        this.newPackDesc.add(dfsPackDescription);
        this.newPackStats.add(object);
        this.newPackObj.add(packWriter.getObjectSet());
        return dfsPackDescription;
    }

    private void writeReftable() {
        if (this.reftableConfig != null) {
            DfsPackDescription dfsPackDescription = this.objdb.newPack(DfsObjDatabase$PackSource.GC);
            this.newPackDesc.add(dfsPackDescription);
            this.newPackStats.add(null);
            this.writeReftable(dfsPackDescription);
        }
    }

    private void writeReftable(DfsPackDescription dfsPackDescription) {
        if (this.convertToReftable && !this.hasGcReftable()) {
            this.writeReftable(dfsPackDescription, this.refsBefore);
            return;
        }
        try (DfsReftableStack dfsReftableStack = DfsReftableStack.open(this.ctx, this.reftablesBefore);
             DfsOutputStream dfsOutputStream = this.objdb.writeFile(dfsPackDescription, PackExt.REFTABLE);){
            ReftableCompactor reftableCompactor = new ReftableCompactor(dfsOutputStream);
            reftableCompactor.addAll(dfsReftableStack.readers());
            reftableCompactor.setIncludeDeletes(this.includeDeletes);
            reftableCompactor.setConfig(DfsPackCompactor.configureReftable(this.reftableConfig, dfsOutputStream));
            reftableCompactor.compact();
            dfsPackDescription.addFileExt(PackExt.REFTABLE);
            dfsPackDescription.setReftableStats(reftableCompactor.getStats());
        }
    }

    private boolean hasGcReftable() {
        for (DfsReftable dfsReftable : this.reftablesBefore) {
            if (dfsReftable.getPackDescription().getPackSource() != DfsObjDatabase$PackSource.GC) continue;
            return true;
        }
        return false;
    }

    private void writeReftable(DfsPackDescription dfsPackDescription, Collection collection) {
        try (DfsOutputStream dfsOutputStream = this.objdb.writeFile(dfsPackDescription, PackExt.REFTABLE);){
            ReftableConfig reftableConfig = DfsPackCompactor.configureReftable(this.reftableConfig, dfsOutputStream);
            ReftableWriter reftableWriter = new ReftableWriter(reftableConfig, dfsOutputStream).setMinUpdateIndex(this.reftableInitialMinUpdateIndex).setMaxUpdateIndex(this.reftableInitialMaxUpdateIndex).begin().sortAndWriteRefs(collection).finish();
            dfsPackDescription.addFileExt(PackExt.REFTABLE);
            dfsPackDescription.setReftableStats(reftableWriter.getStats());
        }
    }
}

