/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.errors.CorruptPackIndexException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.fsck.FsckError;
import org.eclipse.jgit.internal.fsck.FsckError$CorruptIndex;
import org.eclipse.jgit.internal.fsck.FsckError$CorruptObject;
import org.eclipse.jgit.internal.fsck.FsckPackParser;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase$PackSource;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator$SubmoduleValidationException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.GitmoduleEntry;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;

public class DfsFsck {
    private final DfsRepository repo;
    private final DfsObjDatabase objdb;
    private ObjectChecker objChecker = new ObjectChecker();
    private boolean connectivityOnly;

    public DfsFsck(DfsRepository dfsRepository) {
        this.repo = dfsRepository;
        this.objdb = this.repo.getObjectDatabase();
    }

    public FsckError check(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        FsckError fsckError = new FsckError();
        if (!this.connectivityOnly) {
            this.objChecker.reset();
            this.checkPacks(progressMonitor, fsckError);
        }
        this.checkConnectivity(progressMonitor, fsckError);
        return fsckError;
    }

    private void checkPacks(ProgressMonitor progressMonitor, FsckError fsckError) {
        try (DfsReader dfsReader = this.objdb.newReader();){
            for (DfsPackFile dfsPackFile : this.objdb.getPacks()) {
                DfsPackDescription dfsPackDescription = dfsPackFile.getPackDescription();
                if (dfsPackDescription.getPackSource() == DfsObjDatabase$PackSource.UNREACHABLE_GARBAGE) continue;
                try (ReadableChannel readableChannel = this.objdb.openFile(dfsPackDescription, PackExt.PACK);){
                    this.verifyPack(progressMonitor, fsckError, dfsReader, dfsPackFile, readableChannel);
                }
                catch (MissingObjectException missingObjectException) {
                    fsckError.getMissingObjects().add(missingObjectException.getObjectId());
                }
                catch (CorruptPackIndexException corruptPackIndexException) {
                    fsckError.getCorruptIndices().add(new FsckError$CorruptIndex(dfsPackFile.getPackDescription().getFileName(PackExt.INDEX), corruptPackIndexException.getErrorType()));
                }
            }
        }
        this.checkGitModules(progressMonitor, fsckError);
    }

    private void verifyPack(ProgressMonitor progressMonitor, FsckError fsckError, DfsReader dfsReader, DfsPackFile dfsPackFile, ReadableChannel readableChannel) {
        FsckPackParser fsckPackParser = new FsckPackParser((ObjectDatabase)this.objdb, readableChannel);
        fsckPackParser.setObjectChecker(this.objChecker);
        fsckPackParser.overwriteObjectCount(dfsPackFile.getPackDescription().getObjectCount());
        fsckPackParser.parse(progressMonitor);
        fsckError.getCorruptObjects().addAll(fsckPackParser.getCorruptObjects());
        fsckPackParser.verifyIndex(dfsPackFile.getPackIndex(dfsReader));
    }

    private void checkGitModules(ProgressMonitor progressMonitor, FsckError fsckError) {
        progressMonitor.beginTask(JGitText.get().validatingGitModules, this.objChecker.getGitsubmodules().size());
        for (GitmoduleEntry gitmoduleEntry : this.objChecker.getGitsubmodules()) {
            AnyObjectId anyObjectId = gitmoduleEntry.getBlobId();
            ObjectLoader objectLoader = this.objdb.open(anyObjectId, 3);
            try {
                SubmoduleValidator.assertValidGitModulesFile(new String(objectLoader.getBytes(), StandardCharsets.UTF_8));
            }
            catch (SubmoduleValidator$SubmoduleValidationException submoduleValidator$SubmoduleValidationException) {
                FsckError$CorruptObject fsckError$CorruptObject = new FsckError$CorruptObject(anyObjectId.toObjectId(), 3, submoduleValidator$SubmoduleValidationException.getFsckMessageId());
                fsckError.getCorruptObjects().add(fsckError$CorruptObject);
            }
            progressMonitor.update(1);
        }
        progressMonitor.endTask();
    }

    private void checkConnectivity(ProgressMonitor progressMonitor, FsckError fsckError) {
        progressMonitor.beginTask(JGitText.get().countingObjects, 0);
        try (ObjectWalk objectWalk = new ObjectWalk(this.repo);){
            for (Ref ref : this.repo.getRefDatabase().getRefs()) {
                ObjectId objectId = ref.getObjectId();
                if (objectId == null) continue;
                try {
                    RevObject revObject = objectWalk.parseAny(objectId);
                    if (ref.getLeaf().getName().startsWith("refs/heads/") && revObject.getType() != 1) {
                        fsckError.getNonCommitHeads().add(ref.getLeaf().getName());
                    }
                    objectWalk.markStart(revObject);
                }
                catch (MissingObjectException missingObjectException) {
                    fsckError.getMissingObjects().add(missingObjectException.getObjectId());
                }
            }
            try {
                objectWalk.checkConnectivity();
            }
            catch (MissingObjectException missingObjectException) {
                fsckError.getMissingObjects().add(missingObjectException.getObjectId());
            }
        }
        progressMonitor.endTask();
    }

    public void setObjectChecker(ObjectChecker objectChecker) {
        this.objChecker = objectChecker;
    }

    public void setConnectivityOnly(boolean bl2) {
        this.connectivityOnly = bl2;
    }
}

