/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;

public class DfsCachedPack
extends CachedPack {
    private final DfsPackFile pack;

    DfsCachedPack(DfsPackFile dfsPackFile) {
        this.pack = dfsPackFile;
    }

    public DfsPackFile getPackFile() {
        return this.pack;
    }

    public DfsPackDescription getPackDescription() {
        return this.pack.getPackDescription();
    }

    @Override
    public long getObjectCount() {
        return this.getPackDescription().getObjectCount();
    }

    @Override
    public long getDeltaCount() {
        return this.getPackDescription().getDeltaCount();
    }

    @Override
    public boolean hasObject(ObjectToPack objectToPack, StoredObjectRepresentation storedObjectRepresentation) {
        return ((DfsObjectRepresentation)storedObjectRepresentation).pack == this.pack;
    }

    void copyAsIs(PackOutputStream packOutputStream, DfsReader dfsReader) {
        this.pack.copyPackAsIs(packOutputStream, dfsReader);
    }
}

