/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.text.MessageFormat;
import java.util.function.Consumer;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;

public class DfsBlockCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private long blockLimit;
    private int blockSize;
    private double streamRatio;
    private int concurrencyLevel;
    private Consumer refLock;

    public DfsBlockCacheConfig() {
        this.setBlockLimit(0x2000000L);
        this.setBlockSize(65536);
        this.setStreamRatio(0.3);
        this.setConcurrencyLevel(32);
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public DfsBlockCacheConfig setBlockLimit(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotPositive, l2));
        }
        this.blockLimit = l2;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DfsBlockCacheConfig setBlockSize(int n2) {
        int n3 = Math.max(512, n2);
        if ((n3 & n3 - 1) != 0) {
            throw new IllegalArgumentException(JGitText.get().blockSizeNotPowerOf2);
        }
        this.blockSize = n3;
        return this;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public DfsBlockCacheConfig setConcurrencyLevel(int n2) {
        this.concurrencyLevel = n2;
        return this;
    }

    public double getStreamRatio() {
        return this.streamRatio;
    }

    public DfsBlockCacheConfig setStreamRatio(double d2) {
        this.streamRatio = Math.max(0.0, Math.min(d2, 1.0));
        return this;
    }

    public Consumer getRefLockWaitTimeConsumer() {
        return this.refLock;
    }

    public DfsBlockCacheConfig setRefLockWaitTimeConsumer(Consumer consumer) {
        this.refLock = consumer;
        return this;
    }

    public DfsBlockCacheConfig fromConfig(Config config) {
        int n2;
        long l2 = config.getLong("core", "dfs", "blockLimit", this.getBlockLimit());
        if (l2 % (long)(n2 = config.getInt("core", "dfs", "blockSize", this.getBlockSize())) != 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotMultipleOfBlockSize, l2, n2));
        }
        this.setBlockLimit(l2);
        this.setBlockSize(n2);
        this.setConcurrencyLevel(config.getInt("core", "dfs", "concurrencyLevel", this.getConcurrencyLevel()));
        String string = config.getString("core", "dfs", "streamRatio");
        if (string != null) {
            try {
                this.setStreamRatio(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, "core", "dfs", "streamRatio", string), numberFormatException);
            }
        }
        return this;
    }
}

