/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache$HashEntry;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache$ReadableChannelSupplier;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache$Ref;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache$RefLoader;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheConfig;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public final class DfsBlockCache {
    private static volatile DfsBlockCache cache;
    private final int tableSize;
    private final AtomicReferenceArray table;
    private final ReentrantLock[] loadLocks;
    private final ReentrantLock[] refLocks;
    private final long maxBytes;
    private final long maxStreamThroughCache;
    private final int blockSize;
    private final int blockSizeShift;
    private final AtomicReference statHit;
    private final AtomicReference statMiss;
    private final AtomicReference statEvict;
    private final AtomicReference liveBytes;
    private final ReentrantLock clockLock;
    private final Consumer refLockWaitTime;
    private DfsBlockCache$Ref clockHand;

    public static void reconfigure(DfsBlockCacheConfig dfsBlockCacheConfig) {
        cache = new DfsBlockCache(dfsBlockCacheConfig);
    }

    public static DfsBlockCache getInstance() {
        return cache;
    }

    private DfsBlockCache(DfsBlockCacheConfig dfsBlockCacheConfig) {
        int n2;
        this.tableSize = DfsBlockCache.tableSize(dfsBlockCacheConfig);
        if (this.tableSize < 1) {
            throw new IllegalArgumentException(JGitText.get().tSizeMustBeGreaterOrEqual1);
        }
        this.table = new AtomicReferenceArray(this.tableSize);
        this.loadLocks = new ReentrantLock[dfsBlockCacheConfig.getConcurrencyLevel()];
        for (n2 = 0; n2 < this.loadLocks.length; ++n2) {
            this.loadLocks[n2] = new ReentrantLock(true);
        }
        this.refLocks = new ReentrantLock[dfsBlockCacheConfig.getConcurrencyLevel()];
        for (n2 = 0; n2 < this.refLocks.length; ++n2) {
            this.refLocks[n2] = new ReentrantLock(true);
        }
        this.maxBytes = dfsBlockCacheConfig.getBlockLimit();
        this.maxStreamThroughCache = (long)((double)this.maxBytes * dfsBlockCacheConfig.getStreamRatio());
        this.blockSize = dfsBlockCacheConfig.getBlockSize();
        this.blockSizeShift = Integer.numberOfTrailingZeros(this.blockSize);
        this.clockLock = new ReentrantLock(true);
        String string = "";
        this.clockHand.next = this.clockHand = new DfsBlockCache$Ref(DfsStreamKey.of(new DfsRepositoryDescription(string), string, null), -1L, 0L, null);
        this.statHit = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.statMiss = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.statEvict = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.liveBytes = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.refLockWaitTime = dfsBlockCacheConfig.getRefLockWaitTimeConsumer();
    }

    boolean shouldCopyThroughCache(long l2) {
        return l2 <= this.maxStreamThroughCache;
    }

    public long[] getCurrentSize() {
        return DfsBlockCache.getStatVals(this.liveBytes);
    }

    public long getFillPercentage() {
        return LongStream.of(this.getCurrentSize()).sum() * 100L / this.maxBytes;
    }

    public long[] getHitCount() {
        return DfsBlockCache.getStatVals(this.statHit);
    }

    public long[] getMissCount() {
        return DfsBlockCache.getStatVals(this.statMiss);
    }

    public long[] getTotalRequestCount() {
        int n2;
        AtomicLong[] atomicLongArray = (AtomicLong[])this.statHit.get();
        AtomicLong[] atomicLongArray2 = (AtomicLong[])this.statMiss.get();
        long[] lArray = new long[Math.max(atomicLongArray.length, atomicLongArray2.length)];
        for (n2 = 0; n2 < atomicLongArray.length; ++n2) {
            int n3 = n2;
            lArray[n3] = lArray[n3] + atomicLongArray[n2].get();
        }
        for (n2 = 0; n2 < atomicLongArray2.length; ++n2) {
            int n4 = n2;
            lArray[n4] = lArray[n4] + atomicLongArray2[n2].get();
        }
        return lArray;
    }

    public long[] getHitRatio() {
        AtomicLong[] atomicLongArray = (AtomicLong[])this.statHit.get();
        AtomicLong[] atomicLongArray2 = (AtomicLong[])this.statMiss.get();
        long[] lArray = new long[Math.max(atomicLongArray.length, atomicLongArray2.length)];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l2;
            long l3;
            long l4;
            lArray[i2] = i2 >= atomicLongArray.length ? 0L : (i2 >= atomicLongArray2.length ? 100L : ((l4 = (l3 = atomicLongArray[i2].get()) + (l2 = atomicLongArray2[i2].get())) == 0L ? 0L : l3 * 100L / l4));
        }
        return lArray;
    }

    public long[] getEvictions() {
        return DfsBlockCache.getStatVals(this.statEvict);
    }

    public boolean hasBlock0(DfsStreamKey dfsStreamKey) {
        DfsBlockCache$HashEntry dfsBlockCache$HashEntry = (DfsBlockCache$HashEntry)this.table.get(this.slot(dfsStreamKey, 0L));
        DfsBlock dfsBlock = (DfsBlock)this.scan(dfsBlockCache$HashEntry, dfsStreamKey, 0L);
        return dfsBlock != null && dfsBlock.contains(dfsStreamKey, 0L);
    }

    private int hash(int n2, long l2) {
        return n2 + (int)(l2 >>> this.blockSizeShift);
    }

    int getBlockSize() {
        return this.blockSize;
    }

    private static int tableSize(DfsBlockCacheConfig dfsBlockCacheConfig) {
        int n2 = dfsBlockCacheConfig.getBlockSize();
        long l2 = dfsBlockCacheConfig.getBlockLimit();
        if (n2 <= 0) {
            throw new IllegalArgumentException(JGitText.get().invalidWindowSize);
        }
        if (l2 < (long)n2) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBeLesserThanLimit);
        }
        return (int)Math.min(5L * (l2 / (long)n2) / 2L, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsBlock getOrLoad(BlockBasedFile blockBasedFile, long l2, DfsReader dfsReader, DfsBlockCache$ReadableChannelSupplier dfsBlockCache$ReadableChannelSupplier) {
        long l3 = l2;
        DfsStreamKey dfsStreamKey = blockBasedFile.key;
        int n2 = this.slot(dfsStreamKey, l2 = blockBasedFile.alignToBlock(l2));
        DfsBlockCache$HashEntry dfsBlockCache$HashEntry = (DfsBlockCache$HashEntry)this.table.get(n2);
        DfsBlock dfsBlock = (DfsBlock)this.scan(dfsBlockCache$HashEntry, dfsStreamKey, l2);
        if (dfsBlock != null && dfsBlock.contains(dfsStreamKey, l3)) {
            ++dfsReader.stats.blockCacheHit;
            DfsBlockCache.getStat(this.statHit, dfsStreamKey).incrementAndGet();
            return dfsBlock;
        }
        this.reserveSpace(this.blockSize, dfsStreamKey);
        ReentrantLock reentrantLock = this.lockFor(dfsStreamKey, l2);
        reentrantLock.lock();
        try {
            DfsBlockCache$HashEntry dfsBlockCache$HashEntry2;
            DfsBlockCache$HashEntry dfsBlockCache$HashEntry3 = (DfsBlockCache$HashEntry)this.table.get(n2);
            if (dfsBlockCache$HashEntry3 != dfsBlockCache$HashEntry && (dfsBlock = (DfsBlock)this.scan(dfsBlockCache$HashEntry3, dfsStreamKey, l2)) != null) {
                ++dfsReader.stats.blockCacheHit;
                DfsBlockCache.getStat(this.statHit, dfsStreamKey).incrementAndGet();
                this.creditSpace(this.blockSize, dfsStreamKey);
                DfsBlock dfsBlock2 = dfsBlock;
                return dfsBlock2;
            }
            DfsBlockCache.getStat(this.statMiss, dfsStreamKey).incrementAndGet();
            boolean bl2 = true;
            try {
                dfsBlock = blockBasedFile.readOneBlock(l2, dfsReader, dfsBlockCache$ReadableChannelSupplier.get());
                bl2 = false;
            }
            finally {
                if (bl2) {
                    this.creditSpace(this.blockSize, dfsStreamKey);
                }
            }
            if (l2 != dfsBlock.start) {
                l2 = dfsBlock.start;
                n2 = this.slot(dfsStreamKey, l2);
                dfsBlockCache$HashEntry3 = (DfsBlockCache$HashEntry)this.table.get(n2);
            }
            DfsBlockCache$Ref dfsBlockCache$Ref = new DfsBlockCache$Ref(dfsStreamKey, l2, dfsBlock.size(), dfsBlock);
            dfsBlockCache$Ref.hot = true;
            while (!this.table.compareAndSet(n2, dfsBlockCache$HashEntry3, dfsBlockCache$HashEntry2 = new DfsBlockCache$HashEntry(DfsBlockCache.clean(dfsBlockCache$HashEntry3), dfsBlockCache$Ref))) {
                dfsBlockCache$HashEntry3 = (DfsBlockCache$HashEntry)this.table.get(n2);
            }
            this.addToClock(dfsBlockCache$Ref, this.blockSize - dfsBlock.size());
        }
        finally {
            reentrantLock.unlock();
        }
        if (dfsBlock.contains(blockBasedFile.key, l3)) {
            return dfsBlock;
        }
        return this.getOrLoad(blockBasedFile, l3, dfsReader, dfsBlockCache$ReadableChannelSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveSpace(long l2, DfsStreamKey dfsStreamKey) {
        this.clockLock.lock();
        try {
            long l3 = LongStream.of(this.getCurrentSize()).sum() + l2;
            if (this.maxBytes < l3) {
                DfsBlockCache$Ref dfsBlockCache$Ref = this.clockHand;
                DfsBlockCache$Ref dfsBlockCache$Ref2 = this.clockHand.next;
                do {
                    if (dfsBlockCache$Ref2.hot) {
                        dfsBlockCache$Ref2.hot = false;
                        dfsBlockCache$Ref = dfsBlockCache$Ref2;
                        dfsBlockCache$Ref2 = dfsBlockCache$Ref2.next;
                        continue;
                    }
                    if (dfsBlockCache$Ref == dfsBlockCache$Ref2) break;
                    DfsBlockCache$Ref dfsBlockCache$Ref3 = dfsBlockCache$Ref2;
                    dfsBlockCache$Ref.next = dfsBlockCache$Ref2 = dfsBlockCache$Ref2.next;
                    dfsBlockCache$Ref3.next = null;
                    dfsBlockCache$Ref3.value = null;
                    l3 -= dfsBlockCache$Ref3.size;
                    DfsBlockCache.getStat(this.liveBytes, dfsBlockCache$Ref3.key).addAndGet(-dfsBlockCache$Ref3.size);
                    DfsBlockCache.getStat(this.statEvict, dfsBlockCache$Ref3.key).incrementAndGet();
                } while (this.maxBytes < l3);
                this.clockHand = dfsBlockCache$Ref;
            }
            DfsBlockCache.getStat(this.liveBytes, dfsStreamKey).addAndGet(l2);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creditSpace(long l2, DfsStreamKey dfsStreamKey) {
        this.clockLock.lock();
        try {
            DfsBlockCache.getStat(this.liveBytes, dfsStreamKey).addAndGet(-l2);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToClock(DfsBlockCache$Ref dfsBlockCache$Ref, long l2) {
        this.clockLock.lock();
        try {
            if (l2 != 0L) {
                DfsBlockCache.getStat(this.liveBytes, dfsBlockCache$Ref.key).addAndGet(-l2);
            }
            DfsBlockCache$Ref dfsBlockCache$Ref2 = this.clockHand;
            dfsBlockCache$Ref.next = dfsBlockCache$Ref2.next;
            dfsBlockCache$Ref2.next = dfsBlockCache$Ref;
            this.clockHand = dfsBlockCache$Ref;
        }
        finally {
            this.clockLock.unlock();
        }
    }

    void put(DfsBlock dfsBlock) {
        this.put(dfsBlock.stream, dfsBlock.start, dfsBlock.size(), dfsBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsBlockCache$Ref getOrLoadRef(DfsStreamKey dfsStreamKey, long l2, DfsBlockCache$RefLoader dfsBlockCache$RefLoader) {
        int n2 = this.slot(dfsStreamKey, l2);
        DfsBlockCache$HashEntry dfsBlockCache$HashEntry = (DfsBlockCache$HashEntry)this.table.get(n2);
        DfsBlockCache$Ref dfsBlockCache$Ref = this.scanRef(dfsBlockCache$HashEntry, dfsStreamKey, l2);
        if (dfsBlockCache$Ref != null) {
            DfsBlockCache.getStat(this.statHit, dfsStreamKey).incrementAndGet();
            return dfsBlockCache$Ref;
        }
        ReentrantLock reentrantLock = this.lockForRef(dfsStreamKey);
        long l3 = System.currentTimeMillis();
        reentrantLock.lock();
        try {
            DfsBlockCache$HashEntry dfsBlockCache$HashEntry2;
            DfsBlockCache$HashEntry dfsBlockCache$HashEntry3 = (DfsBlockCache$HashEntry)this.table.get(n2);
            if (dfsBlockCache$HashEntry3 != dfsBlockCache$HashEntry && (dfsBlockCache$Ref = this.scanRef(dfsBlockCache$HashEntry3, dfsStreamKey, l2)) != null) {
                DfsBlockCache.getStat(this.statHit, dfsStreamKey).incrementAndGet();
                DfsBlockCache$Ref dfsBlockCache$Ref2 = dfsBlockCache$Ref;
                return dfsBlockCache$Ref2;
            }
            if (this.refLockWaitTime != null) {
                this.refLockWaitTime.accept(System.currentTimeMillis() - l3);
            }
            DfsBlockCache.getStat(this.statMiss, dfsStreamKey).incrementAndGet();
            dfsBlockCache$Ref = dfsBlockCache$RefLoader.load();
            dfsBlockCache$Ref.hot = true;
            this.reserveSpace(dfsBlockCache$Ref.size, dfsStreamKey);
            while (!this.table.compareAndSet(n2, dfsBlockCache$HashEntry3, dfsBlockCache$HashEntry2 = new DfsBlockCache$HashEntry(DfsBlockCache.clean(dfsBlockCache$HashEntry3), dfsBlockCache$Ref))) {
                dfsBlockCache$HashEntry3 = (DfsBlockCache$HashEntry)this.table.get(n2);
            }
            this.addToClock(dfsBlockCache$Ref, 0L);
        }
        finally {
            reentrantLock.unlock();
        }
        return dfsBlockCache$Ref;
    }

    DfsBlockCache$Ref putRef(DfsStreamKey dfsStreamKey, long l2, Object object) {
        return this.put(dfsStreamKey, 0L, l2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsBlockCache$Ref put(DfsStreamKey dfsStreamKey, long l2, long l3, Object object) {
        int n2 = this.slot(dfsStreamKey, l2);
        DfsBlockCache$HashEntry dfsBlockCache$HashEntry = (DfsBlockCache$HashEntry)this.table.get(n2);
        DfsBlockCache$Ref dfsBlockCache$Ref = this.scanRef(dfsBlockCache$HashEntry, dfsStreamKey, l2);
        if (dfsBlockCache$Ref != null) {
            return dfsBlockCache$Ref;
        }
        this.reserveSpace(l3, dfsStreamKey);
        ReentrantLock reentrantLock = this.lockFor(dfsStreamKey, l2);
        reentrantLock.lock();
        try {
            DfsBlockCache$HashEntry dfsBlockCache$HashEntry2;
            DfsBlockCache$HashEntry dfsBlockCache$HashEntry3 = (DfsBlockCache$HashEntry)this.table.get(n2);
            if (dfsBlockCache$HashEntry3 != dfsBlockCache$HashEntry && (dfsBlockCache$Ref = this.scanRef(dfsBlockCache$HashEntry3, dfsStreamKey, l2)) != null) {
                this.creditSpace(l3, dfsStreamKey);
                DfsBlockCache$Ref dfsBlockCache$Ref2 = dfsBlockCache$Ref;
                return dfsBlockCache$Ref2;
            }
            dfsBlockCache$Ref = new DfsBlockCache$Ref(dfsStreamKey, l2, l3, object);
            dfsBlockCache$Ref.hot = true;
            while (!this.table.compareAndSet(n2, dfsBlockCache$HashEntry3, dfsBlockCache$HashEntry2 = new DfsBlockCache$HashEntry(DfsBlockCache.clean(dfsBlockCache$HashEntry3), dfsBlockCache$Ref))) {
                dfsBlockCache$HashEntry3 = (DfsBlockCache$HashEntry)this.table.get(n2);
            }
            this.addToClock(dfsBlockCache$Ref, 0L);
        }
        finally {
            reentrantLock.unlock();
        }
        return dfsBlockCache$Ref;
    }

    boolean contains(DfsStreamKey dfsStreamKey, long l2) {
        return this.scan((DfsBlockCache$HashEntry)this.table.get(this.slot(dfsStreamKey, l2)), dfsStreamKey, l2) != null;
    }

    Object get(DfsStreamKey dfsStreamKey, long l2) {
        Object object = this.scan((DfsBlockCache$HashEntry)this.table.get(this.slot(dfsStreamKey, l2)), dfsStreamKey, l2);
        if (object == null) {
            DfsBlockCache.getStat(this.statMiss, dfsStreamKey).incrementAndGet();
        } else {
            DfsBlockCache.getStat(this.statHit, dfsStreamKey).incrementAndGet();
        }
        return object;
    }

    private Object scan(DfsBlockCache$HashEntry dfsBlockCache$HashEntry, DfsStreamKey dfsStreamKey, long l2) {
        DfsBlockCache$Ref dfsBlockCache$Ref = this.scanRef(dfsBlockCache$HashEntry, dfsStreamKey, l2);
        return dfsBlockCache$Ref != null ? dfsBlockCache$Ref.get() : null;
    }

    private DfsBlockCache$Ref scanRef(DfsBlockCache$HashEntry dfsBlockCache$HashEntry, DfsStreamKey dfsStreamKey, long l2) {
        while (dfsBlockCache$HashEntry != null) {
            DfsBlockCache$Ref dfsBlockCache$Ref = dfsBlockCache$HashEntry.ref;
            if (dfsBlockCache$Ref.position == l2 && dfsBlockCache$Ref.key.equals(dfsStreamKey)) {
                return dfsBlockCache$Ref.get() != null ? dfsBlockCache$Ref : null;
            }
            dfsBlockCache$HashEntry = dfsBlockCache$HashEntry.next;
        }
        return null;
    }

    private int slot(DfsStreamKey dfsStreamKey, long l2) {
        return (this.hash(dfsStreamKey.hash, l2) >>> 1) % this.tableSize;
    }

    private ReentrantLock lockFor(DfsStreamKey dfsStreamKey, long l2) {
        return this.loadLocks[(this.hash(dfsStreamKey.hash, l2) >>> 1) % this.loadLocks.length];
    }

    private ReentrantLock lockForRef(DfsStreamKey dfsStreamKey) {
        return this.refLocks[(dfsStreamKey.hash >>> 1) % this.refLocks.length];
    }

    private static AtomicLong[] newCounters() {
        AtomicLong[] atomicLongArray = new AtomicLong[PackExt.values().length];
        for (int i2 = 0; i2 < atomicLongArray.length; ++i2) {
            atomicLongArray[i2] = new AtomicLong();
        }
        return atomicLongArray;
    }

    private static AtomicLong getStat(AtomicReference atomicReference, DfsStreamKey dfsStreamKey) {
        AtomicLong[] atomicLongArray;
        AtomicLong[] atomicLongArray2;
        int n2 = dfsStreamKey.packExtPos;
        do {
            if (n2 < (atomicLongArray = (AtomicLong[])atomicReference.get()).length) {
                return atomicLongArray[n2];
            }
            atomicLongArray2 = atomicLongArray;
            atomicLongArray = new AtomicLong[Math.max(n2 + 1, PackExt.values().length)];
            System.arraycopy(atomicLongArray2, 0, atomicLongArray, 0, atomicLongArray2.length);
            for (int i2 = atomicLongArray2.length; i2 < atomicLongArray.length; ++i2) {
                atomicLongArray[i2] = new AtomicLong();
            }
        } while (!atomicReference.compareAndSet(atomicLongArray2, atomicLongArray));
        return atomicLongArray[n2];
    }

    private static long[] getStatVals(AtomicReference atomicReference) {
        AtomicLong[] atomicLongArray = (AtomicLong[])atomicReference.get();
        long[] lArray = new long[atomicLongArray.length];
        for (int i2 = 0; i2 < atomicLongArray.length; ++i2) {
            lArray[i2] = atomicLongArray[i2].get();
        }
        return lArray;
    }

    private static DfsBlockCache$HashEntry clean(DfsBlockCache$HashEntry dfsBlockCache$HashEntry) {
        while (dfsBlockCache$HashEntry != null && dfsBlockCache$HashEntry.ref.next == null) {
            dfsBlockCache$HashEntry = dfsBlockCache$HashEntry.next;
        }
        if (dfsBlockCache$HashEntry == null) {
            return null;
        }
        DfsBlockCache$HashEntry dfsBlockCache$HashEntry2 = DfsBlockCache.clean(dfsBlockCache$HashEntry.next);
        return dfsBlockCache$HashEntry2 == dfsBlockCache$HashEntry.next ? dfsBlockCache$HashEntry : new DfsBlockCache$HashEntry(dfsBlockCache$HashEntry2, dfsBlockCache$HashEntry.ref);
    }

    static {
        DfsBlockCache.reconfigure(new DfsBlockCacheConfig());
    }
}

