/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class DfsBlock {
    final DfsStreamKey stream;
    final long start;
    final long end;
    private final byte[] block;

    DfsBlock(DfsStreamKey dfsStreamKey, long l2, byte[] byArray) {
        this.stream = dfsStreamKey;
        this.start = l2;
        this.end = l2 + (long)byArray.length;
        this.block = byArray;
    }

    int size() {
        return this.block.length;
    }

    ByteBuffer zeroCopyByteBuffer(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.block);
        byteBuffer.position(n2);
        return byteBuffer;
    }

    boolean contains(DfsStreamKey dfsStreamKey, long l2) {
        return this.stream.equals(dfsStreamKey) && this.start <= l2 && l2 < this.end;
    }

    int copy(long l2, byte[] byArray, int n2, int n3) {
        int n4 = (int)(l2 - this.start);
        return this.copy(n4, byArray, n2, n3);
    }

    int copy(int n2, byte[] byArray, int n3, int n4) {
        n4 = Math.min(this.block.length - n2, n4);
        System.arraycopy(this.block, n2, byArray, n3, n4);
        return n4;
    }

    int setInput(long l2, Inflater inflater) {
        int n2 = (int)(l2 - this.start);
        int n3 = this.block.length - n2;
        if (n3 <= 0) {
            throw new DataFormatException(n3 + " bytes to inflate: at pos=" + l2 + "; block.start=" + this.start + "; ptr=" + n2 + "; block.length=" + this.block.length);
        }
        inflater.setInput(this.block, n2, n3);
        return n3;
    }

    void crc32(CRC32 cRC32, long l2, int n2) {
        int n3 = (int)(l2 - this.start);
        cRC32.update(this.block, n3, n2);
    }

    void write(PackOutputStream packOutputStream, long l2, int n2) {
        packOutputStream.write(this.block, (int)(l2 - this.start), n2);
    }

    void check(Inflater inflater, byte[] byArray, long l2, int n2) {
        inflater.setInput(this.block, (int)(l2 - this.start), n2);
        while (inflater.inflate(byArray, 0, byArray.length) > 0) {
        }
    }
}

