/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache$Entry;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;

final class DeltaBaseCache {
    private static final int TABLE_BITS = 10;
    private static final int MASK_BITS = 22;
    private int maxByteCount;
    private int curByteCount;
    private final DeltaBaseCache$Entry[] table;
    private DeltaBaseCache$Entry lruHead;
    private DeltaBaseCache$Entry lruTail;

    private static int hash(long l2) {
        return (int)l2 << 22 >>> 22;
    }

    DeltaBaseCache(DfsReader dfsReader) {
        this(dfsReader.getOptions().getDeltaBaseCacheLimit());
    }

    DeltaBaseCache(int n2) {
        this.maxByteCount = n2;
        this.table = new DeltaBaseCache$Entry[1024];
    }

    DeltaBaseCache$Entry get(DfsStreamKey dfsStreamKey, long l2) {
        DeltaBaseCache$Entry deltaBaseCache$Entry = this.table[DeltaBaseCache.hash(l2)];
        while (deltaBaseCache$Entry != null) {
            if (deltaBaseCache$Entry.offset == l2 && dfsStreamKey.equals(deltaBaseCache$Entry.pack)) {
                this.moveToHead(deltaBaseCache$Entry);
                return deltaBaseCache$Entry;
            }
            deltaBaseCache$Entry = deltaBaseCache$Entry.tableNext;
        }
        return null;
    }

    void put(DfsStreamKey dfsStreamKey, long l2, int n2, byte[] byArray) {
        if (byArray.length > this.maxByteCount) {
            return;
        }
        this.curByteCount += byArray.length;
        this.releaseMemory();
        int n3 = DeltaBaseCache.hash(l2);
        DeltaBaseCache$Entry deltaBaseCache$Entry = new DeltaBaseCache$Entry(dfsStreamKey, l2, n2, byArray);
        deltaBaseCache$Entry.tableNext = this.table[n3];
        this.table[n3] = deltaBaseCache$Entry;
        this.lruPushHead(deltaBaseCache$Entry);
    }

    private void releaseMemory() {
        while (this.curByteCount > this.maxByteCount && this.lruTail != null) {
            DeltaBaseCache$Entry deltaBaseCache$Entry = this.lruTail;
            this.curByteCount -= deltaBaseCache$Entry.data.length;
            this.lruRemove(deltaBaseCache$Entry);
            this.removeFromTable(deltaBaseCache$Entry);
        }
    }

    private void removeFromTable(DeltaBaseCache$Entry deltaBaseCache$Entry) {
        int n2 = DeltaBaseCache.hash(deltaBaseCache$Entry.offset);
        DeltaBaseCache$Entry deltaBaseCache$Entry2 = this.table[n2];
        if (deltaBaseCache$Entry2 == deltaBaseCache$Entry) {
            this.table[n2] = deltaBaseCache$Entry.tableNext;
            return;
        }
        while (deltaBaseCache$Entry2 != null) {
            if (deltaBaseCache$Entry2.tableNext == deltaBaseCache$Entry) {
                deltaBaseCache$Entry2.tableNext = deltaBaseCache$Entry.tableNext;
                return;
            }
            deltaBaseCache$Entry2 = deltaBaseCache$Entry2.tableNext;
        }
        throw new IllegalStateException(String.format("entry for %s:%d not in table", deltaBaseCache$Entry.pack, deltaBaseCache$Entry.offset));
    }

    private void moveToHead(DeltaBaseCache$Entry deltaBaseCache$Entry) {
        if (deltaBaseCache$Entry != this.lruHead) {
            this.lruRemove(deltaBaseCache$Entry);
            this.lruPushHead(deltaBaseCache$Entry);
        }
    }

    private void lruRemove(DeltaBaseCache$Entry deltaBaseCache$Entry) {
        DeltaBaseCache$Entry deltaBaseCache$Entry2 = deltaBaseCache$Entry.lruPrev;
        DeltaBaseCache$Entry deltaBaseCache$Entry3 = deltaBaseCache$Entry.lruNext;
        if (deltaBaseCache$Entry2 != null) {
            deltaBaseCache$Entry2.lruNext = deltaBaseCache$Entry3;
        } else {
            this.lruHead = deltaBaseCache$Entry3;
        }
        if (deltaBaseCache$Entry3 != null) {
            deltaBaseCache$Entry3.lruPrev = deltaBaseCache$Entry2;
        } else {
            this.lruTail = deltaBaseCache$Entry2;
        }
    }

    private void lruPushHead(DeltaBaseCache$Entry deltaBaseCache$Entry) {
        DeltaBaseCache$Entry deltaBaseCache$Entry2;
        deltaBaseCache$Entry.lruNext = deltaBaseCache$Entry2 = this.lruHead;
        if (deltaBaseCache$Entry2 != null) {
            deltaBaseCache$Entry2.lruPrev = deltaBaseCache$Entry;
        } else {
            this.lruTail = deltaBaseCache$Entry;
        }
        deltaBaseCache$Entry.lruPrev = null;
        this.lruHead = deltaBaseCache$Entry;
    }

    int getMemoryUsed() {
        return this.curByteCount;
    }

    int getMemoryUsedByLruChainForTest() {
        int n2 = 0;
        DeltaBaseCache$Entry deltaBaseCache$Entry = this.lruHead;
        while (deltaBaseCache$Entry != null) {
            n2 += deltaBaseCache$Entry.data.length;
            deltaBaseCache$Entry = deltaBaseCache$Entry.lruNext;
        }
        return n2;
    }

    int getMemoryUsedByTableForTest() {
        int n2 = 0;
        DeltaBaseCache$Entry[] deltaBaseCache$EntryArray = this.table;
        int n3 = deltaBaseCache$EntryArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            DeltaBaseCache$Entry deltaBaseCache$Entry;
            DeltaBaseCache$Entry deltaBaseCache$Entry2 = deltaBaseCache$Entry = deltaBaseCache$EntryArray[i2];
            while (deltaBaseCache$Entry2 != null) {
                n2 += deltaBaseCache$Entry2.data.length;
                deltaBaseCache$Entry2 = deltaBaseCache$Entry2.tableNext;
            }
        }
        return n2;
    }
}

