/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile$LazyChannel;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;

abstract class BlockBasedFile {
    final DfsBlockCache cache;
    final DfsStreamKey key;
    final DfsPackDescription desc;
    final PackExt ext;
    volatile int blockSize;
    volatile long length;
    volatile boolean invalid;
    protected volatile Exception invalidatingCause;

    BlockBasedFile(DfsBlockCache dfsBlockCache, DfsPackDescription dfsPackDescription, PackExt packExt) {
        this.cache = dfsBlockCache;
        this.key = dfsPackDescription.getStreamKey(packExt);
        this.desc = dfsPackDescription;
        this.ext = packExt;
    }

    String getFileName() {
        return this.desc.getFileName(this.ext);
    }

    boolean invalid() {
        return this.invalid;
    }

    void setInvalid() {
        this.invalid = true;
    }

    void setBlockSize(int n2) {
        this.blockSize = n2;
    }

    long alignToBlock(long l2) {
        int n2 = this.blockSize;
        if (n2 == 0) {
            n2 = this.cache.getBlockSize();
        }
        return l2 / (long)n2 * (long)n2;
    }

    int blockSize(ReadableChannel readableChannel) {
        int n2 = this.blockSize;
        if (n2 == 0) {
            n2 = readableChannel.blockSize();
            if (n2 <= 0) {
                n2 = this.cache.getBlockSize();
            } else if (n2 < this.cache.getBlockSize()) {
                n2 = this.cache.getBlockSize() / n2 * n2;
            }
            this.blockSize = n2;
        }
        return n2;
    }

    DfsBlock getOrLoadBlock(long l2, DfsReader dfsReader) {
        try (BlockBasedFile$LazyChannel blockBasedFile$LazyChannel = new BlockBasedFile$LazyChannel(dfsReader, this.desc, this.ext);){
            DfsBlock dfsBlock = this.cache.getOrLoad(this, l2, dfsReader, blockBasedFile$LazyChannel);
            return dfsBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsBlock readOneBlock(long l2, DfsReader dfsReader, ReadableChannel readableChannel) {
        if (this.invalid) {
            throw new PackInvalidException(this.getFileName(), (Throwable)this.invalidatingCause);
        }
        ++dfsReader.stats.readBlock;
        long l3 = System.nanoTime();
        try {
            Object object;
            int n2 = this.blockSize(readableChannel);
            l2 = l2 / (long)n2 * (long)n2;
            long l4 = this.length;
            if (l4 < 0L && 0L <= (l4 = readableChannel.size())) {
                this.length = l4;
            }
            if (0L <= l4 && l4 < l2 + (long)n2) {
                n2 = (int)(l4 - l2);
            }
            if (n2 <= 0) {
                throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, l2, this.getFileName(), 0L, 0L));
            }
            byte[] byArray = new byte[n2];
            readableChannel.position(l2);
            int n3 = BlockBasedFile.read(readableChannel, ByteBuffer.wrap(byArray, 0, n2));
            dfsReader.stats.readBlockBytes += (long)n3;
            if (n3 != n2) {
                if (0L <= l4) {
                    throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, l2, this.getFileName(), n2, n3));
                }
                object = new byte[n3];
                System.arraycopy(byArray, 0, object, 0, ((byte[])object).length);
                byArray = object;
            } else if (l4 < 0L) {
                this.length = l4 = readableChannel.size();
            }
            object = new DfsBlock(this.key, l2, byArray);
            return object;
        }
        finally {
            dfsReader.stats.readBlockMicros += BlockBasedFile.elapsedMicros(l3);
        }
    }

    static int read(ReadableChannel readableChannel, ByteBuffer byteBuffer) {
        int n2;
        while (0 < (n2 = readableChannel.read(byteBuffer)) && byteBuffer.hasRemaining()) {
        }
        return byteBuffer.position();
    }

    static long elapsedMicros(long l2) {
        return (System.nanoTime() - l2) / 1000L;
    }
}

