/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.revwalk;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

public class PedestrianReachabilityChecker
implements ReachabilityChecker {
    private final boolean topoSort;
    private final RevWalk walk;

    public PedestrianReachabilityChecker(boolean bl2, RevWalk revWalk) {
        this.topoSort = bl2;
        this.walk = revWalk;
    }

    @Override
    public Optional areAllReachable(Collection collection, Stream stream) {
        this.walk.reset();
        if (this.topoSort) {
            this.walk.sort(RevSort.TOPO);
        }
        for (RevCommit revCommit : collection) {
            this.walk.markStart(revCommit);
        }
        Iterator<Object> iterator = stream.iterator();
        while (iterator.hasNext()) {
            this.walk.markUninteresting((RevCommit)iterator.next());
        }
        return Optional.ofNullable(this.walk.next());
    }
}

