/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.revwalk;

import java.io.InvalidObjectException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;

public class PedestrianObjectReachabilityChecker
implements ObjectReachabilityChecker {
    private final ObjectWalk walk;

    public PedestrianObjectReachabilityChecker(ObjectWalk objectWalk) {
        this.walk = objectWalk;
    }

    @Override
    public Optional areAllReachable(Collection collection, Stream stream) {
        try {
            RevObject revObject;
            RevObject revObject22;
            this.walk.reset();
            this.walk.sort(RevSort.TOPO);
            for (RevObject revObject22 : collection) {
                this.walk.markStart(revObject22);
            }
            Iterator<Object> iterator = stream.iterator();
            while (iterator.hasNext()) {
                revObject22 = (RevObject)iterator.next();
                this.walk.markUninteresting(revObject22);
                revObject = this.walk.peel(revObject22);
                if (!(revObject instanceof RevCommit)) continue;
                this.walk.markUninteresting(((RevCommit)revObject).getTree());
            }
            revObject22 = this.walk.next();
            if (revObject22 != null) {
                return Optional.of(revObject22);
            }
            revObject = this.walk.nextObject();
            if (revObject != null) {
                return Optional.of(revObject);
            }
            return Optional.empty();
        }
        catch (InvalidObjectException | MissingObjectException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

