/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.revwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.internal.revwalk.BitmappedReachabilityChecker$ReachedFilter;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

public class BitmappedReachabilityChecker
implements ReachabilityChecker {
    private final RevWalk walk;

    public BitmappedReachabilityChecker(RevWalk revWalk) {
        this.walk = revWalk;
        if (revWalk.getObjectReader().getBitmapIndex() == null) {
            throw new AssertionError((Object)"Trying to use bitmapped reachability check on a repository without bitmaps");
        }
    }

    @Override
    public Optional areAllReachable(Collection collection, Stream stream) {
        ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>(collection);
        this.walk.reset();
        this.walk.sort(RevSort.TOPO);
        BitmapIndex bitmapIndex = this.walk.getObjectReader().getBitmapIndex();
        BitmappedReachabilityChecker$ReachedFilter bitmappedReachabilityChecker$ReachedFilter = new BitmappedReachabilityChecker$ReachedFilter(bitmapIndex);
        this.walk.setRevFilter(bitmappedReachabilityChecker$ReachedFilter);
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            this.walk.markStart((RevCommit)iterator.next());
            while (this.walk.next() != null) {
                arrayList.removeIf(bitmappedReachabilityChecker$ReachedFilter::isReachable);
                if (!arrayList.isEmpty()) continue;
                return Optional.empty();
            }
            this.walk.reset();
        }
        return Optional.of(arrayList.get(0));
    }
}

