/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.revwalk;

import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.BitmapIndex$Bitmap;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class BitmappedReachabilityChecker$ReachedFilter
extends RevFilter {
    private final BitmapIndex repoBitmaps;
    private final BitmapIndex$BitmapBuilder reached;

    public BitmappedReachabilityChecker$ReachedFilter(BitmapIndex bitmapIndex) {
        this.repoBitmaps = bitmapIndex;
        this.reached = bitmapIndex.newBitmapBuilder();
    }

    @Override
    public final boolean include(RevWalk revWalk, RevCommit revCommit) {
        if (this.reached.contains(revCommit)) {
            BitmappedReachabilityChecker$ReachedFilter.dontFollow(revCommit);
            return false;
        }
        BitmapIndex$Bitmap bitmapIndex$Bitmap = this.repoBitmaps.getBitmap(revCommit);
        if (bitmapIndex$Bitmap != null) {
            this.reached.or(bitmapIndex$Bitmap);
            BitmappedReachabilityChecker$ReachedFilter.dontFollow(revCommit);
            return true;
        }
        this.reached.addObject(revCommit, 1);
        return true;
    }

    private static final void dontFollow(RevCommit revCommit) {
        for (RevCommit revCommit2 : revCommit.getParents()) {
            revCommit2.add(RevFlag.SEEN);
        }
    }

    @Override
    public final RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean requiresCommitBody() {
        return false;
    }

    boolean isReachable(RevCommit revCommit) {
        return this.reached.contains(revCommit);
    }
}

