/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.revwalk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;
import org.eclipse.jgit.revwalk.BitmapWalker;
import org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;

public class BitmappedObjectReachabilityChecker
implements ObjectReachabilityChecker {
    private final ObjectWalk walk;

    public BitmappedObjectReachabilityChecker(ObjectWalk objectWalk) {
        this.walk = objectWalk;
    }

    @Override
    public Optional areAllReachable(Collection collection, Stream stream) {
        try {
            ArrayList<RevObject> arrayList = new ArrayList<RevObject>(collection);
            BitmapWalker bitmapWalker = new BitmapWalker(this.walk, this.walk.getObjectReader().getBitmapIndex(), null);
            Iterator iterator = stream.iterator();
            BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder = null;
            while (iterator.hasNext()) {
                List<RevObject> list = Arrays.asList((RevObject)iterator.next());
                BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder2 = bitmapWalker.findObjects(list, bitmapIndex$BitmapBuilder, true);
                bitmapIndex$BitmapBuilder = bitmapIndex$BitmapBuilder == null ? bitmapIndex$BitmapBuilder2 : bitmapIndex$BitmapBuilder.or(bitmapIndex$BitmapBuilder2);
                arrayList.removeIf(bitmapIndex$BitmapBuilder::contains);
                if (!arrayList.isEmpty()) continue;
                return Optional.empty();
            }
            return Optional.of(arrayList.get(0));
        }
        catch (IncorrectObjectTypeException | MissingObjectException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

