/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.revwalk;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex$Bitmap;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class AddToBitmapWithCacheFilter
extends RevFilter {
    private final AnyObjectId cachedCommit;
    private final BitmapIndex$Bitmap cachedBitmap;
    private final BitmapIndex$BitmapBuilder bitmap;

    public AddToBitmapWithCacheFilter(AnyObjectId anyObjectId, BitmapIndex$Bitmap bitmapIndex$Bitmap, BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder) {
        this.cachedCommit = anyObjectId;
        this.cachedBitmap = bitmapIndex$Bitmap;
        this.bitmap = bitmapIndex$BitmapBuilder;
    }

    @Override
    public final boolean include(RevWalk revWalk, RevCommit revCommit) {
        if (!this.bitmap.contains(revCommit)) {
            BitmapIndex$Bitmap bitmapIndex$Bitmap = this.bitmap.getBitmapIndex().getBitmap(revCommit);
            if (bitmapIndex$Bitmap != null) {
                this.bitmap.or(bitmapIndex$Bitmap);
            } else if (this.cachedCommit.equals(revCommit)) {
                this.bitmap.or(this.cachedBitmap);
            } else {
                this.bitmap.addObject(revCommit, 1);
                return true;
            }
        }
        for (RevCommit revCommit2 : revCommit.getParents()) {
            revCommit2.add(RevFlag.SEEN);
        }
        return false;
    }

    @Override
    public final RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean requiresCommitBody() {
        return false;
    }
}

