/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.fsck;

import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.CorruptPackIndexException;
import org.eclipse.jgit.errors.CorruptPackIndexException$ErrorType;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.fsck.FsckError$CorruptObject;
import org.eclipse.jgit.internal.fsck.FsckPackParser$ObjFromPack;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex$MutableEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackParser$UnresolvedDelta;
import org.eclipse.jgit.transport.PackedObjectInfo;

public class FsckPackParser
extends PackParser {
    private final CRC32 crc;
    private final ReadableChannel channel;
    private final Set corruptObjects = new HashSet();
    private long expectedObjectCount = -1L;
    private long offset;
    private int blockSize;

    public FsckPackParser(ObjectDatabase objectDatabase, ReadableChannel readableChannel) {
        super(objectDatabase, Channels.newInputStream(readableChannel));
        this.channel = readableChannel;
        this.setCheckObjectCollisions(false);
        this.crc = new CRC32();
        this.blockSize = readableChannel.blockSize() > 0 ? readableChannel.blockSize() : 65536;
    }

    @Override
    protected void onPackHeader(long l2) {
        if (this.expectedObjectCount >= 0L) {
            this.setExpectedObjectCount(this.expectedObjectCount);
        }
    }

    @Override
    protected void onBeginWholeObject(long l2, int n2, long l3) {
        this.crc.reset();
    }

    @Override
    protected void onObjectHeader(PackParser.Source source, byte[] byArray, int n2, int n3) {
        this.crc.update(byArray, n2, n3);
    }

    @Override
    protected void onObjectData(PackParser.Source source, byte[] byArray, int n2, int n3) {
        this.crc.update(byArray, n2, n3);
    }

    @Override
    protected void onEndWholeObject(PackedObjectInfo packedObjectInfo) {
        packedObjectInfo.setCRC((int)this.crc.getValue());
    }

    @Override
    protected void onBeginOfsDelta(long l2, long l3, long l4) {
        this.crc.reset();
    }

    @Override
    protected void onBeginRefDelta(long l2, AnyObjectId anyObjectId, long l3) {
        this.crc.reset();
    }

    @Override
    protected PackParser$UnresolvedDelta onEndDelta() {
        PackParser$UnresolvedDelta packParser$UnresolvedDelta = new PackParser$UnresolvedDelta();
        packParser$UnresolvedDelta.setCRC((int)this.crc.getValue());
        return packParser$UnresolvedDelta;
    }

    @Override
    protected void onInflatedObjectData(PackedObjectInfo packedObjectInfo, int n2, byte[] byArray) {
    }

    @Override
    protected void verifySafeObject(AnyObjectId anyObjectId, int n2, byte[] byArray) {
        try {
            super.verifySafeObject(anyObjectId, n2, byArray);
        }
        catch (CorruptObjectException corruptObjectException) {
            this.corruptObjects.add(new FsckError$CorruptObject(anyObjectId.toObjectId(), n2, corruptObjectException.getErrorType()));
        }
    }

    @Override
    protected void onPackFooter(byte[] byArray) {
    }

    @Override
    protected boolean onAppendBase(int n2, byte[] byArray, PackedObjectInfo packedObjectInfo) {
        return false;
    }

    @Override
    protected void onEndThinPack() {
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackedObjectInfo packedObjectInfo, PackParser.ObjectTypeAndSize objectTypeAndSize) {
        this.crc.reset();
        this.offset = packedObjectInfo.getOffset();
        return this.readObjectHeader(objectTypeAndSize);
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackParser$UnresolvedDelta packParser$UnresolvedDelta, PackParser.ObjectTypeAndSize objectTypeAndSize) {
        this.crc.reset();
        this.offset = packParser$UnresolvedDelta.getOffset();
        return this.readObjectHeader(objectTypeAndSize);
    }

    @Override
    protected int readDatabase(byte[] byArray, int n2, int n3) {
        int n4 = this.read(this.offset, byArray, n2, n3);
        if (n4 > 0) {
            this.offset += (long)n4;
        }
        return n4;
    }

    int read(long l2, byte[] byArray, int n2, int n3) {
        long l3 = l2 / (long)this.blockSize;
        byte[] byArray2 = this.readFromChannel(l3);
        if (byArray2 == null) {
            return -1;
        }
        int n4 = (int)(l2 - l3 * (long)this.blockSize);
        int n5 = Math.min(n3, byArray2.length - n4);
        if (n5 < 1) {
            return -1;
        }
        System.arraycopy(byArray2, n4, byArray, n2, n5);
        return n5;
    }

    private byte[] readFromChannel(long l2) {
        int n2;
        this.channel.position(l2 * (long)this.blockSize);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.blockSize);
        for (int i2 = 0; i2 < this.blockSize; i2 += n2) {
            n2 = this.channel.read(byteBuffer);
            if (n2 != -1) continue;
            if (i2 == 0) {
                return null;
            }
            return Arrays.copyOf(byteBuffer.array(), i2);
        }
        return byteBuffer.array();
    }

    @Override
    protected boolean checkCRC(int n2) {
        return n2 == (int)this.crc.getValue();
    }

    @Override
    protected void onStoreStream(byte[] byArray, int n2, int n3) {
    }

    public Set getCorruptObjects() {
        return this.corruptObjects;
    }

    public void verifyIndex(PackIndex packIndex) {
        ObjectIdOwnerMap objectIdOwnerMap = new ObjectIdOwnerMap();
        for (int i2 = 0; i2 < this.getObjectCount(); ++i2) {
            Object object = this.getObject(i2);
            objectIdOwnerMap.add(new FsckPackParser$ObjFromPack((AnyObjectId)object));
            long l2 = packIndex.findOffset((AnyObjectId)object);
            if (l2 == -1L) {
                throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().missingObject, ((PackedObjectInfo)object).getType(), ((AnyObjectId)object).getName()), CorruptPackIndexException$ErrorType.MISSING_OBJ);
            }
            if (l2 != ((PackedObjectInfo)object).getOffset()) {
                throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().mismatchOffset, ((AnyObjectId)object).getName()), CorruptPackIndexException$ErrorType.MISMATCH_OFFSET);
            }
            try {
                if (!packIndex.hasCRC32Support() || (int)packIndex.findCRC32((AnyObjectId)object) == ((PackedObjectInfo)object).getCRC()) continue;
                throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().mismatchCRC, ((AnyObjectId)object).getName()), CorruptPackIndexException$ErrorType.MISMATCH_CRC);
            }
            catch (MissingObjectException missingObjectException) {
                CorruptPackIndexException corruptPackIndexException = new CorruptPackIndexException(MessageFormat.format(JGitText.get().missingCRC, ((AnyObjectId)object).getName()), CorruptPackIndexException$ErrorType.MISSING_CRC);
                corruptPackIndexException.initCause(missingObjectException);
                throw corruptPackIndexException;
            }
        }
        for (Object object : packIndex) {
            if (objectIdOwnerMap.contains(((PackIndex$MutableEntry)object).toObjectId())) continue;
            throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().unknownObjectInIndex, ((PackIndex$MutableEntry)object).name()), CorruptPackIndexException$ErrorType.UNKNOWN_OBJ);
        }
    }

    public void overwriteObjectCount(long l2) {
        this.expectedObjectCount = l2;
    }
}

