/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.Strings$PatternState;
import org.eclipse.jgit.internal.JGitText;

public class Strings {
    static final List POSIX_CHAR_CLASSES = Arrays.asList("alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit", "word");
    private static final String DL = "\\p{javaDigit}\\p{javaLetter}";
    static final List JAVA_CHAR_CLASSES = Arrays.asList("\\p{Alnum}", "\\p{javaLetter}", "\\p{Blank}", "\\p{Cntrl}", "\\p{javaDigit}", "[\\p{Graph}\\p{javaDigit}\\p{javaLetter}]", "\\p{Ll}", "[\\p{Print}\\p{javaDigit}\\p{javaLetter}]", "\\p{Punct}", "\\p{Space}", "\\p{Lu}", "\\p{XDigit}", "[\\p{javaDigit}\\p{javaLetter}_]");
    static final Pattern UNSUPPORTED = Pattern.compile("\\[\\[[.=]\\w+[.=]\\]\\]");

    static char getPathSeparator(Character c2) {
        return c2 == null ? (char)'/' : (char)c2.charValue();
    }

    public static String stripTrailing(String string, char c2) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2) continue;
            if (i2 == string.length() - 1) {
                return string;
            }
            return string.substring(0, i2 + 1);
        }
        return "";
    }

    public static String stripTrailingWhitespace(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            if (i2 == string.length() - 1) {
                return string;
            }
            return string.substring(0, i2 + 1);
        }
        return "";
    }

    public static boolean isDirectoryPattern(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return c2 == '/';
        }
        return false;
    }

    static int count(String string, char c2, boolean bl2) {
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3 && (i2 = string.indexOf(c2, i2)) != -1; ++i2) {
            if (bl2 && (i2 == 0 || i2 == n3 - 1)) continue;
            ++n2;
        }
        return n2;
    }

    public static List split(String string, char c2) {
        int n2 = Strings.count(string, c2, true);
        if (n2 < 1) {
            throw new IllegalStateException("Pattern must have at least two segments: " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        int n3 = 0;
        while (true) {
            int n4 = ++n3;
            if ((n3 = string.indexOf(c2, n3)) == -1) {
                if (n4 >= string.length()) break;
                arrayList.add(string.substring(n4));
                break;
            }
            if (n3 - n4 <= 0) continue;
            if (n4 == 1) {
                arrayList.add(string.substring(n4 - 1, n3));
                continue;
            }
            if (n3 == string.length() - 1) {
                arrayList.add(string.substring(n4, n3 + 1));
                continue;
            }
            arrayList.add(string.substring(n4, n3));
        }
        return arrayList;
    }

    static boolean isWildCard(String string) {
        return string.indexOf(42) != -1 || Strings.isComplexWildcard(string);
    }

    private static boolean isComplexWildcard(String string) {
        int n2 = string.indexOf(91);
        if (n2 != -1) {
            return true;
        }
        if (string.indexOf(63) != -1) {
            return true;
        }
        int n3 = string.indexOf(92);
        if (n3 >= 0) {
            int n4 = n3 + 1;
            if (string.length() == n4) {
                return false;
            }
            char c2 = string.charAt(n4);
            return Strings.escapedByBackslash(c2);
        }
        return false;
    }

    private static boolean escapedByBackslash(char c2) {
        return c2 == '?' || c2 == '*' || c2 == '[';
    }

    static Strings$PatternState checkWildCards(String string) {
        if (Strings.isComplexWildcard(string)) {
            return Strings$PatternState.COMPLEX;
        }
        int n2 = string.indexOf(42);
        if (n2 < 0) {
            return Strings$PatternState.NONE;
        }
        if (n2 == string.length() - 1) {
            return Strings$PatternState.TRAILING_ASTERISK_ONLY;
        }
        if (string.lastIndexOf(42) == 0) {
            return Strings$PatternState.LEADING_ASTERISK_ONLY;
        }
        return Strings$PatternState.COMPLEX;
    }

    static Pattern convertGlob(String string) {
        if (UNSUPPORTED.matcher(string).find()) {
            throw new InvalidPatternException("Collating symbols [[.a.]] or equivalence class expressions [[=a=]] are not supported", string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        char[] cArray = new char[6];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '*': {
                    if (bl2 || n2 > 0) {
                        stringBuilder.append(c2);
                        break;
                    }
                    stringBuilder.append('.').append(c2);
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (bl2 || n2 > 0) {
                        stringBuilder.append(c2);
                        break;
                    }
                    stringBuilder.append('\\').append(c2);
                    break;
                }
                case '.': {
                    if (bl2) {
                        stringBuilder.append(c2);
                        break;
                    }
                    stringBuilder.append('\\').append('.');
                    break;
                }
                case '?': {
                    if (bl2 || n2 > 0) {
                        stringBuilder.append(c2);
                        break;
                    }
                    stringBuilder.append('.');
                    break;
                }
                case ':': {
                    if (n2 > 0 && Strings.lookBehind(stringBuilder) == '[' && Character.isLetter(Strings.lookAhead(string, i2))) {
                        bl4 = true;
                    }
                    stringBuilder.append(':');
                    break;
                }
                case '-': {
                    if (n2 > 0) {
                        if (Strings.lookAhead(string, i2) == ']') {
                            stringBuilder.append('\\').append(c2);
                            break;
                        }
                        stringBuilder.append(c2);
                        break;
                    }
                    stringBuilder.append('-');
                    break;
                }
                case '\\': {
                    char c3;
                    if (n2 > 0) {
                        c3 = Strings.lookAhead(string, i2);
                        if (c3 == ']' || c3 == '[') {
                            bl3 = true;
                        }
                    } else {
                        c3 = Strings.lookAhead(string, i2);
                        if (c3 != '\\' && c3 != '[' && c3 != '?' && c3 != '*' && c3 != ' ' && Strings.lookBehind(stringBuilder) != '\\') break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case '[': {
                    if (n2 > 0) {
                        if (!bl2) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append('[');
                        bl3 = true;
                        break;
                    }
                    if (!bl2) {
                        ++n2;
                        bl3 = false;
                    }
                    stringBuilder.append('[');
                    break;
                }
                case ']': {
                    if (bl2) {
                        stringBuilder.append(']');
                        bl3 = true;
                        break;
                    }
                    if (n2 <= 0) {
                        stringBuilder.append('\\').append(']');
                        bl3 = true;
                        break;
                    }
                    char c3 = Strings.lookBehind(stringBuilder);
                    if (c3 == '[' && !bl3 || c3 == '^') {
                        stringBuilder.append('\\');
                        stringBuilder.append(']');
                        bl3 = true;
                        break;
                    }
                    bl3 = false;
                    if (!bl4) {
                        --n2;
                        stringBuilder.append(']');
                        break;
                    }
                    bl4 = false;
                    String string2 = Strings.checkPosixCharClass(cArray);
                    if (string2 != null) {
                        stringBuilder.setLength(stringBuilder.length() - 4);
                        stringBuilder.append(string2);
                    }
                    Strings.reset(cArray);
                    break;
                }
                case '!': {
                    if (n2 > 0) {
                        if (Strings.lookBehind(stringBuilder) == '[') {
                            stringBuilder.append('^');
                            break;
                        }
                        stringBuilder.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                default: {
                    if (bl4) {
                        Strings.setNext(cArray, c2);
                        break;
                    }
                    stringBuilder.append(c2);
                }
            }
            bl2 = c2 == '\\';
        }
        if (n2 > 0) {
            throw new InvalidPatternException("Not closed bracket?", string);
        }
        try {
            return Pattern.compile(stringBuilder.toString(), 32);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new InvalidPatternException(MessageFormat.format(JGitText.get().invalidIgnoreRule, string), string, patternSyntaxException);
        }
    }

    private static char lookBehind(StringBuilder stringBuilder) {
        return stringBuilder.length() > 0 ? stringBuilder.charAt(stringBuilder.length() - 1) : (char)'\u0000';
    }

    private static char lookAhead(String string, int n2) {
        int n3 = n2 + 1;
        return n3 >= string.length() ? (char)'\u0000' : string.charAt(n3);
    }

    private static void setNext(char[] cArray, char c2) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '\u0000') continue;
            cArray[i2] = c2;
            break;
        }
    }

    private static void reset(char[] cArray) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = '\u0000';
        }
    }

    private static String checkPosixCharClass(char[] cArray) {
        for (int i2 = 0; i2 < POSIX_CHAR_CLASSES.size(); ++i2) {
            String string = (String)POSIX_CHAR_CLASSES.get(i2);
            boolean bl2 = true;
            for (int i3 = 0; i3 < string.length(); ++i3) {
                if (cArray[i3] == string.charAt(i3)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return (String)JAVA_CHAR_CLASSES.get(i2);
        }
        return null;
    }

    static String deleteBackslash(String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                if (i2 + 1 == string.length()) continue;
                char c3 = string.charAt(i2 + 1);
                if (c3 == '\\') {
                    stringBuilder.append(c2);
                    ++i2;
                    continue;
                }
                if (!Strings.escapedByBackslash(c3)) continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

