/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.ignore.IMatcher;
import org.eclipse.jgit.ignore.internal.AbstractMatcher;
import org.eclipse.jgit.ignore.internal.LeadingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.NameMatcher;
import org.eclipse.jgit.ignore.internal.Strings;
import org.eclipse.jgit.ignore.internal.Strings$PatternState;
import org.eclipse.jgit.ignore.internal.TrailingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.WildCardMatcher;
import org.eclipse.jgit.ignore.internal.WildMatcher;

public class PathMatcher
extends AbstractMatcher {
    private static final WildMatcher WILD_NO_DIRECTORY = new WildMatcher(false);
    private static final WildMatcher WILD_ONLY_DIRECTORY = new WildMatcher(true);
    private final List matchers;
    private final char slash;
    private final boolean beginning;

    private PathMatcher(String string, Character c2, boolean bl2) {
        super(string, bl2);
        this.slash = Strings.getPathSeparator(c2);
        this.beginning = string.indexOf(this.slash) == 0;
        this.matchers = this.isSimplePathWithSegments(string) ? null : PathMatcher.createMatchers(Strings.split(string, this.slash), c2, bl2);
    }

    private boolean isSimplePathWithSegments(String string) {
        return !Strings.isWildCard(string) && string.indexOf(92) < 0 && Strings.count(string, this.slash, true) > 0;
    }

    private static List createMatchers(List list, Character c2, boolean bl2) {
        ArrayList<IMatcher> arrayList = new ArrayList<IMatcher>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            IMatcher iMatcher = PathMatcher.createNameMatcher0(string, c2, bl2, i2 == list.size() - 1);
            if (i2 > 0) {
                IMatcher iMatcher2 = (IMatcher)arrayList.get(arrayList.size() - 1);
                if (PathMatcher.isWild(iMatcher) && PathMatcher.isWild(iMatcher2)) {
                    arrayList.remove(arrayList.size() - 1);
                }
            }
            arrayList.add(iMatcher);
        }
        return arrayList;
    }

    public static IMatcher createPathMatcher(String string, Character c2, boolean bl2) {
        char c3;
        int n2 = (string = PathMatcher.trim(string)).indexOf(c3 = Strings.getPathSeparator(c2), 1);
        if (n2 > 0 && n2 < string.length() - 1) {
            return new PathMatcher(string, c2, bl2);
        }
        return PathMatcher.createNameMatcher0(string, c2, bl2, true);
    }

    private static String trim(String string) {
        while (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
            if (string.length() > 1 && string.charAt(string.length() - 2) == '\\') {
                string = string.substring(0, string.length() - 2) + " ";
                return string;
            }
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static IMatcher createNameMatcher0(String string, Character c2, boolean bl2, boolean bl3) {
        if (string.startsWith("**") || string.startsWith("/**")) {
            while (string.contains("***")) {
                string = string.replace("***", "**");
            }
            if ("**".equals(string) || "/**".equals(string)) {
                return bl2 && bl3 ? WILD_ONLY_DIRECTORY : WILD_NO_DIRECTORY;
            }
        }
        Strings$PatternState strings$PatternState = Strings.checkWildCards(string);
        switch (strings$PatternState) {
            case LEADING_ASTERISK_ONLY: {
                return new LeadingAsteriskMatcher(string, c2, bl2);
            }
            case TRAILING_ASTERISK_ONLY: {
                return new TrailingAsteriskMatcher(string, c2, bl2);
            }
            case COMPLEX: {
                return new WildCardMatcher(string, c2, bl2);
            }
        }
        return new NameMatcher(string, c2, bl2, true);
    }

    @Override
    public boolean matches(String string, boolean bl2, boolean bl3) {
        if (this.matchers == null) {
            return this.simpleMatch(string, bl2, bl3);
        }
        return this.iterate(string, 0, string.length(), bl2, bl3);
    }

    private boolean simpleMatch(String string, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = string.indexOf(this.slash) == 0;
        if (this.beginning && !bl4) {
            string = this.slash + string;
        }
        if (!this.beginning && bl4) {
            string = string.substring(1);
        }
        if (string.equals(this.pattern)) {
            return !this.dirOnly || bl2;
        }
        String string2 = this.pattern + this.slash;
        if (bl3) {
            return string.equals(string2) && (!this.dirOnly || bl2);
        }
        return string.startsWith(string2);
    }

    @Override
    public boolean matches(String string, int n2, int n3) {
        throw new UnsupportedOperationException("Path matcher works only on entire paths");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean iterate(String string, int n2, int n3, boolean bl2, boolean bl3) {
        int n4 = 0;
        int n5 = n2;
        boolean bl4 = false;
        int n6 = -1;
        int n7 = -1;
        while (true) {
            int n8 = ++n5;
            if ((n5 = string.indexOf(this.slash, n5)) == -1) {
                if (n8 < n3) {
                    bl4 = this.matches(n4, string, n8, n3, bl2, bl3);
                } else {
                    if (!bl4) return false;
                    if (PathMatcher.isWild((IMatcher)this.matchers.get(n4))) return false;
                    boolean bl5 = true;
                    bl4 = bl5;
                }
                if (bl4) {
                    if (n4 < this.matchers.size() - 1 && PathMatcher.isWild((IMatcher)this.matchers.get(n4))) {
                        bl4 = this.matches(++n4, string, n8, n3, bl2, bl3);
                    } else if (this.dirOnly && !bl2) {
                        return false;
                    }
                }
                if (!bl4) return false;
                if (n4 + 1 != this.matchers.size()) return false;
                return true;
            }
            if (n7 < 0) {
                n7 = n5;
            }
            if (n5 - n8 <= 0) continue;
            bl4 = this.matches(n4, string, n8, n5, bl2, bl3);
            if (bl4) {
                boolean bl6 = PathMatcher.isWild((IMatcher)this.matchers.get(n4));
                if (bl6) {
                    n6 = n4;
                    n7 = -1;
                    n5 = n8 - 1;
                }
                if (++n4 == this.matchers.size()) {
                    if (!bl3) {
                        return true;
                    }
                    if (n5 == n3 - 1) {
                        if (!this.dirOnly) return true;
                        if (!bl2) return false;
                        return true;
                    }
                    if (bl6) {
                        return true;
                    }
                    if (n6 < 0) return false;
                    n4 = n6 + 1;
                    n5 = n7;
                    n7 = -1;
                }
            } else {
                if (n6 == -1) return false;
                n4 = n6 + 1;
                n5 = n7;
                n7 = -1;
            }
            ++n5;
        }
    }

    private boolean matches(int n2, String string, int n3, int n4, boolean bl2, boolean bl3) {
        IMatcher iMatcher = (IMatcher)this.matchers.get(n2);
        boolean bl4 = iMatcher.matches(string, n3, n4);
        if (!(bl4 && bl3 && n2 >= this.matchers.size() - 1 && iMatcher instanceof AbstractMatcher)) {
            return bl4;
        }
        return bl2 || !((AbstractMatcher)iMatcher).dirOnly;
    }

    private static boolean isWild(IMatcher iMatcher) {
        return iMatcher == WILD_NO_DIRECTORY || iMatcher == WILD_ONLY_DIRECTORY;
    }
}

