/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import org.eclipse.jgit.ignore.internal.AbstractMatcher;
import org.eclipse.jgit.ignore.internal.Strings;

public class NameMatcher
extends AbstractMatcher {
    final boolean beginning;
    final char slash;
    final String subPattern;

    NameMatcher(String string, Character c2, boolean bl2, boolean bl3) {
        super(string, bl2);
        this.slash = Strings.getPathSeparator(c2);
        if (bl3) {
            string = Strings.deleteBackslash(string);
        }
        this.beginning = string.length() == 0 ? false : string.charAt(0) == this.slash;
        this.subPattern = !this.beginning ? string : string.substring(1);
    }

    @Override
    public boolean matches(String string, boolean bl2, boolean bl3) {
        int n2 = 0;
        int n3 = string.length();
        if (n3 > 0 && string.charAt(0) == this.slash) {
            ++n2;
        }
        if (bl3) {
            boolean bl4;
            int n4 = string.lastIndexOf(this.slash, n3 - 1);
            if (n4 == n3 - 1) {
                n4 = string.lastIndexOf(this.slash, n4 - 1);
                --n3;
            }
            if (n4 < n2) {
                bl4 = this.matches(string, n2, n3);
            } else {
                boolean bl5 = bl4 = !this.beginning && this.matches(string, n4 + 1, n3);
            }
            if (bl4 && this.dirOnly) {
                bl4 = bl2;
            }
            return bl4;
        }
        while (n2 < n3) {
            int n5 = string.indexOf(this.slash, n2);
            if (n5 < 0) {
                n5 = n3;
            }
            if (n5 > n2 && this.matches(string, n2, n5)) {
                return !this.dirOnly || bl2 || n5 < n3;
            }
            if (this.beginning) break;
            n2 = n5 + 1;
        }
        return false;
    }

    @Override
    public boolean matches(String string, int n2, int n3) {
        String string2 = this.subPattern;
        int n4 = string2.length();
        if (n4 != n3 - n2) {
            return false;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2;
            char c3 = string2.charAt(i2);
            if (c3 == (c2 = string.charAt(i2 + n2))) continue;
            return false;
        }
        return true;
    }
}

