/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import org.eclipse.jgit.ignore.IgnoreNode$MatchResult;
import org.eclipse.jgit.internal.JGitText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreNode {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreNode.class);
    private final List rules;

    public IgnoreNode() {
        this(new ArrayList());
    }

    public IgnoreNode(List list) {
        this.rules = list;
    }

    public void parse(InputStream inputStream) {
        this.parse(null, inputStream);
    }

    public void parse(String string, InputStream inputStream) {
        String string2;
        BufferedReader bufferedReader = IgnoreNode.asReader(inputStream);
        int n2 = 1;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.length() > 0 && !string2.startsWith("#") && !string2.equals("/")) {
                FastIgnoreRule fastIgnoreRule = new FastIgnoreRule();
                try {
                    fastIgnoreRule.parse(string2);
                }
                catch (InvalidPatternException invalidPatternException) {
                    if (string != null) {
                        LOG.error(MessageFormat.format(JGitText.get().badIgnorePatternFull, string, Integer.toString(n2), invalidPatternException.getPattern(), invalidPatternException.getLocalizedMessage()), (Throwable)invalidPatternException);
                    }
                    LOG.error(MessageFormat.format(JGitText.get().badIgnorePattern, invalidPatternException.getPattern()), (Throwable)invalidPatternException);
                }
                if (!fastIgnoreRule.isEmpty()) {
                    this.rules.add(fastIgnoreRule);
                }
            }
            ++n2;
        }
    }

    private static BufferedReader asReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public List getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public IgnoreNode$MatchResult isIgnored(String string, boolean bl2) {
        Boolean bl3 = this.checkIgnored(string, bl2);
        if (bl3 == null) {
            return IgnoreNode$MatchResult.CHECK_PARENT;
        }
        return bl3 != false ? IgnoreNode$MatchResult.IGNORED : IgnoreNode$MatchResult.NOT_IGNORED;
    }

    @Nullable
    public Boolean checkIgnored(String string, boolean bl2) {
        for (int i2 = this.rules.size() - 1; i2 > -1; --i2) {
            FastIgnoreRule fastIgnoreRule = (FastIgnoreRule)this.rules.get(i2);
            if (!fastIgnoreRule.isMatch(string, bl2, true)) continue;
            return fastIgnoreRule.getResult();
        }
        return null;
    }

    public String toString() {
        return this.rules.toString();
    }
}

