/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;
import org.eclipse.jgit.ignore.internal.Strings;
import org.eclipse.jgit.internal.JGitText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastIgnoreRule {
    private static final Logger LOG = LoggerFactory.getLogger(FastIgnoreRule.class);
    public static final char PATH_SEPARATOR = '/';
    private IMatcher matcher = IMatcher.NO_MATCH;
    private boolean inverse;
    private boolean dirOnly;

    public FastIgnoreRule(String string) {
        this();
        try {
            this.parse(string);
        }
        catch (InvalidPatternException invalidPatternException) {
            LOG.error(MessageFormat.format(JGitText.get().badIgnorePattern, invalidPatternException.getPattern()), (Throwable)invalidPatternException);
        }
    }

    FastIgnoreRule() {
    }

    void parse(String string) {
        char c2;
        if (string == null) {
            throw new IllegalArgumentException("Pattern must not be null!");
        }
        if (string.length() == 0) {
            this.dirOnly = false;
            this.inverse = false;
            this.matcher = IMatcher.NO_MATCH;
            return;
        }
        boolean bl2 = this.inverse = string.charAt(0) == '!';
        if (this.inverse && (string = string.substring(1)).length() == 0) {
            this.dirOnly = false;
            this.matcher = IMatcher.NO_MATCH;
            return;
        }
        if (string.charAt(0) == '#') {
            this.matcher = IMatcher.NO_MATCH;
            this.dirOnly = false;
            return;
        }
        if (string.charAt(0) == '\\' && string.length() > 1 && ((c2 = string.charAt(1)) == '!' || c2 == '#')) {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\\') {
            this.matcher = IMatcher.NO_MATCH;
            this.dirOnly = false;
            return;
        }
        this.dirOnly = Strings.isDirectoryPattern(string);
        if (this.dirOnly) {
            string = Strings.stripTrailingWhitespace(string);
            if ((string = Strings.stripTrailing(string, '/')).length() == 0) {
                this.matcher = IMatcher.NO_MATCH;
                return;
            }
        }
        this.matcher = PathMatcher.createPathMatcher(string, Character.valueOf('/'), this.dirOnly);
    }

    public boolean isMatch(String string, boolean bl2) {
        return this.isMatch(string, bl2, false);
    }

    public boolean isMatch(String string, boolean bl2, boolean bl3) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        boolean bl4 = this.matcher.matches(string, bl2, bl3);
        return bl4;
    }

    public boolean getNameOnly() {
        return !(this.matcher instanceof PathMatcher);
    }

    public boolean dirOnly() {
        return this.dirOnly;
    }

    public boolean getNegation() {
        return this.inverse;
    }

    public boolean getResult() {
        return !this.inverse;
    }

    public boolean isEmpty() {
        return this.matcher == IMatcher.NO_MATCH;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.inverse) {
            stringBuilder.append('!');
        }
        stringBuilder.append(this.matcher);
        if (this.dirOnly) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.inverse ? 1231 : 1237);
        n3 = 31 * n3 + (this.dirOnly ? 1231 : 1237);
        n3 = 31 * n3 + (this.matcher == null ? 0 : this.matcher.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FastIgnoreRule)) {
            return false;
        }
        FastIgnoreRule fastIgnoreRule = (FastIgnoreRule)object;
        if (this.inverse != fastIgnoreRule.inverse) {
            return false;
        }
        if (this.dirOnly != fastIgnoreRule.dirOnly) {
            return false;
        }
        return this.matcher.equals(fastIgnoreRule.matcher);
    }
}

