/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.PrintStream;
import java.util.Collection;
import org.eclipse.jgit.hooks.GitHook;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public class PrePushHook
extends GitHook {
    public static final String NAME = "pre-push";
    private String remoteName;
    private String remoteLocation;
    private String refs;

    protected PrePushHook(Repository repository, PrintStream printStream) {
        super(repository, printStream);
    }

    protected PrePushHook(Repository repository, PrintStream printStream, PrintStream printStream2) {
        super(repository, printStream, printStream2);
    }

    @Override
    protected String getStdinArgs() {
        return this.refs;
    }

    @Override
    public String call() {
        if (this.canRun()) {
            this.doRun();
        }
        return "";
    }

    private boolean canRun() {
        return true;
    }

    @Override
    public String getHookName() {
        return NAME;
    }

    @Override
    protected String[] getParameters() {
        if (this.remoteName == null) {
            this.remoteName = this.remoteLocation;
        }
        return new String[]{this.remoteName, this.remoteLocation};
    }

    public void setRemoteName(String string) {
        this.remoteName = string;
    }

    protected String getRemoteName() {
        return this.remoteName;
    }

    public void setRemoteLocation(String string) {
        this.remoteLocation = string;
    }

    public void setRefs(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RemoteRefUpdate remoteRefUpdate : collection) {
            stringBuilder.append(remoteRefUpdate.getSrcRef());
            stringBuilder.append(" ");
            stringBuilder.append(remoteRefUpdate.getNewObjectId().getName());
            stringBuilder.append(" ");
            stringBuilder.append(remoteRefUpdate.getRemoteName());
            stringBuilder.append(" ");
            ObjectId objectId = remoteRefUpdate.getExpectedOldObjectId();
            stringBuilder.append(objectId == null ? ObjectId.zeroId().getName() : objectId.getName());
            stringBuilder.append("\n");
        }
        this.refs = stringBuilder.toString();
    }
}

